/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.scopes.JdkScope;
import com.intellij.openapi.module.impl.scopes.LibraryRuntimeClasspathScope;
import com.intellij.openapi.module.impl.scopes.ModulesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SdkResolveScopeProvider;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryScopeCache {
    private final LibrariesOnlyScope myLibrariesOnlyScope;
    private final Project myProject;
    private final ConcurrentMap<Module[], GlobalSearchScope> myLibraryScopes = ContainerUtil.newConcurrentMap((TObjectHashingStrategy)new TObjectHashingStrategy<Module[]>(){

        public int computeHashCode(Module[] object) {
            return Arrays.hashCode(object);
        }

        public boolean equals(Module[] o1, Module[] o2) {
            return Arrays.equals(o1, o2);
        }
    });
    private final ConcurrentMap<String, GlobalSearchScope> mySdkScopes = ContainerUtil.newConcurrentMap();
    private final Map<List<OrderEntry>, GlobalSearchScope> myLibraryResolveScopeCache = new ConcurrentFactoryMap<List<OrderEntry>, GlobalSearchScope>(){

        @Nullable
        protected GlobalSearchScope create(@NotNull List<OrderEntry> key2) {
            return LibraryScopeCache.this.calcLibraryScope(key2);
        }
    };
    private final Map<List<OrderEntry>, GlobalSearchScope> myLibraryUseScopeCache = new ConcurrentFactoryMap<List<OrderEntry>, GlobalSearchScope>(){

        @Nullable
        protected GlobalSearchScope create(@NotNull List<OrderEntry> key2) {
            return LibraryScopeCache.this.calcLibraryUseScope(key2);
        }
    };

    public static LibraryScopeCache getInstance(Project project2) {
        return (LibraryScopeCache)ServiceManager.getService((Project)project2, LibraryScopeCache.class);
    }

    public LibraryScopeCache(Project project2) {
        this.myProject = project2;
        this.myLibrariesOnlyScope = new LibrariesOnlyScope(GlobalSearchScope.allScope((Project)this.myProject), this.myProject);
    }

    void clear() {
        this.myLibraryScopes.clear();
        this.mySdkScopes.clear();
        this.myLibraryResolveScopeCache.clear();
        this.myLibraryUseScopeCache.clear();
    }

    @NotNull
    public GlobalSearchScope getLibrariesOnlyScope() {
        return this.myLibrariesOnlyScope;
    }

    @NotNull
    private GlobalSearchScope getScopeForLibraryUsedIn(@NotNull List<Module> modulesLibraryIsUsedIn) {
        Module[] array = modulesLibraryIsUsedIn.toArray(Module.EMPTY_ARRAY);
        GlobalSearchScope scope = (GlobalSearchScope)this.myLibraryScopes.get(array);
        return scope != null ? scope : (GlobalSearchScope)ConcurrencyUtil.cacheOrGet(this.myLibraryScopes, (Object)array, (Object)((Object)new LibraryRuntimeClasspathScope(this.myProject, modulesLibraryIsUsedIn)));
    }

    @NotNull
    public GlobalSearchScope getLibraryScope(@NotNull List<OrderEntry> orderEntries) {
        return this.myLibraryResolveScopeCache.get(orderEntries);
    }

    @NotNull
    public GlobalSearchScope getLibraryUseScope(@NotNull List<OrderEntry> orderEntries) {
        return this.myLibraryUseScopeCache.get(orderEntries);
    }

    @NotNull
    private GlobalSearchScope calcLibraryScope(@NotNull List<OrderEntry> orderEntries) {
        LibrariesOnlyScope allCandidates;
        ArrayList<Module> modulesLibraryUsedIn = new ArrayList<Module>();
        LibraryOrderEntry lib = null;
        for (OrderEntry entry : orderEntries) {
            if (entry instanceof JdkOrderEntry) {
                return this.getScopeForSdk((JdkOrderEntry)entry);
            }
            if (entry instanceof LibraryOrderEntry) {
                lib = (LibraryOrderEntry)entry;
                modulesLibraryUsedIn.add(entry.getOwnerModule());
                continue;
            }
            if (!(entry instanceof ModuleOrderEntry)) continue;
            modulesLibraryUsedIn.add(entry.getOwnerModule());
        }
        Comparator comparator2 = (o1, o2) -> o1.getName().compareTo(o2.getName());
        Collections.sort(modulesLibraryUsedIn, comparator2);
        List uniquesList = ContainerUtil.removeDuplicatesFromSorted(modulesLibraryUsedIn, (Comparator)comparator2);
        LibrariesOnlyScope librariesOnlyScope = allCandidates = uniquesList.isEmpty() ? this.myLibrariesOnlyScope : this.getScopeForLibraryUsedIn(uniquesList);
        if (lib != null) {
            final LibraryRuntimeClasspathScope preferred = new LibraryRuntimeClasspathScope(this.myProject, lib);
            return new DelegatingGlobalSearchScope(allCandidates, new Object[]{preferred}){

                public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                    boolean c1 = preferred.contains(file1);
                    boolean c2 = preferred.contains(file2);
                    if (c1 && !c2) {
                        return 1;
                    }
                    if (c2 && !c1) {
                        return -1;
                    }
                    return super.compare(file1, file2);
                }
            };
        }
        return allCandidates;
    }

    @NotNull
    public GlobalSearchScope getScopeForSdk(@NotNull JdkOrderEntry jdkOrderEntry) {
        String jdkName = jdkOrderEntry.getJdkName();
        if (jdkName == null) {
            return GlobalSearchScope.allScope((Project)this.myProject);
        }
        GlobalSearchScope scope = (GlobalSearchScope)this.mySdkScopes.get(jdkName);
        if (scope == null) {
            SdkResolveScopeProvider provider2;
            SdkResolveScopeProvider[] sdkResolveScopeProviderArray = (SdkResolveScopeProvider[])SdkResolveScopeProvider.EP_NAME.getExtensions();
            int n = sdkResolveScopeProviderArray.length;
            for (int j = 0; j < n && (scope = (provider2 = sdkResolveScopeProviderArray[j]).getScope(this.myProject, jdkOrderEntry)) == null; ++j) {
            }
            if (scope == null) {
                scope = new JdkScope(this.myProject, jdkOrderEntry);
            }
            return (GlobalSearchScope)ConcurrencyUtil.cacheOrGet(this.mySdkScopes, (Object)jdkName, (Object)scope);
        }
        return scope;
    }

    @NotNull
    private GlobalSearchScope calcLibraryUseScope(@NotNull List<OrderEntry> entries) {
        THashSet modulesWithLibrary = new THashSet(entries.size());
        THashSet modulesWithSdk = new THashSet(entries.size());
        for (OrderEntry entry : entries) {
            (entry instanceof JdkOrderEntry ? modulesWithSdk : modulesWithLibrary).add(entry.getOwnerModule());
        }
        modulesWithSdk.removeAll((Collection<?>)modulesWithLibrary);
        if (modulesWithSdk.size() + modulesWithLibrary.size() == ModuleManager.getInstance((Project)this.myProject).getModules().length) {
            return GlobalSearchScope.allScope((Project)this.myProject);
        }
        ArrayList united = ContainerUtil.newArrayList();
        if (!modulesWithSdk.isEmpty()) {
            united.add(new ModulesScope((Set<Module>)modulesWithSdk, this.myProject));
            united.add(this.myLibrariesOnlyScope.intersectWith(new LibraryRuntimeClasspathScope(this.myProject, (Collection<Module>)modulesWithSdk)));
        } else {
            united.add(this.myLibrariesOnlyScope);
        }
        for (Module module2 : modulesWithLibrary) {
            united.add(GlobalSearchScope.moduleWithDependentsScope((Module)module2));
        }
        return GlobalSearchScope.union((GlobalSearchScope[])united.toArray(new GlobalSearchScope[united.size()]));
    }

    private static class LibrariesOnlyScope
    extends GlobalSearchScope {
        private final GlobalSearchScope myOriginal;
        private final ProjectFileIndex myIndex;

        private LibrariesOnlyScope(@NotNull GlobalSearchScope original, @NotNull Project project2) {
            super(project2);
            this.myIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
            this.myOriginal = original;
        }

        public boolean contains(@NotNull VirtualFile file2) {
            return this.myOriginal.contains(file2) && (this.myIndex.isInLibraryClasses(file2) || this.myIndex.isInLibrarySource(file2));
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            return this.myOriginal.compare(file1, file2);
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return false;
        }

        public boolean isSearchOutsideRootModel() {
            return this.myOriginal.isSearchOutsideRootModel();
        }

        public boolean isSearchInLibraries() {
            return true;
        }
    }
}

