/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.FileIndexBase;
import com.intellij.openapi.roots.impl.RootIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ModuleFileIndexImpl
extends FileIndexBase
implements ModuleFileIndex {
    private final Module myModule;

    public ModuleFileIndexImpl(Module module2, DirectoryIndex directoryIndex) {
        super(directoryIndex, FileTypeRegistry.getInstance());
        this.myModule = module2;
    }

    public boolean iterateContent(@NotNull ContentIterator processor2) {
        Set contentRoots = (Set)ReadAction.compute(() -> {
            VirtualFile[][] allRoots;
            if (this.myModule.isDisposed()) {
                return Collections.emptySet();
            }
            LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
            VirtualFile[][] virtualFileArray = allRoots = ModuleFileIndexImpl.getModuleContentAndSourceRoots(this.myModule);
            int n = virtualFileArray.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile[] roots;
                for (VirtualFile root : roots = virtualFileArray[i]) {
                    DirectoryInfo parentInfo;
                    VirtualFile parent;
                    DirectoryInfo info = this.getInfoForFileOrDirectory(root);
                    if (!info.isInProject() || (parent = root.getParent()) != null && (parentInfo = this.myDirectoryIndex.getInfoForFile(parent)).isInProject() && this.myModule.equals(parentInfo.getModule())) continue;
                    result2.add(root);
                }
            }
            return result2;
        });
        for (VirtualFile contentRoot : contentRoots) {
            if (this.iterateContentUnderDirectory(contentRoot, processor2)) continue;
            return false;
        }
        return true;
    }

    public boolean isInContent(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInProject() && this.myModule.equals(info.getModule());
    }

    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInModuleSource() && this.myModule.equals(info.getModule());
    }

    @NotNull
    public List<OrderEntry> getOrderEntriesForFile(@NotNull VirtualFile fileOrDir) {
        return ModuleFileIndexImpl.findAllOrderEntriesWithOwnerModule(this.myModule, this.myDirectoryIndex.getOrderEntries(this.getInfoForFileOrDirectory(fileOrDir)));
    }

    public OrderEntry getOrderEntryForFile(@NotNull VirtualFile fileOrDir) {
        return ModuleFileIndexImpl.findOrderEntryWithOwnerModule(this.myModule, this.myDirectoryIndex.getOrderEntries(this.getInfoForFileOrDirectory(fileOrDir)));
    }

    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInModuleSource() && this.myModule.equals(info.getModule()) && JavaModuleSourceRootTypes.isTestSourceOrResource(this.myDirectoryIndex.getSourceRootType(info));
    }

    public boolean isUnderSourceRootOfType(@NotNull VirtualFile fileOrDir, @NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInModuleSource() && this.myModule.equals(info.getModule()) && rootTypes.contains(this.myDirectoryIndex.getSourceRootType(info));
    }

    @Override
    protected boolean isScopeDisposed() {
        return this.myModule.isDisposed();
    }

    @Nullable
    static OrderEntry findOrderEntryWithOwnerModule(@NotNull Module ownerModule, @NotNull List<OrderEntry> orderEntries) {
        if (orderEntries.size() < 10) {
            for (OrderEntry orderEntry : orderEntries) {
                if (orderEntry.getOwnerModule() != ownerModule) continue;
                return orderEntry;
            }
            return null;
        }
        int index = Collections.binarySearch(orderEntries, new FakeOrderEntry(ownerModule), RootIndex.BY_OWNER_MODULE);
        return index < 0 ? null : orderEntries.get(index);
    }

    @NotNull
    private static List<OrderEntry> findAllOrderEntriesWithOwnerModule(@NotNull Module ownerModule, @NotNull List<OrderEntry> entries) {
        int lastIndex;
        if (entries.size() == 0) {
            return Collections.emptyList();
        }
        if (entries.size() == 1) {
            OrderEntry entry = entries.get(0);
            return entry.getOwnerModule() == ownerModule ? ContainerUtil.newArrayList(entries) : Collections.emptyList();
        }
        int index = Collections.binarySearch(entries, new FakeOrderEntry(ownerModule), RootIndex.BY_OWNER_MODULE);
        if (index < 0) {
            return Collections.emptyList();
        }
        int firstIndex = index;
        while (firstIndex - 1 >= 0 && entries.get(firstIndex - 1).getOwnerModule() == ownerModule) {
            --firstIndex;
        }
        for (lastIndex = index + 1; lastIndex < entries.size() && entries.get(lastIndex).getOwnerModule() == ownerModule; ++lastIndex) {
        }
        return ContainerUtil.newArrayList(entries.subList(firstIndex, lastIndex));
    }

    private static class FakeOrderEntry
    implements OrderEntry {
        private final Module myOwnerModule;

        public FakeOrderEntry(Module ownerModule) {
            this.myOwnerModule = ownerModule;
        }

        @NotNull
        public VirtualFile[] getFiles(OrderRootType type2) {
            throw new IncorrectOperationException();
        }

        @NotNull
        public String[] getUrls(OrderRootType rootType) {
            throw new IncorrectOperationException();
        }

        @NotNull
        public String getPresentableName() {
            throw new IncorrectOperationException();
        }

        public boolean isValid() {
            throw new IncorrectOperationException();
        }

        @NotNull
        public Module getOwnerModule() {
            return this.myOwnerModule;
        }

        public <R> R accept(RootPolicy<R> policy, @Nullable R initialValue) {
            throw new IncorrectOperationException();
        }

        public int compareTo(@NotNull OrderEntry o) {
            throw new IncorrectOperationException();
        }

        public boolean isSynthetic() {
            throw new IncorrectOperationException();
        }
    }
}

