/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.impl.ModuleOrderEnumerator;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootConfigurationAccessor;
import com.intellij.openapi.roots.impl.RootModelComponentBase;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableRunnable;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ModuleRootManagerImpl
extends ModuleRootManager
implements Disposable {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.ModuleRootManagerImpl");
    private final Module myModule;
    private final ProjectRootManagerImpl myProjectRootManager;
    private final VirtualFilePointerManager myFilePointerManager;
    protected RootModelImpl myRootModel;
    private boolean myIsDisposed = false;
    private boolean myLoaded = false;
    private final OrderRootsCache myOrderRootsCache;
    private final Map<RootModelImpl, Throwable> myModelCreations = new THashMap();
    protected volatile long myModificationCount;

    public ModuleRootManagerImpl(Module module2, ProjectRootManagerImpl projectRootManager, VirtualFilePointerManager filePointerManager) {
        this.myModule = module2;
        this.myProjectRootManager = projectRootManager;
        this.myFilePointerManager = filePointerManager;
        this.myRootModel = new RootModelImpl(this, this.myProjectRootManager, this.myFilePointerManager);
        this.myOrderRootsCache = new OrderRootsCache((Disposable)module2);
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public ModuleFileIndex getFileIndex() {
        return (ModuleFileIndex)ModuleServiceManager.getService((Module)this.myModule, ModuleFileIndex.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.myRootModel.dispose();
        this.myIsDisposed = true;
        if (Disposer.isDebugMode()) {
            ArrayList<Map.Entry<RootModelImpl, Throwable>> entries;
            Map<RootModelImpl, Throwable> map2 = this.myModelCreations;
            synchronized (map2) {
                entries = new ArrayList<Map.Entry<RootModelImpl, Throwable>>(this.myModelCreations.entrySet());
            }
            for (Map.Entry entry : entries) {
                LOG.warn("\n***********************************************************************************************\n***                        R O O T   M O D E L   N O T   D I S P O S E D                    ***\n***********************************************************************************************\nCreated at:", (Throwable)entry.getValue());
                ((RootModelImpl)entry.getKey()).dispose();
            }
        }
    }

    @NotNull
    public ModifiableRootModel getModifiableModel() {
        return this.getModifiableModel(new RootConfigurationAccessor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ModifiableRootModel getModifiableModel(RootConfigurationAccessor accessor) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        RootModelImpl model = new RootModelImpl(this.myRootModel, this, true, accessor, this.myFilePointerManager, this.myProjectRootManager){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispose() {
                super.dispose();
                Throwable created = null;
                if (Disposer.isDebugMode()) {
                    Map object = ModuleRootManagerImpl.this.myModelCreations;
                    synchronized (object) {
                        created = (Throwable)ModuleRootManagerImpl.this.myModelCreations.remove(this);
                    }
                }
                for (OrderEntry entry : ModuleRootManagerImpl.this.getOrderEntries()) {
                    assert (!((RootModelComponentBase)entry).isDisposed()) : entry + "(" + entry.getClass() + ") in " + ModuleRootManagerImpl.this.myRootModel + " is already disposed." + (created == null ? "" : "\nThis modifiable model was created at:\n" + ExceptionUtil.getThrowableText((Throwable)created));
                }
            }
        };
        if (Disposer.isDebugMode()) {
            Map<RootModelImpl, Throwable> map2 = this.myModelCreations;
            synchronized (map2) {
                this.myModelCreations.put(model, new Throwable());
            }
        }
        return model;
    }

    void makeRootsChange(@NotNull Runnable runnable2) {
        ProjectRootManagerEx projectRootManagerEx = (ProjectRootManagerEx)ProjectRootManager.getInstance((Project)this.myModule.getProject());
        projectRootManagerEx.makeRootsChange(runnable2, false, this.myModule.isLoaded());
    }

    public RootModelImpl getRootModel() {
        return this.myRootModel;
    }

    @NotNull
    public ContentEntry[] getContentEntries() {
        return this.myRootModel.getContentEntries();
    }

    @NotNull
    public OrderEntry[] getOrderEntries() {
        return this.myRootModel.getOrderEntries();
    }

    public Sdk getSdk() {
        return this.myRootModel.getSdk();
    }

    public boolean isSdkInherited() {
        return this.myRootModel.isSdkInherited();
    }

    void commitModel(RootModelImpl rootModel) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LOG.assertTrue(rootModel.myModuleRootManager == this);
        boolean changed = rootModel.isChanged();
        Project project2 = this.myModule.getProject();
        ModifiableModuleModel moduleModel = ModuleManager.getInstance((Project)project2).getModifiableModel();
        ModifiableModelCommitter.multiCommit(Collections.singletonList(rootModel), moduleModel);
        if (changed) {
            this.stateChanged();
        }
    }

    static void doCommit(RootModelImpl rootModel) {
        rootModel.docommit();
        rootModel.dispose();
        try {
            ((ModuleRootManagerImpl)ModuleRootManagerImpl.getInstance((Module)rootModel.getModule())).stateChanged();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public Module[] getDependencies() {
        return this.myRootModel.getModuleDependencies();
    }

    @NotNull
    public Module[] getDependencies(boolean includeTests) {
        return this.myRootModel.getModuleDependencies(includeTests);
    }

    @NotNull
    public Module[] getModuleDependencies() {
        return this.myRootModel.getModuleDependencies();
    }

    @NotNull
    public Module[] getModuleDependencies(boolean includeTests) {
        return this.myRootModel.getModuleDependencies(includeTests);
    }

    public boolean isDependsOn(Module module2) {
        return this.myRootModel.isDependsOn(module2);
    }

    @NotNull
    public String[] getDependencyModuleNames() {
        return this.myRootModel.getDependencyModuleNames();
    }

    public <T> T getModuleExtension(Class<T> klass) {
        return this.myRootModel.getModuleExtension(klass);
    }

    public <R> R processOrder(RootPolicy<R> policy, R initialValue) {
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.processOrder(policy, initialValue);
    }

    @NotNull
    public OrderEnumerator orderEntries() {
        return new ModuleOrderEnumerator(this.myRootModel, this.myOrderRootsCache);
    }

    public static OrderRootsEnumerator getCachingEnumeratorForType(OrderRootType type2, Module module2) {
        return ModuleRootManagerImpl.getEnumeratorForType(type2, module2).usingCache();
    }

    @NotNull
    private static OrderRootsEnumerator getEnumeratorForType(OrderRootType type2, Module module2) {
        OrderEnumerator base = OrderEnumerator.orderEntries((Module)module2);
        if (type2 == OrderRootType.CLASSES) {
            return base.exportedOnly().withoutModuleSourceEntries().recursively().classes();
        }
        if (type2 == OrderRootType.SOURCES) {
            return base.exportedOnly().recursively().sources();
        }
        return base.roots(type2);
    }

    @NotNull
    public VirtualFile[] getContentRoots() {
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.getContentRoots();
    }

    @NotNull
    public String[] getContentRootUrls() {
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.getContentRootUrls();
    }

    @NotNull
    public String[] getExcludeRootUrls() {
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.getExcludeRootUrls();
    }

    @NotNull
    public VirtualFile[] getExcludeRoots() {
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.getExcludeRoots();
    }

    @NotNull
    public String[] getSourceRootUrls() {
        return this.getSourceRootUrls(true);
    }

    @NotNull
    public String[] getSourceRootUrls(boolean includingTests) {
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.getSourceRootUrls(includingTests);
    }

    @NotNull
    public VirtualFile[] getSourceRoots() {
        return this.getSourceRoots(true);
    }

    @NotNull
    public VirtualFile[] getSourceRoots(boolean includingTests) {
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.getSourceRoots(includingTests);
    }

    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull JpsModuleSourceRootType<?> rootType) {
        return this.myRootModel.getSourceRoots(rootType);
    }

    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        return this.myRootModel.getSourceRoots(rootTypes);
    }

    public void dropCaches() {
        this.myOrderRootsCache.clearCache();
    }

    public ModuleRootManagerState getState() {
        if (Registry.is((String)"store.track.module.root.manager.changes", (boolean)false)) {
            LOG.error("getState, module " + this.myModule.getName());
        }
        return new ModuleRootManagerState(this.myRootModel);
    }

    public void loadState(ModuleRootManagerState object) {
        this.loadState(object, this.myLoaded || this.myModule.isLoaded());
        this.myLoaded = true;
    }

    protected void loadState(ModuleRootManagerState object, boolean throwEvent) {
        ThrowableRunnable r = () -> {
            RootModelImpl newModel = new RootModelImpl(object.getRootModelElement(), this, this.myProjectRootManager, this.myFilePointerManager, throwEvent);
            if (throwEvent) {
                this.makeRootsChange(() -> ModuleRootManagerImpl.doCommit(newModel));
            } else {
                this.myRootModel.dispose();
                this.myRootModel = newModel;
            }
            assert (!this.myRootModel.isOrderEntryDisposed());
        };
        try {
            if (throwEvent) {
                WriteAction.run((ThrowableRunnable)r);
            } else {
                ReadAction.run((ThrowableRunnable)r);
            }
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public void stateChanged() {
        if (Registry.is((String)"store.track.module.root.manager.changes", (boolean)false)) {
            LOG.error("ModelRootManager state changed");
        }
        ++this.myModificationCount;
    }

    public static class ModuleRootManagerState
    implements JDOMExternalizable {
        private RootModelImpl myRootModel;
        private Element myRootModelElement;

        public ModuleRootManagerState() {
        }

        public ModuleRootManagerState(RootModelImpl rootModel) {
            this.myRootModel = rootModel;
        }

        public void readExternal(Element element) {
            this.myRootModelElement = element;
        }

        public void writeExternal(Element element) {
            this.myRootModel.writeExternal(element);
        }

        public Element getRootModelElement() {
            return this.myRootModelElement;
        }
    }
}

