/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.OrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ModuleSourceOrderEntryImpl
extends OrderEntryBaseImpl
implements ModuleSourceOrderEntry,
WritableOrderEntry,
ClonableOrderEntry {
    @NonNls
    static final String ENTRY_TYPE = "sourceFolder";
    @NonNls
    private static final String ATTRIBUTE_FOR_TESTS = "forTests";

    ModuleSourceOrderEntryImpl(RootModelImpl rootModel) {
        super(rootModel);
    }

    ModuleSourceOrderEntryImpl(Element element, RootModelImpl rootModel) throws InvalidDataException {
        super(rootModel);
        if (!element.getName().equals("orderEntry")) {
            throw new InvalidDataException();
        }
    }

    @Override
    public void writeExternal(Element rootElement) throws WriteExternalException {
        Element element = OrderEntryFactory.createOrderEntryElement(ENTRY_TYPE);
        element.setAttribute("type", ENTRY_TYPE);
        element.setAttribute(ATTRIBUTE_FOR_TESTS, Boolean.FALSE.toString());
        rootElement.addContent(element);
    }

    public boolean isValid() {
        return !this.isDisposed();
    }

    @NotNull
    public Module getOwnerModule() {
        return this.getRootModel().getModule();
    }

    public <R> R accept(RootPolicy<R> policy, R initialValue) {
        return (R)policy.visitModuleSourceOrderEntry((ModuleSourceOrderEntry)this, initialValue);
    }

    @NotNull
    public String getPresentableName() {
        return ProjectBundle.message((String)"project.root.module.source", (Object[])new Object[0]);
    }

    @NotNull
    public VirtualFile[] getFiles(OrderRootType type2) {
        if (OrderRootType.SOURCES.equals((Object)type2)) {
            return this.getRootModel().getSourceRoots();
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    @NotNull
    public String[] getUrls(OrderRootType type2) {
        ArrayList<String> result2 = new ArrayList<String>();
        if (OrderRootType.SOURCES.equals((Object)type2)) {
            for (ContentEntry contentEntry : this.getRootModel().getContentEntries()) {
                for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
                    result2.add(sourceFolder.getUrl());
                }
            }
            return ArrayUtil.toStringArray(result2);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public OrderEntry cloneEntry(RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager, VirtualFilePointerManager filePointerManager) {
        return new ModuleSourceOrderEntryImpl(rootModel);
    }

    public boolean isSynthetic() {
        return true;
    }
}

