/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ModuleOrderEntryImpl;
import com.intellij.openapi.roots.impl.OrderEnumeratorBase;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class OrderRootsEnumeratorImpl
implements OrderRootsEnumerator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.OrderRootsEnumeratorImpl");
    private final OrderEnumeratorBase myOrderEnumerator;
    private final OrderRootType myRootType;
    private final NotNullFunction<OrderEntry, OrderRootType> myRootTypeProvider;
    private boolean myUsingCache;
    private NotNullFunction<OrderEntry, VirtualFile[]> myCustomRootProvider;
    private boolean myWithoutSelfModuleOutput;

    public OrderRootsEnumeratorImpl(OrderEnumeratorBase orderEnumerator, @NotNull OrderRootType rootType) {
        this.myOrderEnumerator = orderEnumerator;
        this.myRootType = rootType;
        this.myRootTypeProvider = null;
    }

    public OrderRootsEnumeratorImpl(OrderEnumeratorBase orderEnumerator, @NotNull NotNullFunction<OrderEntry, OrderRootType> rootTypeProvider) {
        this.myOrderEnumerator = orderEnumerator;
        this.myRootTypeProvider = rootTypeProvider;
        this.myRootType = null;
    }

    @NotNull
    public VirtualFile[] getRoots() {
        if (this.myUsingCache) {
            this.checkCanUseCache();
            OrderRootsCache cache2 = this.myOrderEnumerator.getCache();
            if (cache2 != null) {
                int flags = this.myOrderEnumerator.getFlags();
                VirtualFile[] cached = cache2.getCachedRoots(this.myRootType, flags);
                if (cached == null) {
                    return cache2.setCachedRoots(this.myRootType, flags, this.computeRootsUrls()).getFiles();
                }
                return cached;
            }
        }
        return VfsUtilCore.toVirtualFileArray(this.computeRoots());
    }

    @NotNull
    public String[] getUrls() {
        if (this.myUsingCache) {
            this.checkCanUseCache();
            OrderRootsCache cache2 = this.myOrderEnumerator.getCache();
            if (cache2 != null) {
                int flags = this.myOrderEnumerator.getFlags();
                String[] cached = cache2.getCachedUrls(this.myRootType, flags);
                if (cached == null) {
                    return cache2.setCachedRoots(this.myRootType, flags, this.computeRootsUrls()).getUrls();
                }
                return cached;
            }
        }
        return ArrayUtil.toStringArray(this.computeRootsUrls());
    }

    private void checkCanUseCache() {
        LOG.assertTrue(this.myRootTypeProvider == null, (Object)"Caching not supported for OrderRootsEnumerator with root type provider");
        LOG.assertTrue(this.myCustomRootProvider == null, (Object)"Caching not supported for OrderRootsEnumerator with 'usingCustomRootProvider' option");
        LOG.assertTrue(!this.myWithoutSelfModuleOutput, (Object)"Caching not supported for OrderRootsEnumerator with 'withoutSelfModuleOutput' option");
    }

    private Collection<VirtualFile> computeRoots() {
        LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
        this.myOrderEnumerator.forEach((PairProcessor<OrderEntry, List<OrderEnumerationHandler>>)((PairProcessor)(orderEntry, customHandlers) -> {
            OrderRootType type2 = this.getRootType((OrderEntry)orderEntry);
            if (orderEntry instanceof ModuleSourceOrderEntry) {
                this.collectModuleRoots(type2, ((ModuleSourceOrderEntry)orderEntry).getRootModel(), (Collection<VirtualFile>)result2, true, !this.myOrderEnumerator.isProductionOnly(), (List<OrderEnumerationHandler>)customHandlers);
            } else if (orderEntry instanceof ModuleOrderEntry) {
                ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)orderEntry;
                Module module2 = moduleOrderEntry.getModule();
                if (module2 != null) {
                    ModuleRootModel rootModel = this.myOrderEnumerator.getRootModel(module2);
                    boolean productionOnTests = orderEntry instanceof ModuleOrderEntryImpl && ((ModuleOrderEntryImpl)orderEntry).isProductionOnTestDependency();
                    boolean includeTests = !this.myOrderEnumerator.isProductionOnly() && this.myOrderEnumerator.shouldIncludeTestsFromDependentModulesToTestClasspath((List<OrderEnumerationHandler>)customHandlers) || productionOnTests;
                    this.collectModuleRoots(type2, rootModel, (Collection<VirtualFile>)result2, !productionOnTests, includeTests, (List<OrderEnumerationHandler>)customHandlers);
                }
            } else {
                if (this.myCustomRootProvider != null) {
                    Collections.addAll(result2, (Object[])this.myCustomRootProvider.fun(orderEntry));
                    return true;
                }
                if (this.myOrderEnumerator.addCustomRootsForLibrary((OrderEntry)orderEntry, type2, (Collection<VirtualFile>)result2, (List<OrderEnumerationHandler>)customHandlers)) {
                    return true;
                }
                Collections.addAll(result2, orderEntry.getFiles(type2));
            }
            return true;
        }));
        return result2;
    }

    @NotNull
    private Collection<String> computeRootsUrls() {
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        this.myOrderEnumerator.forEach((PairProcessor<OrderEntry, List<OrderEnumerationHandler>>)((PairProcessor)(orderEntry, customHandlers) -> {
            OrderRootType type2 = this.getRootType((OrderEntry)orderEntry);
            if (orderEntry instanceof ModuleSourceOrderEntry) {
                this.collectModuleRootsUrls(type2, ((ModuleSourceOrderEntry)orderEntry).getRootModel(), result2, true, !this.myOrderEnumerator.isProductionOnly());
            } else if (orderEntry instanceof ModuleOrderEntry) {
                ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)orderEntry;
                Module module2 = moduleOrderEntry.getModule();
                if (module2 != null) {
                    ModuleRootModel rootModel = this.myOrderEnumerator.getRootModel(module2);
                    boolean productionOnTests = orderEntry instanceof ModuleOrderEntryImpl && ((ModuleOrderEntryImpl)orderEntry).isProductionOnTestDependency();
                    boolean includeTests = !this.myOrderEnumerator.isProductionOnly() && this.myOrderEnumerator.shouldIncludeTestsFromDependentModulesToTestClasspath((List<OrderEnumerationHandler>)customHandlers) || productionOnTests;
                    this.collectModuleRootsUrls(type2, rootModel, result2, !productionOnTests, includeTests);
                }
            } else {
                if (this.myOrderEnumerator.addCustomRootUrlsForLibrary((OrderEntry)orderEntry, type2, (Collection<String>)result2, (List<OrderEnumerationHandler>)customHandlers)) {
                    return true;
                }
                Collections.addAll(result2, orderEntry.getUrls(type2));
            }
            return true;
        }));
        return result2;
    }

    @NotNull
    public PathsList getPathsList() {
        PathsList list = new PathsList();
        this.collectPaths(list);
        return list;
    }

    public void collectPaths(@NotNull PathsList list) {
        list.addVirtualFiles(this.getRoots());
    }

    @NotNull
    public OrderRootsEnumerator usingCache() {
        this.myUsingCache = true;
        return this;
    }

    @NotNull
    public OrderRootsEnumerator withoutSelfModuleOutput() {
        this.myWithoutSelfModuleOutput = true;
        return this;
    }

    @NotNull
    public OrderRootsEnumerator usingCustomRootProvider(@NotNull NotNullFunction<OrderEntry, VirtualFile[]> provider2) {
        this.myCustomRootProvider = provider2;
        return this;
    }

    private void collectModuleRoots(OrderRootType type2, ModuleRootModel rootModel, Collection<VirtualFile> result2, boolean includeProduction, boolean includeTests, List<OrderEnumerationHandler> customHandlers) {
        CompilerModuleExtension extension;
        if (type2.equals((Object)OrderRootType.SOURCES)) {
            if (includeProduction) {
                Collections.addAll(result2, rootModel.getSourceRoots(includeTests));
            } else {
                result2.addAll(rootModel.getSourceRoots(JavaModuleSourceRootTypes.TESTS));
            }
        } else if (type2.equals((Object)OrderRootType.CLASSES) && (extension = (CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class)) != null) {
            if (this.myWithoutSelfModuleOutput && this.myOrderEnumerator.isRootModuleModel(rootModel)) {
                if (includeTests && includeProduction) {
                    Collections.addAll(result2, extension.getOutputRoots(false));
                }
            } else if (includeProduction) {
                Collections.addAll(result2, extension.getOutputRoots(includeTests));
            } else {
                ContainerUtil.addIfNotNull(result2, (Object)extension.getCompilerOutputPathForTests());
            }
        }
        this.myOrderEnumerator.addCustomRootsForModule(type2, rootModel, result2, includeProduction, includeTests, customHandlers);
    }

    private void collectModuleRootsUrls(OrderRootType type2, ModuleRootModel rootModel, Collection<String> result2, boolean includeProduction, boolean includeTests) {
        CompilerModuleExtension extension;
        if (type2.equals((Object)OrderRootType.SOURCES)) {
            if (includeProduction) {
                Collections.addAll(result2, rootModel.getSourceRootUrls(includeTests));
            } else {
                for (ContentEntry entry : rootModel.getContentEntries()) {
                    for (SourceFolder folder : entry.getSourceFolders(JavaModuleSourceRootTypes.TESTS)) {
                        result2.add(folder.getUrl());
                    }
                }
            }
        } else if (type2.equals((Object)OrderRootType.CLASSES) && (extension = (CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class)) != null) {
            if (this.myWithoutSelfModuleOutput && this.myOrderEnumerator.isRootModuleModel(rootModel)) {
                if (includeTests && includeProduction) {
                    Collections.addAll(result2, extension.getOutputRootUrls(false));
                }
            } else if (includeProduction) {
                Collections.addAll(result2, extension.getOutputRootUrls(includeTests));
            } else {
                ContainerUtil.addIfNotNull(result2, (Object)extension.getCompilerOutputUrlForTests());
            }
        }
    }

    private OrderRootType getRootType(OrderEntry e) {
        return this.myRootType != null ? this.myRootType : (OrderRootType)this.myRootTypeProvider.fun((Object)e);
    }
}

