/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageDirectoryCache {
    private final MultiMap<String, VirtualFile> myRootsByPackagePrefix;
    private final Map<String, PackageInfo> myDirectoriesByPackageNameCache = ContainerUtil.newConcurrentMap();
    private final Set<String> myNonExistentPackages = ContainerUtil.newConcurrentSet();

    public PackageDirectoryCache(@NotNull MultiMap<String, VirtualFile> rootsByPackagePrefix) {
        this.myRootsByPackagePrefix = rootsByPackagePrefix;
    }

    public void onLowMemory() {
        this.myNonExistentPackages.clear();
    }

    @NotNull
    public List<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName) {
        PackageInfo info = this.getPackageInfo(packageName);
        return info == null ? Collections.emptyList() : info.myPackageDirectories;
    }

    @Nullable
    private PackageInfo getPackageInfo(@NotNull String packageName) {
        PackageInfo info = this.myDirectoriesByPackageNameCache.get(packageName);
        if (info == null) {
            if (this.myNonExistentPackages.contains(packageName)) {
                return null;
            }
            if (packageName.length() > Registry.intValue((String)"java.max.package.name.length") || StringUtil.containsAnyChar((String)packageName, (String)";[/")) {
                return null;
            }
            List result2 = ContainerUtil.newSmartList();
            if (StringUtil.isNotEmpty((String)packageName) && !StringUtil.startsWithChar((CharSequence)packageName, (char)'.')) {
                int i2 = packageName.lastIndexOf(46);
                while (true) {
                    PackageInfo parentInfo;
                    if ((parentInfo = this.getPackageInfo(i2 > 0 ? packageName.substring(0, i2) : "")) != null) {
                        result2.addAll(parentInfo.getSubPackageDirectories(packageName.substring(i2 + 1)));
                    }
                    if (i2 < 0) break;
                    i2 = packageName.lastIndexOf(46, i2 - 1);
                }
            }
            for (VirtualFile file2 : this.myRootsByPackagePrefix.get((Object)packageName)) {
                if (!file2.isDirectory()) continue;
                result2.add(file2);
            }
            if (!result2.isEmpty()) {
                info = new PackageInfo(packageName, result2);
                this.myDirectoriesByPackageNameCache.put(packageName, info);
            } else {
                this.myNonExistentPackages.add(packageName);
            }
        }
        return info;
    }

    public Set<String> getSubpackageNames(@NotNull String packageName) {
        PackageInfo info = this.getPackageInfo(packageName);
        return info == null ? Collections.emptySet() : Collections.unmodifiableSet(((MultiMap)info.mySubPackages.getValue()).keySet());
    }

    protected boolean isPackageDirectory(@NotNull VirtualFile dir, @NotNull String packageName) {
        return true;
    }

    private class PackageInfo {
        final String myQname;
        final List<VirtualFile> myPackageDirectories;
        final NotNullLazyValue<MultiMap<String, VirtualFile>> mySubPackages = new VolatileNotNullLazyValue<MultiMap<String, VirtualFile>>(){

            @NotNull
            protected MultiMap<String, VirtualFile> compute() {
                MultiMap result2 = MultiMap.createLinked();
                for (VirtualFile directory : PackageInfo.this.myPackageDirectories) {
                    for (VirtualFile child : directory.getChildren()) {
                        String packageName;
                        String childName = child.getName();
                        String string = packageName = PackageInfo.this.myQname.isEmpty() ? childName : PackageInfo.this.myQname + "." + childName;
                        if (!child.isDirectory() || !PackageDirectoryCache.this.isPackageDirectory(child, packageName)) continue;
                        result2.putValue((Object)childName, (Object)child);
                    }
                }
                return result2;
            }
        };

        PackageInfo(String qname, List<VirtualFile> packageDirectories) {
            this.myQname = qname;
            this.myPackageDirectories = packageDirectories;
        }

        @NotNull
        Collection<VirtualFile> getSubPackageDirectories(String shortName) {
            return ((MultiMap)this.mySubPackages.getValue()).get((Object)shortName);
        }
    }
}

