/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectFileIndexFacade
extends FileIndexFacade {
    private final DirectoryIndex myDirectoryIndex;
    private final ProjectFileIndex myFileIndex;

    public ProjectFileIndexFacade(Project project2, ProjectRootManager rootManager, DirectoryIndex directoryIndex) {
        super(project2);
        this.myDirectoryIndex = directoryIndex;
        this.myFileIndex = rootManager.getFileIndex();
    }

    public boolean isInContent(@NotNull VirtualFile file2) {
        return this.myFileIndex.isInContent(file2);
    }

    public boolean isInSource(@NotNull VirtualFile file2) {
        return this.myFileIndex.isInSource(file2);
    }

    public boolean isInSourceContent(@NotNull VirtualFile file2) {
        return this.myFileIndex.isInSourceContent(file2);
    }

    public boolean isInLibraryClasses(@NotNull VirtualFile file2) {
        return this.myFileIndex.isInLibraryClasses(file2);
    }

    public boolean isInLibrarySource(@NotNull VirtualFile file2) {
        return this.myFileIndex.isInLibrarySource(file2);
    }

    public boolean isExcludedFile(@NotNull VirtualFile file2) {
        return this.myFileIndex.isExcluded(file2);
    }

    public boolean isUnderIgnored(@NotNull VirtualFile file2) {
        return this.myFileIndex.isUnderIgnored(file2);
    }

    @Nullable
    public Module getModuleForFile(@NotNull VirtualFile file2) {
        return this.myFileIndex.getModuleForFile(file2);
    }

    public boolean isValidAncestor(@NotNull VirtualFile baseDir, @NotNull VirtualFile childDir) {
        if (!childDir.isDirectory()) {
            childDir = childDir.getParent();
        }
        while (childDir != null) {
            if (childDir.equals(baseDir)) {
                return true;
            }
            if (!this.myDirectoryIndex.getInfoForFile(childDir).isInProject()) {
                return false;
            }
            childDir = childDir.getParent();
        }
        return false;
    }

    @NotNull
    public ModificationTracker getRootModificationTracker() {
        return ProjectRootManager.getInstance((Project)this.myProject);
    }
}

