/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ClonableContentFolder;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.ContentFolderBaseImpl;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.model.serialization.module.JpsModuleRootModelSerializer;

public class SourceFolderImpl
extends ContentFolderBaseImpl
implements SourceFolder,
ClonableContentFolder {
    private JpsModuleSourceRoot myJpsElement;
    @NonNls
    public static final String ELEMENT_NAME = "sourceFolder";
    @NonNls
    public static final String TEST_SOURCE_ATTR = "isTestSource";
    static final String DEFAULT_PACKAGE_PREFIX = "";

    SourceFolderImpl(@NotNull VirtualFile file2, @NotNull JpsModuleSourceRoot jpsElement, @NotNull ContentEntryImpl contentEntry) {
        super(file2, contentEntry);
        this.myJpsElement = jpsElement;
    }

    public SourceFolderImpl(@NotNull JpsModuleSourceRoot jpsElement, @NotNull ContentEntryImpl contentEntry) {
        super(jpsElement.getUrl(), contentEntry);
        this.myJpsElement = jpsElement;
    }

    SourceFolderImpl(Element element, ContentEntryImpl contentEntry) throws InvalidDataException {
        super(element, contentEntry);
        this.myJpsElement = JpsModuleRootModelSerializer.loadSourceRoot((Element)element);
    }

    private SourceFolderImpl(SourceFolderImpl that, ContentEntryImpl contentEntry) {
        super(that, contentEntry);
        this.myJpsElement = SourceFolderImpl.createCopy(that, that.myJpsElement.asTyped());
    }

    private static <P extends JpsElement> JpsModuleSourceRoot createCopy(SourceFolderImpl that, JpsTypedModuleSourceRoot<P> jpsElement) {
        return JpsElementFactory.getInstance().createModuleSourceRoot(that.getUrl(), jpsElement.getRootType(), jpsElement.getProperties().getBulkModificationSupport().createCopy());
    }

    public boolean isTestSource() {
        return this.getRootType().equals((Object)JavaSourceRootType.TEST_SOURCE) || this.getRootType().equals((Object)JavaResourceRootType.TEST_RESOURCE);
    }

    @NotNull
    public String getPackagePrefix() {
        JavaSourceRootProperties properties = this.getJavaProperties();
        if (properties != null) {
            return properties.getPackagePrefix();
        }
        JavaResourceRootProperties resourceJavaProperties = this.getResourceJavaProperties();
        if (resourceJavaProperties != null) {
            return resourceJavaProperties.getRelativeOutputPath().replace('/', '.');
        }
        return DEFAULT_PACKAGE_PREFIX;
    }

    @Nullable
    private JavaSourceRootProperties getJavaProperties() {
        return (JavaSourceRootProperties)this.myJpsElement.getProperties(JavaModuleSourceRootTypes.SOURCES);
    }

    @Nullable
    private JavaResourceRootProperties getResourceJavaProperties() {
        return (JavaResourceRootProperties)this.myJpsElement.getProperties(JavaModuleSourceRootTypes.RESOURCES);
    }

    public void setPackagePrefix(@NotNull String packagePrefix) {
        JavaSourceRootProperties properties = this.getJavaProperties();
        if (properties != null) {
            properties.setPackagePrefix(packagePrefix);
        }
    }

    @NotNull
    public JpsModuleSourceRootType<?> getRootType() {
        return this.myJpsElement.getRootType();
    }

    @Override
    public ContentFolder cloneFolder(ContentEntry contentEntry) {
        assert (!((ContentEntryImpl)contentEntry).isDisposed()) : "target entry already disposed: " + contentEntry;
        assert (!this.isDisposed()) : "Already disposed: " + this;
        return new SourceFolderImpl(this, (ContentEntryImpl)contentEntry);
    }

    @NotNull
    public JpsModuleSourceRoot getJpsElement() {
        return this.myJpsElement;
    }

    private boolean isForGeneratedSources() {
        JavaSourceRootProperties properties = this.getJavaProperties();
        JavaResourceRootProperties resourceJavaProperties = this.getResourceJavaProperties();
        return properties != null && properties.isForGeneratedSources() || resourceJavaProperties != null && resourceJavaProperties.isForGeneratedSources();
    }

    @Override
    public int compareTo(ContentFolderBaseImpl folder) {
        if (!(folder instanceof SourceFolderImpl)) {
            return -1;
        }
        int i = super.compareTo(folder);
        if (i != 0) {
            return i;
        }
        SourceFolderImpl sourceFolder = (SourceFolderImpl)folder;
        i = this.getPackagePrefix().compareTo(sourceFolder.getPackagePrefix());
        if (i != 0) {
            return i;
        }
        i = Boolean.valueOf(this.isTestSource()).compareTo(sourceFolder.isTestSource());
        if (i != 0) {
            return i;
        }
        i = Boolean.valueOf(this.isForGeneratedSources()).compareTo(sourceFolder.isForGeneratedSources());
        if (i != 0) {
            return i;
        }
        return this.myJpsElement.getRootType().getClass().getName().compareTo(sourceFolder.getRootType().getClass().getName());
    }
}

