/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.storage;

import com.intellij.ProjectTopics;
import com.intellij.application.options.PathMacrosCollector;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerKt;
import com.intellij.configurationStore.StorageManagerListener;
import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.roots.impl.storage.ClasspathStorageProvider;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClasspathStorage
extends StateStorageBase<Boolean> {
    private static final Key<Boolean> ERROR_NOTIFIED_KEY = Key.create((String)"ClasspathStorage.ERROR_NOTIFIED_KEY");
    private static final Logger LOG = Logger.getInstance(ClasspathStorage.class);
    private final ClasspathStorageProvider.ClasspathConverter myConverter;
    private final TrackingPathMacroSubstitutor myPathMacroSubstitutor;

    public ClasspathStorage(final @NotNull Module module2, @NotNull StateStorageManager storageManager2) {
        String storageType = module2.getOptionValue("classpath");
        if (storageType == null) {
            throw new IllegalStateException("Classpath storage requires non-default storage type");
        }
        ClasspathStorageProvider provider2 = ClasspathStorage.getProvider(storageType);
        if (provider2 == null) {
            if (module2.getUserData(ERROR_NOTIFIED_KEY) == null) {
                Notification n = new Notification(StorageUtilKt.getNOTIFICATION_GROUP_ID(), "Cannot load module '" + module2.getName() + "'", "Support for " + storageType + " format is not installed.", NotificationType.ERROR);
                n.notify(module2.getProject());
                module2.putUserData(ERROR_NOTIFIED_KEY, (Object)Boolean.TRUE);
                LOG.info("Classpath storage provider " + storageType + " not found");
            }
            this.myConverter = new MissingClasspathConverter();
        } else {
            this.myConverter = provider2.createConverter(module2);
        }
        this.myPathMacroSubstitutor = storageManager2.getMacroSubstitutor();
        final List<String> paths = this.myConverter.getFilePaths();
        MessageBusConnection busConnection = module2.getMessageBus().connect();
        busConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                for (VFileEvent vFileEvent : events) {
                    if (!vFileEvent.isFromRefresh() || !(vFileEvent instanceof VFileContentChangeEvent)) continue;
                    for (String path : paths) {
                        if (!path.equals(vFileEvent.getPath())) continue;
                        ((StorageManagerListener)module2.getMessageBus().syncPublisher(StateStorageManagerKt.getSTORAGE_TOPIC())).storageFileChanged(vFileEvent, ClasspathStorage.this, (ComponentManager)module2);
                        return;
                    }
                }
            }
        });
        busConnection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void modulesRenamed(@NotNull Project project2, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
                for (Module renamedModule : modules) {
                    ClasspathStorageProvider provider2;
                    if (!renamedModule.equals(module2) || (provider2 = ClasspathStorage.getProvider(ClassPathStorageUtil.getStorageType(module2))) == null) continue;
                    provider2.moduleRenamed(module2, (String)oldNameProvider.fun((Object)module2), module2.getName());
                    provider2.modulePathChanged(module2);
                }
            }
        });
    }

    @Override
    @Nullable
    public <S> S deserializeState(@Nullable Element serializedState, @NotNull Class<S> stateClass, @Nullable S mergeInto) {
        if (serializedState == null) {
            return null;
        }
        ModuleRootManagerImpl.ModuleRootManagerState state = new ModuleRootManagerImpl.ModuleRootManagerState();
        state.readExternal(serializedState);
        return (S)state;
    }

    @Override
    protected boolean hasState(@NotNull Boolean storageData, @NotNull String componentName) {
        return storageData == false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Element getSerializedState(@NotNull Boolean storageData, Object component, @NotNull String componentName, boolean archive) {
        if (storageData.booleanValue()) {
            return null;
        }
        Element element = new Element("component");
        ModifiableRootModel model = null;
        AccessToken token = ReadAction.start();
        try {
            model = ((ModuleRootManagerImpl)((Object)component)).getModifiableModel();
            model.clear();
            try {
                this.myConverter.readClasspath(model);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ((RootModelImpl)model).writeExternal(element);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        finally {
            try {
                token.finish();
            }
            finally {
                if (model != null) {
                    model.dispose();
                }
            }
        }
        if (this.myPathMacroSubstitutor != null) {
            this.myPathMacroSubstitutor.expandPaths(element);
            this.myPathMacroSubstitutor.addUnknownMacros("NewModuleRootManager", PathMacrosCollector.getMacroNames(element));
        }
        this.getStorageDataRef().set(true);
        return element;
    }

    @Override
    @NotNull
    protected Boolean loadData() {
        return false;
    }

    @NotNull
    public StateStorage.ExternalizationSession startExternalization() {
        return this.myConverter.startExternalization();
    }

    public void analyzeExternalChangesAndUpdateIfNeed(@NotNull Set<String> componentNames) {
        componentNames.add("NewModuleRootManager");
        this.getStorageDataRef().set(false);
    }

    @Nullable
    public static ClasspathStorageProvider getProvider(@NotNull String type2) {
        if (type2.equals("default")) {
            return null;
        }
        for (ClasspathStorageProvider provider2 : (ClasspathStorageProvider[])ClasspathStorageProvider.EXTENSION_POINT_NAME.getExtensions()) {
            if (!type2.equals(provider2.getID())) continue;
            return provider2;
        }
        return null;
    }

    @NotNull
    public static String getStorageRootFromOptions(@NotNull Module module2) {
        String moduleRoot = ModuleUtilCore.getModuleDirPath((Module)module2);
        String storageRef = module2.getOptionValue("classpath-dir");
        if (storageRef == null) {
            return moduleRoot;
        }
        storageRef = FileUtil.toSystemIndependentName((String)storageRef);
        if (SystemInfo.isWindows ? FileUtil.isAbsolutePlatformIndependent((String)storageRef) : FileUtil.isUnixAbsolutePath((String)storageRef)) {
            return storageRef;
        }
        return moduleRoot + '/' + storageRef;
    }

    public static void setStorageType(@NotNull ModuleRootModel model, @NotNull String storageId) {
        Module module2 = model.getModule();
        String oldStorageType = ClassPathStorageUtil.getStorageType(module2);
        if (oldStorageType.equals(storageId)) {
            return;
        }
        ClasspathStorageProvider provider2 = ClasspathStorage.getProvider(oldStorageType);
        if (provider2 != null) {
            provider2.detach(module2);
        }
        if ((provider2 = ClasspathStorage.getProvider(storageId)) == null) {
            module2.clearOption("classpath");
            module2.clearOption("classpath-dir");
        } else {
            module2.setOption("classpath", storageId);
            String root = provider2.getContentRoot(model);
            if (root == null) {
                module2.clearOption("classpath-dir");
            } else {
                module2.setOption("classpath-dir", root);
            }
        }
    }

    public static void modulePathChanged(Module module2, String newPath) {
        ClasspathStorageProvider provider2 = ClasspathStorage.getProvider(ClassPathStorageUtil.getStorageType(module2));
        if (provider2 != null) {
            provider2.modulePathChanged(module2);
        }
    }

    private static class MissingClasspathConverter
    implements ClasspathStorageProvider.ClasspathConverter {
        private MissingClasspathConverter() {
        }

        @Override
        @NotNull
        public List<String> getFilePaths() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public StateStorage.ExternalizationSession startExternalization() {
            return new StateStorage.ExternalizationSession(){

                public void setState(@Nullable Object component, @NotNull String componentName, @NotNull Object state) {
                }

                @Nullable
                public StateStorage.SaveSession createSaveSession() {
                    return null;
                }
            };
        }

        @Override
        public void readClasspath(@NotNull ModifiableRootModel model) throws IOException {
        }
    }
}

