/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries.ui;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.RootFilter;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class FileTypeBasedRootFilter
extends RootFilter {
    private final FileType myFileType;

    public FileTypeBasedRootFilter(OrderRootType rootType, boolean jarDirectory, @NotNull FileType fileType, String presentableRootTypeName) {
        super(rootType, jarDirectory, presentableRootTypeName);
        this.myFileType = fileType;
    }

    @Override
    public boolean isAccepted(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
        if (this.isJarDirectory()) {
            if (!rootCandidate.isDirectory() || !rootCandidate.isInLocalFileSystem()) {
                return false;
            }
            for (VirtualFile child : rootCandidate.getChildren()) {
                VirtualFile jarRoot;
                if (child.isDirectory() || !child.getFileType().equals(FileTypes.ARCHIVE) || (jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(child)) == null || !this.containsFileOfType(jarRoot, progressIndicator)) continue;
                return true;
            }
            return false;
        }
        return this.containsFileOfType(rootCandidate, progressIndicator);
    }

    private boolean containsFileOfType(VirtualFile rootCandidate, ProgressIndicator progressIndicator) {
        return !VfsUtil.processFilesRecursively((VirtualFile)rootCandidate, virtualFile -> {
            progressIndicator.checkCanceled();
            if (virtualFile.isDirectory()) {
                progressIndicator.setText2(virtualFile.getPath());
                return true;
            }
            return !this.isFileAccepted((VirtualFile)virtualFile);
        });
    }

    protected boolean isFileAccepted(VirtualFile virtualFile) {
        return virtualFile.getFileType().equals(this.myFileType);
    }
}

