/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.FileAppearanceService;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.roots.ui.util.HttpUrlCellAppearance;
import com.intellij.openapi.roots.ui.util.JarSubfileCellAppearance;
import com.intellij.openapi.roots.ui.util.SimpleTextCellAppearance;
import com.intellij.openapi.roots.ui.util.ValidFileCellAppearance;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.ui.HtmlListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.PlatformIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FileAppearanceServiceImpl
extends FileAppearanceService {
    private static CellAppearanceEx EMPTY = new CellAppearanceEx(){

        public void customize(@NotNull SimpleColoredComponent component) {
        }

        public void customize(@NotNull HtmlListCellRenderer renderer) {
        }

        @NotNull
        public String getText() {
            return "";
        }
    };

    @NotNull
    public CellAppearanceEx empty() {
        return EMPTY;
    }

    @NotNull
    public CellAppearanceEx forVirtualFile(@NotNull VirtualFile file2) {
        if (!file2.isValid()) {
            return this.forInvalidUrl(file2.getPresentableUrl());
        }
        VirtualFileSystem fileSystem = file2.getFileSystem();
        if (fileSystem.getProtocol().equals("jar")) {
            return new JarSubfileCellAppearance(file2);
        }
        if (fileSystem instanceof HttpFileSystem) {
            return new HttpUrlCellAppearance(file2);
        }
        if (file2.isDirectory()) {
            return SimpleTextCellAppearance.regular((String)file2.getPresentableUrl(), (Icon)PlatformIcons.FOLDER_ICON);
        }
        return new ValidFileCellAppearance(file2);
    }

    @NotNull
    public CellAppearanceEx forIoFile(@NotNull File file2) {
        String absolutePath = file2.getAbsolutePath();
        if (!file2.exists()) {
            return this.forInvalidUrl(absolutePath);
        }
        if (file2.isDirectory()) {
            return SimpleTextCellAppearance.regular((String)absolutePath, (Icon)PlatformIcons.FOLDER_ICON);
        }
        String name = file2.getName();
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(name);
        File parent = file2.getParentFile();
        CompositeAppearance appearance = CompositeAppearance.textComment((String)name, (String)parent.getAbsolutePath());
        appearance.setIcon(fileType.getIcon());
        return appearance;
    }

    @NotNull
    public CellAppearanceEx forInvalidUrl(@NotNull String text) {
        return SimpleTextCellAppearance.invalid((String)text, (Icon)PlatformIcons.INVALID_ENTRY_ICON);
    }
}

