/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.FileAppearanceService;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.roots.ui.util.SimpleTextCellAppearance;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import java.awt.Color;
import java.io.File;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrderEntryAppearanceServiceImpl
extends OrderEntryAppearanceService {
    private static final Icon EXCLUDE_FOLDER_ICON = IconLoader.getDisabledIcon((Icon)PlatformIcons.FOLDER_ICON);
    private static final String NO_JDK = ProjectBundle.message((String)"jdk.missing.item", (Object[])new Object[0]);

    @NotNull
    public CellAppearanceEx forOrderEntry(Project project2, @NotNull OrderEntry orderEntry, boolean selected) {
        if (orderEntry instanceof JdkOrderEntry) {
            JdkOrderEntry jdkLibraryEntry = (JdkOrderEntry)orderEntry;
            Sdk jdk2 = jdkLibraryEntry.getJdk();
            if (!orderEntry.isValid()) {
                String oldJdkName = jdkLibraryEntry.getJdkName();
                return FileAppearanceService.getInstance().forInvalidUrl(oldJdkName != null ? oldJdkName : NO_JDK);
            }
            return this.forJdk(jdk2, false, selected, true);
        }
        if (!orderEntry.isValid()) {
            return FileAppearanceService.getInstance().forInvalidUrl(orderEntry.getPresentableName());
        }
        if (orderEntry instanceof LibraryOrderEntry) {
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
            if (!libraryOrderEntry.isValid()) {
                return FileAppearanceService.getInstance().forInvalidUrl(orderEntry.getPresentableName());
            }
            Library library = libraryOrderEntry.getLibrary();
            assert (library != null) : libraryOrderEntry;
            return this.forLibrary(project2, library, !((LibraryEx)library).getInvalidRootUrls(OrderRootType.CLASSES).isEmpty());
        }
        if (orderEntry.isSynthetic()) {
            String presentableName = orderEntry.getPresentableName();
            Icon icon = orderEntry instanceof ModuleSourceOrderEntry ? OrderEntryAppearanceServiceImpl.sourceFolderIcon(false) : null;
            return new SimpleTextCellAppearance(presentableName, icon, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
        }
        if (orderEntry instanceof ModuleOrderEntry) {
            Icon icon = ModuleType.get((Module)((ModuleOrderEntry)orderEntry).getModule()).getIcon();
            return SimpleTextCellAppearance.regular((String)orderEntry.getPresentableName(), (Icon)icon);
        }
        return CompositeAppearance.single((String)orderEntry.getPresentableName());
    }

    @NotNull
    public CellAppearanceEx forLibrary(Project project2, @NotNull Library library, boolean hasInvalidRoots) {
        StructureConfigurableContext context = ProjectStructureConfigurable.getInstance(project2).getContext();
        Icon icon = LibraryPresentationManager.getInstance().getCustomIcon(library, context);
        String name = library.getName();
        if (name != null) {
            return OrderEntryAppearanceServiceImpl.normalOrRedWaved(name, icon != null ? icon : PlatformIcons.LIBRARY_ICON, hasInvalidRoots);
        }
        String[] files = library.getUrls(OrderRootType.CLASSES);
        if (files.length == 0) {
            return SimpleTextCellAppearance.invalid((String)ProjectBundle.message((String)"library.empty.library.item", (Object[])new Object[0]), (Icon)PlatformIcons.LIBRARY_ICON);
        }
        if (files.length == 1) {
            return OrderEntryAppearanceServiceImpl.forVirtualFilePointer(new LightFilePointer(files[0]));
        }
        String url = StringUtil.trimEnd((String)files[0], (String)"!/");
        String text = ProjectBundle.message((String)"library.unnamed.text", (Object[])new Object[]{PathUtil.getFileName((String)url), files.length - 1});
        return SimpleTextCellAppearance.regular((String)text, (Icon)PlatformIcons.LIBRARY_ICON);
    }

    @NotNull
    public CellAppearanceEx forJdk(@Nullable Sdk jdk2, boolean isInComboBox, boolean selected, boolean showVersion) {
        String versionString;
        if (jdk2 == null) {
            return FileAppearanceService.getInstance().forInvalidUrl(NO_JDK);
        }
        String name = jdk2.getName();
        CompositeAppearance appearance = new CompositeAppearance();
        SdkType sdkType = (SdkType)jdk2.getSdkType();
        appearance.setIcon(sdkType.getIcon());
        SimpleTextAttributes attributes = OrderEntryAppearanceServiceImpl.getTextAttributes(sdkType.sdkHasValidPath(jdk2), selected);
        CompositeAppearance.DequeEnd ending = appearance.getEnding();
        ending.addText(name, attributes);
        if (showVersion && (versionString = jdk2.getVersionString()) != null && !versionString.equals(name)) {
            SimpleTextAttributes textAttributes = isInComboBox && !selected ? SimpleTextAttributes.SYNTHETIC_ATTRIBUTES : (SystemInfo.isMac && selected ? new SimpleTextAttributes(0, Color.WHITE) : SimpleTextAttributes.GRAY_ATTRIBUTES);
            ending.addComment(versionString, textAttributes);
        }
        return ending.getAppearance();
    }

    private static SimpleTextAttributes getTextAttributes(boolean valid, boolean selected) {
        if (!valid) {
            return SimpleTextAttributes.ERROR_ATTRIBUTES;
        }
        if (!(!selected || SystemInfo.isWinVistaOrNewer && UIManager.getLookAndFeel().getName().contains("Windows"))) {
            return SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES;
        }
        return SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
    }

    @NotNull
    public CellAppearanceEx forContentFolder(@NotNull ContentFolder folder) {
        if (folder instanceof SourceFolder) {
            return OrderEntryAppearanceServiceImpl.formatRelativePath(folder, PlatformIcons.FOLDER_ICON);
        }
        if (folder instanceof ExcludeFolder) {
            return OrderEntryAppearanceServiceImpl.formatRelativePath(folder, EXCLUDE_FOLDER_ICON);
        }
        throw new RuntimeException(folder.getClass().getName());
    }

    @NotNull
    public CellAppearanceEx forModule(@NotNull Module module2) {
        return SimpleTextCellAppearance.regular((String)module2.getName(), (Icon)ModuleType.get((Module)module2).getIcon());
    }

    @NotNull
    private static Icon sourceFolderIcon(boolean testSource) {
        return testSource ? PlatformIcons.TEST_SOURCE_FOLDER : PlatformIcons.SOURCE_FOLDERS_ICON;
    }

    @NotNull
    private static CellAppearanceEx normalOrRedWaved(@NotNull String text, @Nullable Icon icon, boolean waved) {
        return waved ? new SimpleTextCellAppearance(text, icon, new SimpleTextAttributes(8, null, (Color)JBColor.RED)) : SimpleTextCellAppearance.regular((String)text, (Icon)icon);
    }

    @NotNull
    private static CellAppearanceEx forVirtualFilePointer(@NotNull LightFilePointer filePointer) {
        VirtualFile file2 = filePointer.getFile();
        return file2 != null ? FileAppearanceService.getInstance().forVirtualFile(file2) : FileAppearanceService.getInstance().forInvalidUrl(filePointer.getPresentableUrl());
    }

    @NotNull
    private static CellAppearanceEx formatRelativePath(@NotNull ContentFolder folder, @NotNull Icon icon) {
        SimpleTextAttributes textAttributes;
        String relativePath;
        LightFilePointer folderFile = new LightFilePointer(folder.getUrl());
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(folder.getContentEntry().getUrl());
        if (file2 == null) {
            return FileAppearanceService.getInstance().forInvalidUrl(folderFile.getPresentableUrl());
        }
        String contentPath = file2.getPath();
        VirtualFile folderFileFile = folderFile.getFile();
        if (folderFileFile == null) {
            String absolutePath = folderFile.getPresentableUrl();
            relativePath = absolutePath.startsWith(contentPath) ? absolutePath.substring(contentPath.length()) : absolutePath;
            textAttributes = SimpleTextAttributes.ERROR_ATTRIBUTES;
        } else {
            relativePath = VfsUtilCore.getRelativePath((VirtualFile)folderFileFile, (VirtualFile)file2, (char)File.separatorChar);
            textAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }
        relativePath = StringUtil.isEmpty((String)relativePath) ? "." + File.separatorChar : relativePath;
        return new SimpleTextCellAppearance(relativePath, icon, textAttributes);
    }
}

