/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.roots.impl.storage.ClasspathStorageProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleJdkConfigurable;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanelImpl;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.JBUI;
import gnu.trove.THashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ClasspathEditor
extends ModuleElementsEditor
implements ModuleRootListener {
    public static final String NAME = ProjectBundle.message((String)"modules.classpath.title", (Object[])new Object[0]);
    private ClasspathPanelImpl myPanel;
    private ClasspathFormatPanel myClasspathFormatPanel;

    public ClasspathEditor(ModuleConfigurationState state) {
        super(state);
        Disposable disposable = Disposer.newDisposable();
        state.getProject().getMessageBus().connect(disposable).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)this);
        this.registerDisposable(disposable);
    }

    @Override
    public boolean isModified() {
        return super.isModified() || this.myClasspathFormatPanel != null && this.myClasspathFormatPanel.isModified();
    }

    public String getHelpTopic() {
        return "projectStructure.modules.dependencies";
    }

    public String getDisplayName() {
        return NAME;
    }

    public void saveData() {
        this.myPanel.stopEditing();
    }

    @Override
    public void apply() throws ConfigurationException {
        if (this.myClasspathFormatPanel != null) {
            this.myClasspathFormatPanel.apply();
        }
    }

    @Override
    public void canApply() throws ConfigurationException {
        ClasspathStorageProvider provider2;
        super.canApply();
        if (this.myClasspathFormatPanel != null && (provider2 = ClasspathStorage.getProvider(this.myClasspathFormatPanel.getSelectedClasspathFormat())) != null) {
            provider2.assertCompatible((ModuleRootModel)this.getModel());
        }
    }

    @Override
    public JComponent createComponentImpl() {
        this.myPanel = new ClasspathPanelImpl(this.getState());
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        panel2.add((Component)this.myPanel, "Center");
        ModuleJdkConfigurable jdkConfigurable = new ModuleJdkConfigurable(this, ProjectStructureConfigurable.getInstance(this.myProject).getProjectJdksModel()){

            @Override
            protected ModifiableRootModel getRootModel() {
                return ClasspathEditor.this.getState().getRootModel();
            }
        };
        panel2.add((Component)jdkConfigurable.createComponent(), "North");
        jdkConfigurable.reset();
        this.registerDisposable(jdkConfigurable);
        ClasspathStorageProvider[] providers = (ClasspathStorageProvider[])ClasspathStorageProvider.EXTENSION_POINT_NAME.getExtensions();
        if (providers.length > 0) {
            this.myClasspathFormatPanel = new ClasspathFormatPanel(providers);
            panel2.add((Component)this.myClasspathFormatPanel, "South");
        }
        return panel2;
    }

    public void selectOrderEntry(@NotNull OrderEntry entry) {
        this.myPanel.selectOrderEntry(entry);
    }

    public void moduleStateChanged() {
        if (this.myPanel != null) {
            this.myPanel.initFromModel();
        }
    }

    public void rootsChanged(ModuleRootEvent event) {
        if (this.myPanel != null) {
            this.myPanel.rootsChanged();
        }
    }

    public void setSdk(Sdk newJDK) {
        ModifiableRootModel model = this.getModel();
        if (newJDK != null) {
            model.setSdk(newJDK);
        } else {
            model.inheritSdk();
        }
        if (this.myPanel != null) {
            this.myPanel.forceInitFromModel();
        }
    }

    private class ClasspathFormatPanel
    extends JPanel {
        private final JComboBox comboBoxClasspathFormat;
        private final Map<String, String> formatIdToDescription;

        private ClasspathFormatPanel(ClasspathStorageProvider[] providers) {
            super(new GridBagLayout());
            this.formatIdToDescription = new THashMap();
            this.add((Component)new JLabel(ProjectBundle.message((String)"project.roots.classpath.format.label", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)10, (int)6, (int)6, (int)0), 0, 0));
            this.formatIdToDescription.put("default", ProjectBundle.message((String)"project.roots.classpath.format.default.descr", (Object[])new Object[0]));
            for (ClasspathStorageProvider provider2 : providers) {
                this.formatIdToDescription.put(provider2.getID(), provider2.getDescription());
            }
            this.comboBoxClasspathFormat = new ComboBox(this.formatIdToDescription.values().toArray());
            this.updateClasspathFormat();
            this.add((Component)this.comboBoxClasspathFormat, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)6, (int)6, (int)6, (int)0), 0, 0));
        }

        private void updateClasspathFormat() {
            this.comboBoxClasspathFormat.setSelectedItem(this.formatIdToDescription.get(this.getModuleClasspathFormat()));
        }

        private String getSelectedClasspathFormat() {
            String selected = (String)this.comboBoxClasspathFormat.getSelectedItem();
            for (Map.Entry<String, String> entry : this.formatIdToDescription.entrySet()) {
                if (!entry.getValue().equals(selected)) continue;
                return entry.getKey();
            }
            throw new IllegalStateException(selected);
        }

        @NotNull
        private String getModuleClasspathFormat() {
            return ClassPathStorageUtil.getStorageType(ClasspathEditor.this.getModel().getModule());
        }

        boolean isModified() {
            return this.comboBoxClasspathFormat != null && !this.getSelectedClasspathFormat().equals(this.getModuleClasspathFormat());
        }

        void apply() throws ConfigurationException {
            String storageID = this.getSelectedClasspathFormat();
            ClasspathStorageProvider provider2 = ClasspathStorage.getProvider(storageID);
            if (provider2 != null) {
                provider2.assertCompatible((ModuleRootModel)ClasspathEditor.this.getModel());
            }
            ClasspathStorage.setStorageType((ModuleRootModel)ClasspathEditor.this.getModel(), storageID);
        }
    }
}

