/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.roots.ui.configuration.SourceRootPresentation;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ContentEntryTreeCellRenderer
extends NodeRenderer {
    protected final ContentEntryTreeEditor myTreeEditor;
    private final List<ModuleSourceRootEditHandler<?>> myEditHandlers;

    public ContentEntryTreeCellRenderer(@NotNull ContentEntryTreeEditor treeEditor, List<ModuleSourceRootEditHandler<?>> editHandlers) {
        this.myTreeEditor = treeEditor;
        this.myEditHandlers = editHandlers;
    }

    public void customizeCellRenderer(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        ContentEntry contentEntry;
        VirtualFile file2;
        Object element;
        Object userObject;
        super.customizeCellRenderer(tree, value2, selected, expanded, leaf, row, hasFocus);
        ContentEntryEditor editor = this.myTreeEditor.getContentEntryEditor();
        if (editor != null && (userObject = ((DefaultMutableTreeNode)value2).getUserObject()) instanceof NodeDescriptor && (element = ((NodeDescriptor)userObject).getElement()) instanceof FileElement && (file2 = ((FileElement)element).getFile()) != null && file2.isDirectory() && (contentEntry = editor.getContentEntry()) != null) {
            String prefix = ContentEntryTreeCellRenderer.getPresentablePrefix(contentEntry, file2);
            if (!prefix.isEmpty()) {
                this.append(" (" + prefix + ")", new SimpleTextAttributes(0, (Color)JBColor.GRAY));
            }
            this.setIcon(this.updateIcon(contentEntry, file2, this.getIcon()));
        }
    }

    private static String getPresentablePrefix(ContentEntry entry, VirtualFile file2) {
        for (SourceFolder sourceFolder : entry.getSourceFolders()) {
            if (!file2.equals(sourceFolder.getFile())) continue;
            JpsModuleSourceRoot element = sourceFolder.getJpsElement();
            JavaSourceRootProperties properties = (JavaSourceRootProperties)element.getProperties(JavaModuleSourceRootTypes.SOURCES);
            if (properties != null) {
                return properties.getPackagePrefix();
            }
            JavaResourceRootProperties resourceRootProperties = (JavaResourceRootProperties)element.getProperties(JavaModuleSourceRootTypes.RESOURCES);
            if (resourceRootProperties == null) continue;
            return resourceRootProperties.getRelativeOutputPath();
        }
        return "";
    }

    protected Icon updateIcon(ContentEntry entry, VirtualFile file2, Icon originalIcon) {
        SourceFolder[] sourceFolders;
        if (ContentEntryEditor.isExcludedOrUnderExcludedDirectory(this.myTreeEditor.getProject(), entry, file2)) {
            return AllIcons.Modules.ExcludeRoot;
        }
        for (SourceFolder sourceFolder : sourceFolders = entry.getSourceFolders()) {
            if (!file2.equals(sourceFolder.getFile())) continue;
            return SourceRootPresentation.getSourceRootIcon(sourceFolder);
        }
        Icon icon = originalIcon;
        VirtualFile currentRoot = null;
        for (SourceFolder sourceFolder : sourceFolders) {
            VirtualFile sourcePath = sourceFolder.getFile();
            if (sourcePath == null || !VfsUtilCore.isAncestor((VirtualFile)sourcePath, (VirtualFile)file2, (boolean)true) || currentRoot != null && VfsUtilCore.isAncestor((VirtualFile)sourcePath, currentRoot, (boolean)false)) continue;
            Icon folderIcon = this.getSourceFolderIcon(sourceFolder.getRootType());
            if (folderIcon != null) {
                icon = folderIcon;
            }
            currentRoot = sourcePath;
        }
        return icon;
    }

    @Nullable
    private Icon getSourceFolderIcon(JpsModuleSourceRootType<?> type2) {
        for (ModuleSourceRootEditHandler<?> handler2 : this.myEditHandlers) {
            if (!handler2.getRootType().equals(type2)) continue;
            return handler2.getFolderUnderRootIcon();
        }
        return null;
    }
}

