/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.compiler.actions.ArtifactAwareProjectSettingsService;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.util.projectWizard.JdkChooserPanel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.CommonContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.packaging.artifacts.Artifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaProjectSettingsService
extends ProjectSettingsService
implements ArtifactAwareProjectSettingsService {
    private final Project myProject;

    public IdeaProjectSettingsService(Project project2) {
        this.myProject = project2;
    }

    @Override
    public void openProjectSettings() {
        ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(this.myProject);
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)config, () -> config.selectProjectGeneralSettings(true));
    }

    @Override
    public void openGlobalLibraries() {
        ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(this.myProject);
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)config, () -> config.selectGlobalLibraries(true));
    }

    @Override
    public void openLibrary(@NotNull Library library) {
        ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(this.myProject);
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)config, () -> config.selectProjectOrGlobalLibrary(library, true));
    }

    @Override
    public boolean canOpenModuleSettings() {
        return true;
    }

    @Override
    public void openModuleSettings(Module module2) {
        ModulesConfigurator.showDialog(this.myProject, module2.getName(), null);
    }

    @Override
    public boolean canOpenModuleLibrarySettings() {
        return true;
    }

    @Override
    public void openModuleLibrarySettings(Module module2) {
        ModulesConfigurator.showDialog(this.myProject, module2.getName(), ClasspathEditor.NAME);
    }

    @Override
    public boolean canOpenContentEntriesSettings() {
        return true;
    }

    @Override
    public void openContentEntriesSettings(Module module2) {
        ModulesConfigurator.showDialog(this.myProject, module2.getName(), CommonContentEntriesEditor.NAME);
    }

    @Override
    public boolean canOpenModuleDependenciesSettings() {
        return true;
    }

    @Override
    public void openModuleDependenciesSettings(@NotNull Module module2, @Nullable OrderEntry orderEntry) {
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)ProjectStructureConfigurable.getInstance(this.myProject), () -> ProjectStructureConfigurable.getInstance(this.myProject).selectOrderEntry(module2, orderEntry));
    }

    @Override
    public boolean canOpenLibraryOrSdkSettings(OrderEntry orderEntry) {
        return true;
    }

    @Override
    public void openLibraryOrSdkSettings(@NotNull OrderEntry orderEntry) {
        ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(this.myProject);
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)config, () -> {
            if (orderEntry instanceof JdkOrderEntry) {
                config.select(((JdkOrderEntry)orderEntry).getJdk(), true);
            } else {
                config.select((LibraryOrderEntry)orderEntry, true);
            }
        });
    }

    @Override
    public boolean processModulesMoved(Module[] modules, @Nullable ModuleGroup targetGroup) {
        ModuleStructureConfigurable rootConfigurable = ModuleStructureConfigurable.getInstance(this.myProject);
        if (rootConfigurable.updateProjectTree(modules)) {
            if (targetGroup != null) {
                rootConfigurable.selectNodeInTree(targetGroup.toString());
            } else {
                rootConfigurable.selectNodeInTree(modules[0].getName());
            }
            return true;
        }
        return false;
    }

    @Override
    public void showModuleConfigurationDialog(String moduleToSelect, String editorNameToSelect) {
        ModulesConfigurator.showDialog(this.myProject, moduleToSelect, editorNameToSelect);
    }

    @Override
    public Sdk chooseAndSetSdk() {
        return JdkChooserPanel.chooseAndSetJDK(this.myProject);
    }

    @Override
    public void openArtifactSettings(@Nullable Artifact artifact) {
        ModulesConfigurator.showArtifactSettings(this.myProject, artifact);
    }
}

