/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ContentRootPanel;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.roots.IconActionComponent;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class JavaResourceRootEditHandlerBase
extends ModuleSourceRootEditHandler<JavaResourceRootProperties> {
    public JavaResourceRootEditHandlerBase(JpsModuleSourceRootType<JavaResourceRootProperties> rootType) {
        super(rootType);
    }

    @Override
    @Nullable
    public Icon getFolderUnderRootIcon() {
        return null;
    }

    @Override
    @Nullable
    public CustomShortcutSet getMarkRootShortcutSet() {
        return null;
    }

    @Override
    @NotNull
    public Icon getRootIcon(@NotNull JavaResourceRootProperties properties) {
        return properties.isForGeneratedSources() ? this.getGeneratedRootIcon() : this.getRootIcon();
    }

    @NotNull
    protected Icon getGeneratedRootIcon() {
        return this.getRootIcon();
    }

    @Override
    @Nullable
    public String getPropertiesString(@NotNull JavaResourceRootProperties properties) {
        String relativeOutputPath;
        StringBuilder buffer = new StringBuilder();
        if (properties.isForGeneratedSources()) {
            buffer.append(" [generated]");
        }
        if (!(relativeOutputPath = properties.getRelativeOutputPath()).isEmpty()) {
            buffer.append(" (").append(relativeOutputPath).append(")");
        }
        return buffer.length() > 0 ? buffer.toString() : null;
    }

    @Override
    @Nullable
    public JComponent createPropertiesEditor(@NotNull SourceFolder folder, @NotNull JComponent parentComponent, @NotNull ContentRootPanel.ActionCallback callback) {
        IconActionComponent iconComponent = new IconActionComponent(AllIcons.Modules.SetPackagePrefix, AllIcons.Modules.SetPackagePrefixRollover, ProjectBundle.message((String)"module.paths.edit.properties.tooltip", (Object[])new Object[0]), () -> {
            JavaResourceRootProperties properties = (JavaResourceRootProperties)folder.getJpsElement().getProperties(JavaModuleSourceRootTypes.RESOURCES);
            assert (properties != null);
            ResourceRootPropertiesDialog dialog2 = new ResourceRootPropertiesDialog(parentComponent, properties);
            if (dialog2.showAndGet()) {
                callback.onSourceRootPropertiesChanged(folder);
            }
        });
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setOpaque(false);
        panel2.add((Component)iconComponent, "Center");
        panel2.add(Box.createHorizontalStrut(3), "East");
        return panel2;
    }

    private static class ResourceRootPropertiesDialog
    extends DialogWrapper {
        private final JTextField myRelativeOutputPathField;
        private final JCheckBox myIsGeneratedCheckBox;
        private final JPanel myMainPanel;
        @NotNull
        private final JavaResourceRootProperties myProperties;

        private ResourceRootPropertiesDialog(@NotNull JComponent parentComponent, @NotNull JavaResourceRootProperties properties) {
            super((Component)parentComponent, true);
            this.myProperties = properties;
            this.setTitle(ProjectBundle.message((String)"module.paths.edit.properties.title", (Object[])new Object[0]));
            this.myRelativeOutputPathField = new JTextField();
            this.myIsGeneratedCheckBox = new JCheckBox(UIUtil.replaceMnemonicAmpersand((String)"For &generated resources"));
            this.myMainPanel = FormBuilder.createFormBuilder().addLabeledComponent("Relative output &path:", (JComponent)this.myRelativeOutputPathField).addComponent((JComponent)this.myIsGeneratedCheckBox).getPanel();
            this.myRelativeOutputPathField.setText(this.myProperties.getRelativeOutputPath());
            this.myRelativeOutputPathField.setColumns(25);
            this.myIsGeneratedCheckBox.setSelected(this.myProperties.isForGeneratedSources());
            this.init();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myRelativeOutputPathField;
        }

        protected void doOKAction() {
            this.myProperties.setRelativeOutputPath(ResourceRootPropertiesDialog.normalizePath(this.myRelativeOutputPathField.getText()));
            this.myProperties.setForGeneratedSources(this.myIsGeneratedCheckBox.isSelected());
            super.doOKAction();
        }

        @NotNull
        private static String normalizePath(String path) {
            return StringUtil.trimEnd((String)StringUtil.trimStart((String)FileUtil.toSystemIndependentName((String)path.trim()), (String)"/"), (String)"/");
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myMainPanel;
        }
    }
}

