/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LibrarySettingsProvider {
    public static final ExtensionPointName<LibrarySettingsProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.librarySettingsProvider");

    @NotNull
    public abstract LibraryKind getLibraryKind();

    public abstract Configurable getAdditionalSettingsConfigurable(Project var1);

    @Nullable
    public static Configurable getAdditionalSettingsConfigurable(Project project2, LibraryKind libKind) {
        LibrarySettingsProvider provider2 = LibrarySettingsProvider.forLibraryType(libKind);
        if (provider2 == null) {
            return null;
        }
        return provider2.getAdditionalSettingsConfigurable(project2);
    }

    @Nullable
    public static LibrarySettingsProvider forLibraryType(LibraryKind libType) {
        for (LibrarySettingsProvider provider2 : (LibrarySettingsProvider[])Extensions.getExtensions(EP_NAME)) {
            if (!provider2.getLibraryKind().equals(libType)) continue;
            return provider2;
        }
        return null;
    }
}

