/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetModel;
import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.facet.impl.ui.FacetEditorImpl;
import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.projectWizard.NewProjectWizard;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.ui.configuration.HeaderHidingTabbedModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModulesConfigurator
implements ModulesProvider,
ModuleEditor.ChangeListener {
    private static final Logger LOG = Logger.getInstance((String)("#" + ModulesConfigurator.class.getName()));
    private final Project myProject;
    private final Map<Module, ModuleEditor> myModuleEditors = new TreeMap<Module, ModuleEditor>((o1, o2) -> {
        String n2;
        String n1 = o1.getName();
        int result2 = n1.compareToIgnoreCase(n2 = o2.getName());
        if (result2 != 0) {
            return result2;
        }
        return n1.compareTo(n2);
    });
    private boolean myModified = false;
    private ModifiableModuleModel myModuleModel;
    private boolean myModuleModelCommitted = false;
    private ProjectFacetsConfigurator myFacetsConfigurator;
    private StructureConfigurableContext myContext;
    private final List<ModuleEditor.ChangeListener> myAllModulesChangeListeners = new ArrayList<ModuleEditor.ChangeListener>();

    public ModulesConfigurator(Project project2) {
        this.myProject = project2;
        this.myModuleModel = ModuleManager.getInstance((Project)this.myProject).getModifiableModel();
    }

    public void setContext(StructureConfigurableContext context) {
        this.myContext = context;
        this.myFacetsConfigurator = this.createFacetsConfigurator();
    }

    public ProjectFacetsConfigurator getFacetsConfigurator() {
        return this.myFacetsConfigurator;
    }

    public void disposeUIResources() {
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
                Disposer.dispose((Disposable)moduleEditor);
            }
            this.myModuleEditors.clear();
            this.myModuleModel.dispose();
            if (this.myFacetsConfigurator != null) {
                this.myFacetsConfigurator.disposeEditors();
            }
        });
    }

    @NotNull
    public Module[] getModules() {
        return this.myModuleModel.getModules();
    }

    @Nullable
    public Module getModule(String name) {
        Module moduleByName = this.myModuleModel.findModuleByName(name);
        if (moduleByName != null) {
            return moduleByName;
        }
        return this.myModuleModel.getModuleToBeRenamed(name);
    }

    @Nullable
    public ModuleEditor getModuleEditor(Module module2) {
        return this.myModuleEditors.get(module2);
    }

    public ModuleRootModel getRootModel(@NotNull Module module2) {
        return this.getOrCreateModuleEditor(module2).getRootModel();
    }

    public ModuleEditor getOrCreateModuleEditor(Module module2) {
        LOG.assertTrue(this.getModule(module2.getName()) != null, (Object)"Module has been deleted");
        ModuleEditor editor = this.getModuleEditor(module2);
        if (editor == null) {
            editor = this.doCreateModuleEditor(module2);
        }
        return editor;
    }

    private ModuleEditor doCreateModuleEditor(Module module2) {
        final HeaderHidingTabbedModuleEditor moduleEditor = new HeaderHidingTabbedModuleEditor(this.myProject, this, module2){

            @Override
            public ProjectFacetsConfigurator getFacetsConfigurator() {
                return ModulesConfigurator.this.myFacetsConfigurator;
            }
        };
        this.myModuleEditors.put(moduleEditor.getModule(), moduleEditor);
        moduleEditor.addChangeListener(this);
        Disposer.register((Disposable)moduleEditor, (Disposable)new Disposable(){

            public void dispose() {
                moduleEditor.removeChangeListener(ModulesConfigurator.this);
            }
        });
        return moduleEditor;
    }

    public FacetModel getFacetModel(@NotNull Module module2) {
        return this.myFacetsConfigurator.getOrCreateModifiableModel(module2);
    }

    public void resetModuleEditors() {
        this.myModuleModel = ModuleManager.getInstance((Project)this.myProject).getModifiableModel();
        ApplicationManager.getApplication().runWriteAction(() -> {
            Module[] modules;
            if (!this.myModuleEditors.isEmpty()) {
                LOG.error("module editors was not disposed");
                this.myModuleEditors.clear();
            }
            if ((modules = this.myModuleModel.getModules()).length > 0) {
                for (Module module2 : modules) {
                    this.getOrCreateModuleEditor(module2);
                }
            }
        });
        this.myFacetsConfigurator.resetEditors();
        this.myModified = false;
    }

    @Override
    public void moduleStateChanged(ModifiableRootModel moduleRootModel) {
        for (ModuleEditor.ChangeListener listener2 : this.myAllModulesChangeListeners) {
            listener2.moduleStateChanged(moduleRootModel);
        }
        this.myContext.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(this.myContext, moduleRootModel.getModule()));
    }

    public void addAllModuleChangeListener(ModuleEditor.ChangeListener listener2) {
        this.myAllModulesChangeListeners.add(listener2);
    }

    public void apply() throws ConfigurationException {
        HashMap contentRootToModuleNameMap = new HashMap();
        HashMap srcRootsToContentRootMap = new HashMap();
        for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
            ModifiableRootModel rootModel = moduleEditor.getModifiableRootModel();
            ContentEntry[] contentEntryArray = rootModel.getContentEntries();
            String moduleName = moduleEditor.getName();
            HashSet<VirtualFile> sourceRoots = new HashSet<VirtualFile>();
            for (ContentEntry content : contentEntryArray) {
                for (VirtualFile root : content.getSourceFolderFiles()) {
                    if (sourceRoots.add(root)) continue;
                    throw new ConfigurationException(ProjectBundle.message((String)"module.paths.validation.duplicate.source.root.in.same.module.error", (Object[])new Object[]{root.getPresentableUrl(), moduleName}));
                }
            }
            for (ContentEntry contentEntry : contentEntryArray) {
                VirtualFile contentRoot = contentEntry.getFile();
                if (contentRoot == null) continue;
                String previousName = contentRootToModuleNameMap.put(contentRoot, moduleName);
                if (previousName != null && !previousName.equals(moduleName)) {
                    throw new ConfigurationException(ProjectBundle.message((String)"module.paths.validation.duplicate.content.error", (Object[])new Object[]{contentRoot.getPresentableUrl(), previousName, moduleName}));
                }
                for (VirtualFile srcRoot : contentEntry.getSourceFolderFiles()) {
                    String correctModule;
                    String problematicModule;
                    VirtualFile anotherContentRoot = srcRootsToContentRootMap.put(srcRoot, contentRoot);
                    if (anotherContentRoot == null) continue;
                    if (VfsUtilCore.isAncestor((VirtualFile)anotherContentRoot, (VirtualFile)contentRoot, (boolean)true)) {
                        problematicModule = (String)contentRootToModuleNameMap.get(anotherContentRoot);
                        correctModule = (String)contentRootToModuleNameMap.get(contentRoot);
                    } else {
                        problematicModule = (String)contentRootToModuleNameMap.get(contentRoot);
                        correctModule = (String)contentRootToModuleNameMap.get(anotherContentRoot);
                    }
                    throw new ConfigurationException(ProjectBundle.message((String)"module.paths.validation.duplicate.source.root.error", (Object[])new Object[]{problematicModule, srcRoot.getPresentableUrl(), correctModule}));
                }
            }
        }
        for (Map.Entry entry : srcRootsToContentRootMap.entrySet()) {
            VirtualFile srcRoot = (VirtualFile)entry.getKey();
            VirtualFile virtualFile = (VirtualFile)entry.getValue();
            String expectedModuleName = (String)contentRootToModuleNameMap.get(virtualFile);
            for (VirtualFile candidateContent = srcRoot; candidateContent != null && !candidateContent.equals(virtualFile); candidateContent = candidateContent.getParent()) {
                String moduleName = (String)contentRootToModuleNameMap.get(candidateContent);
                if (moduleName == null || moduleName.equals(expectedModuleName)) continue;
                throw new ConfigurationException(ProjectBundle.message((String)"module.paths.validation.source.root.belongs.to.another.module.error", (Object[])new Object[]{srcRoot.getPresentableUrl(), expectedModuleName, moduleName}));
            }
        }
        for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
            moduleEditor.canApply();
        }
        THashMap modifiedToOriginalMap = new THashMap();
        ProjectSdksModel projectSdksModel = ProjectStructureConfigurable.getInstance(this.myProject).getProjectJdksModel();
        for (Map.Entry entry : projectSdksModel.getProjectSdks().entrySet()) {
            modifiedToOriginalMap.put(entry.getValue(), entry.getKey());
        }
        Ref exceptionRef = Ref.create();
        ApplicationManager.getApplication().runWriteAction(() -> this.lambda$apply$3((Map)modifiedToOriginalMap, exceptionRef));
        if (!exceptionRef.isNull()) {
            throw (ConfigurationException)((Object)exceptionRef.get());
        }
        this.myModified = false;
    }

    private ProjectFacetsConfigurator createFacetsConfigurator() {
        return new ProjectFacetsConfigurator(this.myContext, this.myFacetsConfigurator);
    }

    public void setModified(boolean modified) {
        this.myModified = modified;
    }

    public ModifiableModuleModel getModuleModel() {
        return this.myModuleModel;
    }

    public boolean isModuleModelCommitted() {
        return this.myModuleModelCommitted;
    }

    public List<Module> deleteModules(Collection<Module> modules) {
        ArrayList<Module> deleted = new ArrayList<Module>();
        ArrayList<ModuleEditor> moduleEditors = new ArrayList<ModuleEditor>();
        for (Module module2 : modules) {
            ModuleEditor moduleEditor = this.getModuleEditor(module2);
            if (moduleEditor == null) continue;
            deleted.add(module2);
            moduleEditors.add(moduleEditor);
        }
        if (this.doRemoveModules(moduleEditors)) {
            return deleted;
        }
        return Collections.emptyList();
    }

    @Nullable
    public List<Module> addModule(Component parent, boolean anImport) {
        if (this.myProject.isDefault()) {
            return null;
        }
        ProjectBuilder builder = this.runModuleWizard(parent, anImport);
        if (builder != null) {
            List<Module> committedModules;
            ArrayList<Module> modules = new ArrayList<Module>();
            if (builder instanceof ProjectImportBuilder) {
                ModifiableArtifactModel artifactModel = ProjectStructureConfigurable.getInstance(this.myProject).getArtifactsStructureConfigurable().getModifiableArtifactModel();
                committedModules = ((ProjectImportBuilder)builder).commit(this.myProject, this.myModuleModel, this, artifactModel);
            } else {
                committedModules = builder.commit(this.myProject, this.myModuleModel, (ModulesProvider)this);
            }
            if (committedModules != null) {
                modules.addAll(committedModules);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                for (Module module2 : modules) {
                    this.getOrCreateModuleEditor(module2);
                }
            });
            return modules;
        }
        return null;
    }

    private Module createModule(final ModuleBuilder builder) {
        try {
            return (Module)ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<Module, Exception>(){

                public Module compute() throws Exception {
                    return builder.createModule(ModulesConfigurator.this.myModuleModel);
                }
            });
        }
        catch (Exception e) {
            Messages.showErrorDialog((String)ProjectBundle.message((String)"module.add.error.message", (Object[])new Object[]{e.getMessage()}), (String)ProjectBundle.message((String)"module.add.error.title", (Object[])new Object[0]));
            return null;
        }
    }

    @Nullable
    public Module addModule(ModuleBuilder moduleBuilder) {
        Module module2 = this.createModule(moduleBuilder);
        if (module2 != null) {
            ApplicationManager.getApplication().runWriteAction(() -> this.getOrCreateModuleEditor(module2));
            this.processModuleCountChanged();
        }
        return module2;
    }

    @Nullable
    ProjectBuilder runModuleWizard(Component dialogParent, boolean anImport) {
        AbstractProjectWizard wizard;
        if (anImport) {
            wizard = ImportModuleAction.selectFileAndCreateWizard(this.myProject, dialogParent);
            if (wizard == null) {
                return null;
            }
            if (wizard.getStepCount() == 0) {
                ProjectBuilder builder = wizard.getProjectBuilder();
                Disposer.dispose((Disposable)wizard.getDisposable());
                return builder;
            }
        } else {
            wizard = new NewProjectWizard(this.myProject, dialogParent, this);
        }
        if (wizard.showAndGet()) {
            ProjectBuilder builder = wizard.getProjectBuilder();
            if (builder instanceof ModuleBuilder) {
                ModuleBuilder moduleBuilder = (ModuleBuilder)builder;
                if (moduleBuilder.getName() == null) {
                    moduleBuilder.setName(wizard.getProjectName());
                }
                if (moduleBuilder.getModuleFilePath() == null) {
                    moduleBuilder.setModuleFilePath(wizard.getModuleFilePath());
                }
            }
            if (!builder.validate(this.myProject, this.myProject)) {
                return null;
            }
            return wizard.getProjectBuilder();
        }
        return null;
    }

    private boolean doRemoveModules(@NotNull List<ModuleEditor> selectedEditors) {
        if (selectedEditors.isEmpty()) {
            return true;
        }
        String question = this.myModuleEditors.size() == selectedEditors.size() ? ProjectBundle.message((String)"module.remove.last.confirmation", (Object[])new Object[]{selectedEditors.size()}) : ProjectBundle.message((String)"module.remove.confirmation", (Object[])new Object[]{selectedEditors.get(0).getModule().getName(), selectedEditors.size()});
        int result2 = Messages.showYesNoDialog((Project)this.myProject, (String)question, (String)ProjectBundle.message((String)"module.remove.confirmation.title", (Object[])new Object[]{selectedEditors.size()}), (Icon)Messages.getQuestionIcon());
        if (result2 != 0) {
            return false;
        }
        for (ModuleEditor editor : selectedEditors) {
            this.myModuleEditors.remove(editor.getModule());
            Module moduleToRemove = editor.getModule();
            ArrayList<ModifiableRootModel> modifiableRootModels = new ArrayList<ModifiableRootModel>();
            for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
                ModifiableRootModel modifiableRootModel = moduleEditor.getModifiableRootModelProxy();
                ContainerUtil.addIfNotNull(modifiableRootModels, (Object)modifiableRootModel);
            }
            ModuleDeleteProvider.removeModule(moduleToRemove, null, modifiableRootModels, this.myModuleModel);
            Disposer.dispose((Disposable)editor);
        }
        this.processModuleCountChanged();
        return true;
    }

    private void processModuleCountChanged() {
        for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
            moduleEditor.moduleCountChanged();
        }
    }

    public void processModuleCompilerOutputChanged(String baseUrl) {
        for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
            moduleEditor.updateCompilerOutputPathChanged(baseUrl, moduleEditor.getName());
        }
    }

    public boolean isModified() {
        if (this.myModuleModel.isChanged()) {
            return true;
        }
        for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
            if (!moduleEditor.isModified()) continue;
            return true;
        }
        return this.myModified || this.myFacetsConfigurator.isModified();
    }

    public static boolean showArtifactSettings(@NotNull Project project2, @Nullable Artifact artifact) {
        ProjectStructureConfigurable configurable = ProjectStructureConfigurable.getInstance(project2);
        return ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)configurable, () -> configurable.select(artifact, true));
    }

    public static boolean showFacetSettingsDialog(@NotNull Facet facet, @Nullable String tabNameToSelect) {
        Project project2 = facet.getModule().getProject();
        ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(project2);
        return ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)config, () -> {
            ModuleStructureConfigurable modulesConfig = config.getModulesConfig();
            config.select(facet, true).doWhenDone(() -> {
                if (tabNameToSelect != null) {
                    FacetEditorImpl facetEditor = modulesConfig.getFacetConfigurator().getOrCreateEditor(facet);
                    facetEditor.setSelectedTabName(tabNameToSelect);
                }
            });
        });
    }

    public static boolean showDialog(Project project2, @Nullable String moduleToSelect, @Nullable String editorNameToSelect) {
        ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(project2);
        return ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)config, () -> config.select(moduleToSelect, editorNameToSelect, true));
    }

    public void moduleRenamed(Module module2, String oldName, String name) {
        ModuleEditor moduleEditor = this.myModuleEditors.get(module2);
        if (moduleEditor != null) {
            moduleEditor.setModuleName(name);
            moduleEditor.updateCompilerOutputPathChanged(ProjectStructureConfigurable.getInstance(this.myProject).getProjectConfig().getCompilerOutputUrl(), name);
            this.myContext.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(this.myContext, module2));
        }
    }

    public StructureConfigurableContext getContext() {
        return this.myContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$apply$3(Map modifiedToOriginalMap, Ref exceptionRef) {
        ArrayList<ModifiableRootModel> models = new ArrayList<ModifiableRootModel>(this.myModuleEditors.size());
        try {
            for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
                Sdk original;
                Sdk modelSdk;
                ModifiableRootModel model = moduleEditor.apply();
                if (model == null) continue;
                if (!model.isSdkInherited() && (modelSdk = model.getSdk()) != null && (original = (Sdk)modifiedToOriginalMap.get(modelSdk)) != null) {
                    model.setSdk(original);
                }
                models.add(model);
            }
            this.myFacetsConfigurator.applyEditors();
        }
        catch (ConfigurationException e) {
            exceptionRef.set((Object)e);
            return;
        }
        try {
            ModifiableModelCommitter.multiCommit(models, this.myModuleModel);
            this.myModuleModelCommitted = true;
            this.myFacetsConfigurator.commitFacets();
        }
        finally {
            ModuleStructureConfigurable.getInstance(this.myProject).getFacetEditorFacade().clearMaps(false);
            this.myFacetsConfigurator = this.createFacetsConfigurator();
            this.myModuleModel = ModuleManager.getInstance((Project)this.myProject).getModifiableModel();
            this.myModuleModelCommitted = false;
        }
    }
}

