/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.ui.configuration.classpath.ChooseAndAddAction;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathElementChooser;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathTableItem;
import com.intellij.openapi.roots.ui.configuration.classpath.NewLibraryChooser;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.util.ParameterizedRunnable;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AddNewLibraryDependencyAction
extends ChooseAndAddAction<Library> {
    private final StructureConfigurableContext myContext;
    private final LibraryType myLibraryType;

    public AddNewLibraryDependencyAction(ClasspathPanel classpathPanel, StructureConfigurableContext context, LibraryType libraryType) {
        super(classpathPanel);
        this.myContext = context;
        this.myLibraryType = libraryType;
    }

    @Override
    protected ClasspathTableItem<?> createTableItem(Library item) {
        OrderEntry[] entries;
        for (OrderEntry entry : entries = this.myClasspathPanel.getRootModel().getOrderEntries()) {
            LibraryOrderEntry libraryOrderEntry;
            if (!(entry instanceof LibraryOrderEntry) || !item.equals((libraryOrderEntry = (LibraryOrderEntry)entry).getLibrary())) continue;
            return ClasspathTableItem.createLibItem(libraryOrderEntry, this.myContext);
        }
        return ClasspathTableItem.createLibItem(this.myClasspathPanel.getRootModel().addLibraryEntry(item), this.myContext);
    }

    @Override
    protected ClasspathElementChooser<Library> createChooser() {
        return new NewLibraryChooser(this.myClasspathPanel.getProject(), this.myClasspathPanel.getRootModel(), this.myLibraryType, this.myContext, this.myClasspathPanel.getComponent());
    }

    public static void chooseTypeAndCreate(ClasspathPanel classpathPanel, StructureConfigurableContext context, JButton contextButton, @NotNull LibraryCreatedCallback callback) {
        if (LibraryEditingUtil.hasSuitableTypes(classpathPanel)) {
            ListPopup popup = JBPopupFactory.getInstance().createListPopup(LibraryEditingUtil.createChooseTypeStep(classpathPanel, (ParameterizedRunnable<LibraryType>)((ParameterizedRunnable)libraryType -> AddNewLibraryDependencyAction.doCreateLibrary(classpathPanel, context, callback, contextButton, libraryType))));
            popup.showUnderneathOf((Component)contextButton);
        } else {
            AddNewLibraryDependencyAction.doCreateLibrary(classpathPanel, context, callback, contextButton, null);
        }
    }

    private static void doCreateLibrary(ClasspathPanel classpathPanel, StructureConfigurableContext context, LibraryCreatedCallback callback, JComponent component, @Nullable LibraryType libraryType) {
        NewLibraryChooser chooser = new NewLibraryChooser(classpathPanel.getProject(), classpathPanel.getRootModel(), libraryType, context, component);
        Library library = chooser.createLibrary();
        if (library != null) {
            callback.libraryCreated(library);
        }
    }

    static interface LibraryCreatedCallback {
        public void libraryCreated(@NotNull Library var1);
    }
}

