/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.dependencyAnalysis;

import com.intellij.ProjectTopics;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.dependencyAnalysis.AnalyzeDependenciesSettings;
import com.intellij.openapi.roots.ui.configuration.dependencyAnalysis.ModuleDependenciesAnalyzer;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.HtmlListCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.PathUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AnalyzeDependenciesComponent
extends MasterDetailsComponent {
    public static DataKey<ModuleDependenciesAnalyzer.OrderPathElement> ORDER_PATH_ELEMENT_KEY = DataKey.create((String)"ORDER_PATH_ELEMENT");
    private final Module myModule;
    private final AnalyzeDependenciesSettings mySettings;
    private final HashMap<Pair<ClasspathType, Boolean>, ModuleDependenciesAnalyzer> myClasspaths = new HashMap();
    private MessageBusConnection myMessageBusConnection;

    public AnalyzeDependenciesComponent(Module module2) {
        this.myModule = module2;
        this.mySettings = AnalyzeDependenciesSettings.getInstance(this.myModule.getProject());
        this.initTree();
        this.init();
        this.getSplitter().setProportion(0.3f);
        this.myMessageBusConnection = this.myModule.getProject().getMessageBus().connect();
        this.myMessageBusConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                AnalyzeDependenciesComponent.this.myClasspaths.clear();
                AnalyzeDependenciesComponent.this.updateTree();
            }
        });
    }

    public void disposeUIResources() {
        if (this.myMessageBusConnection != null) {
            this.myMessageBusConnection.disconnect();
        }
    }

    private void init() {
        this.myTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value2 instanceof MasterDetailsComponent.MyNode && !(value2 instanceof MasterDetailsComponent.MyRootNode)) {
                    MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)value2;
                    PathNode n = (PathNode)((Object)node.getUserObject());
                    CellAppearanceEx a = n.getAppearance(selected, node.isDisplayInBold());
                    a.customize((SimpleColoredComponent)this);
                }
            }
        });
        this.myTree.setShowsRootHandles(false);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.reloadTree();
    }

    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        if (!fromPopup) {
            ArrayList<AnAction> rc = new ArrayList<AnAction>();
            rc.add((AnAction)new ClasspathTypeAction());
            rc.add((AnAction)new SdkFilterAction());
            rc.add((AnAction)new UrlModeAction());
            return rc;
        }
        return super.createActions(fromPopup);
    }

    protected void processRemovedItems() {
    }

    protected boolean wasObjectStored(Object editableObject) {
        return false;
    }

    @Nls
    public String getDisplayName() {
        return "Classpath Details";
    }

    public void reloadTree() {
        this.myRoot.removeAllChildren();
        ModuleDependenciesAnalyzer a = this.getAnalyzer();
        if (this.mySettings.isUrlMode()) {
            for (ModuleDependenciesAnalyzer.UrlExplanation urlExplanation : a.getUrls()) {
                this.myRoot.add((MutableTreeNode)new MasterDetailsComponent.MyNode((NamedConfigurable)new UrlNode(urlExplanation)));
            }
        } else {
            for (ModuleDependenciesAnalyzer.OrderEntryExplanation explanation : a.getOrderEntries()) {
                this.myRoot.add((MutableTreeNode)new MasterDetailsComponent.MyNode((NamedConfigurable)new OrderEntryNode(explanation)));
            }
        }
        ((DefaultTreeModel)this.myTree.getModel()).reload((TreeNode)this.myRoot);
    }

    public ModuleDependenciesAnalyzer getAnalyzer() {
        Pair key2 = Pair.create((Object)((Object)this.getClasspathType()), (Object)this.mySettings.isSdkIncluded());
        ModuleDependenciesAnalyzer a = this.myClasspaths.get(key2);
        if (a == null) {
            a = new ModuleDependenciesAnalyzer(this.myModule, !this.mySettings.isTest(), !this.mySettings.isRuntime(), this.mySettings.isSdkIncluded());
            this.myClasspaths.put((Pair<ClasspathType, Boolean>)key2, a);
        }
        return a;
    }

    private ClasspathType getClasspathType() {
        return this.mySettings.isRuntime() ? (this.mySettings.isTest() ? ClasspathType.TEST_RUNTIME : ClasspathType.PRODUCTION_RUNTIME) : (this.mySettings.isTest() ? ClasspathType.TEST_COMPILE : ClasspathType.PRODUCTION_COMPILE);
    }

    void updateTree() {
        this.reloadTree();
    }

    private static enum ClasspathType {
        PRODUCTION_COMPILE(false, false, "Production Compile"),
        PRODUCTION_RUNTIME(false, true, "Production Runtime"),
        TEST_RUNTIME(true, true, "Test Runtime"),
        TEST_COMPILE(true, false, "Test Compile");

        private final boolean myIsTest;
        private final boolean myIsRuntime;
        private final String myDescription;

        private ClasspathType(boolean isTest, boolean isRuntime, String description) {
            this.myIsTest = isTest;
            this.myIsRuntime = isRuntime;
            this.myDescription = description;
        }

        public boolean isTest() {
            return this.myIsTest;
        }

        public boolean isRuntime() {
            return this.myIsRuntime;
        }

        public String toString() {
            return this.myDescription;
        }

        public String getDescription() {
            return this.myDescription;
        }
    }

    private class ClasspathTypeAction
    extends ComboBoxAction {
        DefaultActionGroup myItems;

        private ClasspathTypeAction() {
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            if (this.myItems == null) {
                this.myItems = new DefaultActionGroup(null, true);
                for (final ClasspathType classpathType : ClasspathType.values()) {
                    this.myItems.addAction((AnAction)new DumbAwareAction(classpathType.getDescription()){

                        public void actionPerformed(AnActionEvent e) {
                            AnalyzeDependenciesComponent.this.mySettings.setRuntime(classpathType.isRuntime());
                            AnalyzeDependenciesComponent.this.mySettings.setTest(classpathType.isTest());
                            AnalyzeDependenciesComponent.this.updateTree();
                        }
                    });
                }
            }
            return this.myItems;
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            this.updateText(presentation);
        }

        private void updateText(Presentation presentation) {
            ClasspathType classpathType = AnalyzeDependenciesComponent.this.getClasspathType();
            String t = classpathType.getDescription();
            presentation.setText(t);
        }
    }

    private class UrlModeAction
    extends ToggleAction {
        public UrlModeAction() {
            super("Use URL mode", "If selected, the URLs are displayed, otherwise order entries", AllIcons.Nodes.PpFile);
        }

        public boolean isSelected(AnActionEvent e) {
            return AnalyzeDependenciesComponent.this.mySettings.isUrlMode();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            AnalyzeDependenciesComponent.this.mySettings.setUrlMode(state);
            AnalyzeDependenciesComponent.this.updateTree();
        }
    }

    private class SdkFilterAction
    extends ToggleAction {
        public SdkFilterAction() {
            super("Include SDK", "If selected, the SDK classes are included", AllIcons.General.Jdk);
        }

        public boolean isSelected(AnActionEvent e) {
            return AnalyzeDependenciesComponent.this.mySettings.isSdkIncluded();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            AnalyzeDependenciesComponent.this.mySettings.setIncludeSdk(state);
            AnalyzeDependenciesComponent.this.updateTree();
        }
    }

    class OrderEntryNode
    extends PathNode<ModuleDependenciesAnalyzer.OrderEntryExplanation> {
        public OrderEntryNode(ModuleDependenciesAnalyzer.OrderEntryExplanation orderEntryExplanation) {
            super(AnalyzeDependenciesComponent.this, (ModuleDependenciesAnalyzer.Explanation)orderEntryExplanation);
            this.setNameFieldShown(false);
        }

        @Override
        public CellAppearanceEx getAppearance(boolean selected, boolean isBold) {
            if (((ModuleDependenciesAnalyzer.OrderEntryExplanation)this.myExplanation).entry() instanceof ModuleSourceOrderEntry) {
                ModuleSourceOrderEntry e = (ModuleSourceOrderEntry)((ModuleDependenciesAnalyzer.OrderEntryExplanation)this.myExplanation).entry();
                if (e.getOwnerModule() == AnalyzeDependenciesComponent.this.myModule) {
                    return new CellAppearanceEx(){

                        public void customize(@NotNull SimpleColoredComponent component) {
                            component.setIcon(ModuleType.get((Module)AnalyzeDependenciesComponent.this.myModule).getIcon());
                            component.append("<This Module>", SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
                        }

                        public void customize(@NotNull HtmlListCellRenderer renderer) {
                            throw new UnsupportedOperationException("Rendering in combo box not supported yet.");
                        }

                        @NotNull
                        public String getText() {
                            return "<This Module>";
                        }
                    };
                }
                return OrderEntryAppearanceService.getInstance().forModule(e.getOwnerModule());
            }
            return OrderEntryAppearanceService.getInstance().forOrderEntry(AnalyzeDependenciesComponent.this.myModule.getProject(), ((ModuleDependenciesAnalyzer.OrderEntryExplanation)this.myExplanation).entry(), selected);
        }

        public String getBannerSlogan() {
            if (((ModuleDependenciesAnalyzer.OrderEntryExplanation)this.myExplanation).entry() instanceof ModuleSourceOrderEntry) {
                ModuleSourceOrderEntry e = (ModuleSourceOrderEntry)((ModuleDependenciesAnalyzer.OrderEntryExplanation)this.myExplanation).entry();
                return this.prefixForBanner("Module " + e.getOwnerModule().getName());
            }
            String p = ((ModuleDependenciesAnalyzer.OrderEntryExplanation)this.myExplanation).entry().getPresentableName() + " in module " + ((ModuleDependenciesAnalyzer.OrderEntryExplanation)this.myExplanation).entry().getOwnerModule().getName();
            return this.suffixForBanner(p);
        }

        @Nls
        public String getDisplayName() {
            return ((ModuleDependenciesAnalyzer.OrderEntryExplanation)this.myExplanation).entry().getPresentableName();
        }
    }

    class UrlNode
    extends PathNode<ModuleDependenciesAnalyzer.UrlExplanation> {
        public UrlNode(ModuleDependenciesAnalyzer.UrlExplanation url) {
            super(AnalyzeDependenciesComponent.this, (ModuleDependenciesAnalyzer.Explanation)url);
            this.setNameFieldShown(false);
        }

        @Override
        public CellAppearanceEx getAppearance(boolean selected, final boolean isBold) {
            return new CellAppearanceEx(){

                public void customize(@NotNull SimpleColoredComponent component) {
                    component.setIcon(UrlNode.this.getIcon());
                    Font font = UIUtil.getTreeFont();
                    if (isBold) {
                        component.setFont(font.deriveFont(1));
                    } else {
                        component.setFont(font.deriveFont(0));
                    }
                    String p = PathUtil.toPresentableUrl((String)((ModuleDependenciesAnalyzer.UrlExplanation)UrlNode.this.getEditableObject()).url());
                    component.append(PathUtil.getFileName((String)p), isBold ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    component.append(" (" + PathUtil.getParentPath((String)p) + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }

                public void customize(@NotNull HtmlListCellRenderer renderer) {
                    throw new UnsupportedOperationException("Rendering in combo box not supported yet.");
                }

                @NotNull
                public String getText() {
                    return UrlNode.this.getDisplayName();
                }
            };
        }

        public String getBannerSlogan() {
            VirtualFile f = ((ModuleDependenciesAnalyzer.UrlExplanation)this.myExplanation).getLocalFile();
            String p = f == null ? ((ModuleDependenciesAnalyzer.UrlExplanation)this.myExplanation).url() : f.getPath();
            p = this.suffixForBanner(p);
            return p;
        }

        private Icon getIcon() {
            return ((ModuleDependenciesAnalyzer.UrlExplanation)this.myExplanation).getIcon();
        }

        @Nls
        public String getDisplayName() {
            return ((ModuleDependenciesAnalyzer.UrlExplanation)this.myExplanation).url();
        }
    }

    static class ExplanationTreeRenderer
    extends ColoredTreeCellRenderer {
        ExplanationTreeRenderer() {
        }

        public void customizeCellRenderer(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)value2;
            Object userObject = n.getUserObject();
            if (!(userObject instanceof ModuleDependenciesAnalyzer.OrderPathElement)) {
                return;
            }
            ModuleDependenciesAnalyzer.OrderPathElement e = (ModuleDependenciesAnalyzer.OrderPathElement)userObject;
            CellAppearanceEx appearance = e.getAppearance(selected);
            appearance.customize((SimpleColoredComponent)this);
        }
    }

    static abstract class PathNode<T extends ModuleDependenciesAnalyzer.Explanation>
    extends NamedConfigurable<T>
    implements DataProvider {
        public static final int CUTOFF_LENGTH = 80;
        protected final T myExplanation;
        private Tree myExplanationTree;
        final /* synthetic */ AnalyzeDependenciesComponent this$0;

        public PathNode(T explanation) {
            this.this$0 = this$0;
            this.myExplanation = explanation;
        }

        public T getEditableObject() {
            return this.myExplanation;
        }

        private JComponent createTreeComponent() {
            this.myExplanationTree = new Tree((TreeModel)new DefaultTreeModel(this.buildTree()));
            this.myExplanationTree.setRootVisible(false);
            this.myExplanationTree.setCellRenderer((TreeCellRenderer)((Object)new ExplanationTreeRenderer()));
            DataManager.registerDataProvider((JComponent)this.myExplanationTree, (DataProvider)this);
            TreeUtil.expandAll((JTree)this.myExplanationTree);
            NavigateAction navigateAction = new NavigateAction();
            navigateAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{CommonShortcuts.DOUBLE_CLICK_1.getShortcuts()[0]}), (JComponent)this.myExplanationTree);
            DefaultActionGroup group = new DefaultActionGroup();
            group.addAction((AnAction)navigateAction);
            PopupHandler.installUnknownPopupHandler((JComponent)this.myExplanationTree, (ActionGroup)group, (ActionManager)ActionManager.getInstance());
            return new JBScrollPane((Component)this.myExplanationTree);
        }

        public Object getData(@NonNls String dataId) {
            Object o;
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.this$0.myModule.getProject();
            }
            if (LangDataKeys.MODULE.is(dataId)) {
                return this.this$0.myModule;
            }
            TreePath selectionPath = this.myExplanationTree.getSelectionPath();
            DefaultMutableTreeNode node = selectionPath == null ? null : (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
            Object object = o = node == null ? null : node.getUserObject();
            if (o instanceof ModuleDependenciesAnalyzer.OrderPathElement && ORDER_PATH_ELEMENT_KEY.is(dataId)) {
                return o;
            }
            return null;
        }

        private DefaultMutableTreeNode buildTree() {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode("ROOT");
            for (ModuleDependenciesAnalyzer.OrderPath orderPath : ((ModuleDependenciesAnalyzer.Explanation)this.myExplanation).paths()) {
                this.addDependencyPath(root, orderPath, 0);
            }
            return root;
        }

        private void addDependencyPath(DefaultMutableTreeNode parent, ModuleDependenciesAnalyzer.OrderPath orderPath, int i2) {
            DefaultMutableTreeNode n;
            if (i2 >= orderPath.entries().size()) {
                return;
            }
            ModuleDependenciesAnalyzer.OrderPathElement e = orderPath.entries().get(i2);
            int sz = parent.getChildCount();
            if (sz == 0) {
                n = null;
            } else {
                n = (DefaultMutableTreeNode)parent.getChildAt(sz - 1);
                if (!n.getUserObject().equals(e)) {
                    n = null;
                }
            }
            if (n == null) {
                n = new DefaultMutableTreeNode(e);
                parent.add(n);
            }
            this.addDependencyPath(n, orderPath, i2 + 1);
        }

        public void setDisplayName(String name) {
        }

        public JComponent createOptionsPanel() {
            JComponent tree = this.createTreeComponent();
            JPanel panel2 = new JPanel(new BorderLayout());
            JLabel paths = new JLabel("Available Through Paths:");
            paths.setDisplayedMnemonic('P');
            paths.setLabelFor(tree);
            panel2.add((Component)paths, "North");
            panel2.add((Component)tree, "Center");
            return panel2;
        }

        public void disposeUIResources() {
        }

        public String getHelpTopic() {
            return null;
        }

        public boolean isModified() {
            return false;
        }

        public void apply() throws ConfigurationException {
        }

        public void reset() {
        }

        public abstract CellAppearanceEx getAppearance(boolean var1, boolean var2);

        protected String suffixForBanner(String p) {
            if (p.length() > 80) {
                p = "..." + p.substring(p.length() - 80);
            }
            return p;
        }

        protected String prefixForBanner(String p) {
            if (p.length() > 80) {
                p = p.substring(0, 80) + "...";
            }
            return p;
        }
    }

    static class NavigateAction
    extends DumbAwareAction {
        NavigateAction() {
            super("Navigate to ...", "Navigate to place where path element is defined", null);
        }

        public void actionPerformed(AnActionEvent e) {
            Module module2 = (Module)e.getData(LangDataKeys.MODULE);
            if (module2 == null) {
                return;
            }
            ModuleDependenciesAnalyzer.OrderPathElement element = (ModuleDependenciesAnalyzer.OrderPathElement)e.getData(ORDER_PATH_ELEMENT_KEY);
            if (element != null && element instanceof ModuleDependenciesAnalyzer.OrderEntryPathElement) {
                ModuleDependenciesAnalyzer.OrderEntryPathElement o = (ModuleDependenciesAnalyzer.OrderEntryPathElement)element;
                OrderEntry entry = o.entry();
                Module m = entry.getOwnerModule();
                ProjectStructureConfigurable.getInstance(module2.getProject()).selectOrderEntry(m, entry);
            }
        }
    }
}

