/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraries;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.ModuleLibraryTable;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureValidator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ParameterizedRunnable;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.Predicate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryEditingUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil");

    private LibraryEditingUtil() {
    }

    public static boolean libraryAlreadyExists(LibraryTable.ModifiableModel table, String libraryName) {
        Iterator it = table.getLibraryIterator();
        while (it.hasNext()) {
            Library library = (Library)it.next();
            String libName = table instanceof LibrariesModifiableModel ? ((LibrariesModifiableModel)table).getLibraryEditor(library).getName() : library.getName();
            if (!libraryName.equals(libName)) continue;
            return true;
        }
        return false;
    }

    public static String suggestNewLibraryName(LibraryTable.ModifiableModel table, String baseName) {
        String candidateName = baseName;
        int idx = 1;
        while (LibraryEditingUtil.libraryAlreadyExists(table, candidateName)) {
            candidateName = baseName + idx++;
        }
        return candidateName;
    }

    public static Predicate<Library> getNotAddedSuitableLibrariesCondition(final ModuleRootModel rootModel, final FacetsProvider facetsProvider) {
        OrderEntry[] orderEntries = rootModel.getOrderEntries();
        final HashSet<Library> result2 = new HashSet<Library>(orderEntries.length);
        for (OrderEntry orderEntry : orderEntries) {
            LibraryImpl library;
            if (!(orderEntry instanceof LibraryOrderEntry) || !orderEntry.isValid() || (library = (LibraryImpl)((LibraryOrderEntry)orderEntry).getLibrary()) == null) continue;
            Library source = library.getSource();
            result2.add((Library)(source != null ? source : library));
        }
        return new Predicate<Library>(){

            public boolean apply(Library library) {
                LibraryType type2;
                Library source;
                if (result2.contains(library)) {
                    return false;
                }
                if (library instanceof LibraryImpl && (source = ((LibraryImpl)library).getSource()) != null && result2.contains(source)) {
                    return false;
                }
                PersistentLibraryKind kind2 = ((LibraryEx)library).getKind();
                return kind2 == null || (type2 = LibraryType.findByKind((LibraryKind)kind2)) == null || type2.isSuitableModule(rootModel.getModule(), facetsProvider);
            }
        };
    }

    public static void copyLibrary(LibraryEx from, Map<String, String> rootMapping, LibraryEx.ModifiableModelEx target) {
        target.setProperties(from.getProperties());
        for (OrderRootType type2 : OrderRootType.getAllTypes()) {
            String[] urls;
            for (String url : urls = from.getUrls(type2)) {
                String targetUrl;
                String pathInJar;
                String localPath;
                String protocol = VirtualFileManager.extractProtocol((String)url);
                if (protocol == null) continue;
                String fullPath = VirtualFileManager.extractPath((String)url);
                int sep = fullPath.indexOf("!/");
                if (sep != -1) {
                    localPath = fullPath.substring(0, sep);
                    pathInJar = fullPath.substring(sep);
                } else {
                    localPath = fullPath;
                    pathInJar = "";
                }
                String targetPath = rootMapping.get(localPath);
                String string = targetUrl = targetPath != null ? VirtualFileManager.constructUrl((String)protocol, (String)(targetPath + pathInJar)) : url;
                if (from.isJarDirectory(url, type2)) {
                    target.addJarDirectory(targetUrl, false, type2);
                    continue;
                }
                target.addRoot(targetUrl, type2);
            }
        }
    }

    public static LibraryTablePresentation getLibraryTablePresentation(@NotNull Project project2, @NotNull String level) {
        if (level.equals("module")) {
            return ModuleLibraryTable.MODULE_LIBRARY_TABLE_PRESENTATION;
        }
        LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(level, project2);
        LOG.assertTrue(table != null, (Object)level);
        return table.getPresentation();
    }

    public static List<LibraryType> getSuitableTypes(ClasspathPanel classpathPanel) {
        ArrayList<LibraryType> suitableTypes = new ArrayList<LibraryType>();
        suitableTypes.add(null);
        Module module2 = classpathPanel.getRootModel().getModule();
        for (LibraryType libraryType : (LibraryType[])LibraryType.EP_NAME.getExtensions()) {
            if (libraryType.getCreateActionName() == null || !libraryType.isSuitableModule(module2, classpathPanel.getModuleConfigurationState().getFacetsProvider())) continue;
            suitableTypes.add(libraryType);
        }
        return suitableTypes;
    }

    public static boolean hasSuitableTypes(ClasspathPanel panel2) {
        return LibraryEditingUtil.getSuitableTypes(panel2).size() > 1;
    }

    public static BaseListPopupStep<LibraryType> createChooseTypeStep(ClasspathPanel classpathPanel, final ParameterizedRunnable<LibraryType> action) {
        return new BaseListPopupStep<LibraryType>(IdeBundle.message((String)"popup.title.select.library.type", (Object[])new Object[0]), LibraryEditingUtil.getSuitableTypes(classpathPanel)){

            @NotNull
            public String getTextFor(LibraryType value2) {
                return value2 != null ? value2.getCreateActionName() : IdeBundle.message((String)"create.default.library.type.action.name", (Object[])new Object[0]);
            }

            public Icon getIconFor(LibraryType aValue) {
                return aValue != null ? aValue.getIcon(null) : PlatformIcons.LIBRARY_ICON;
            }

            public PopupStep onChosen(LibraryType selectedValue, boolean finalChoice) {
                return this.doFinalStep(() -> action.run((Object)selectedValue));
            }
        };
    }

    public static List<Module> getSuitableModules(@NotNull ModuleStructureConfigurable rootConfigurable, @Nullable LibraryKind kind2, @Nullable Library library) {
        ArrayList<Module> modules = new ArrayList<Module>();
        LibraryType type2 = kind2 == null ? null : LibraryType.findByKind(kind2);
        for (Module module2 : rootConfigurable.getModules()) {
            ModuleRootModel rootModel;
            if (type2 != null && !type2.isSuitableModule(module2, rootConfigurable.getFacetConfigurator()) || library != null && !LibraryEditingUtil.getNotAddedSuitableLibrariesCondition(rootModel = rootConfigurable.getContext().getModulesConfigurator().getRootModel(module2), rootConfigurable.getFacetConfigurator()).apply((Object)library)) continue;
            modules.add(module2);
        }
        return modules;
    }

    public static void showDialogAndAddLibraryToDependencies(@NotNull Library library, @NotNull Project project2, boolean allowEmptySelection) {
        ProjectStructureValidator.showDialogAndAddLibraryToDependencies(library, project2, allowEmptySelection);
    }
}

