/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraries.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryDetectionManager;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryPresentationManagerImpl
extends LibraryPresentationManager {
    private Map<LibraryKind, LibraryPresentationProvider<?>> myPresentationProviders;

    public static List<LibraryKind> getLibraryKinds(@NotNull Library library, @Nullable StructureConfigurableContext context) {
        SmartList result2 = new SmartList();
        PersistentLibraryKind kind2 = ((LibraryEx)library).getKind();
        if (kind2 != null) {
            result2.add(kind2);
        }
        VirtualFile[] files = LibraryPresentationManagerImpl.getLibraryFiles(library, context);
        LibraryDetectionManager.getInstance().processProperties(Arrays.asList(files), new LibraryDetectionManager.LibraryPropertiesProcessor((List)result2){
            final /* synthetic */ List val$result;
            {
                this.val$result = list;
            }

            @Override
            public <P extends LibraryProperties> boolean processProperties(@NotNull LibraryKind kind2, @NotNull P properties) {
                this.val$result.add(kind2);
                return true;
            }
        });
        return result2;
    }

    @NotNull
    private static VirtualFile[] getLibraryFiles(@NotNull Library library, @Nullable StructureConfigurableContext context) {
        if (((LibraryEx)library).isDisposed()) {
            return VirtualFile.EMPTY_ARRAY;
        }
        return context != null ? context.getLibraryFiles(library, OrderRootType.CLASSES) : library.getFiles(OrderRootType.CLASSES);
    }

    private <P extends LibraryProperties> LibraryPresentationProvider<P> getPresentationProvider(LibraryKind kind2) {
        if (this.myPresentationProviders == null) {
            HashMap providers = new HashMap();
            for (LibraryType type2 : (LibraryType[])LibraryType.EP_NAME.getExtensions()) {
                providers.put((LibraryKind)type2.getKind(), type2);
            }
            for (LibraryPresentationProvider provider2 : (LibraryPresentationProvider[])LibraryPresentationProvider.EP_NAME.getExtensions()) {
                providers.put(provider2.getKind(), provider2);
            }
            this.myPresentationProviders = providers;
        }
        return this.myPresentationProviders.get(kind2);
    }

    @Override
    @NotNull
    public Icon getNamedLibraryIcon(@NotNull Library library, @Nullable StructureConfigurableContext context) {
        Icon icon = this.getCustomIcon(library, context);
        return icon != null ? icon : PlatformIcons.LIBRARY_ICON;
    }

    @Override
    public Icon getCustomIcon(@NotNull Library library, StructureConfigurableContext context) {
        LibraryEx libraryEx = (LibraryEx)library;
        PersistentLibraryKind kind2 = libraryEx.getKind();
        if (kind2 != null) {
            return LibraryType.findByKind((LibraryKind)kind2).getIcon(libraryEx.getProperties());
        }
        List<Icon> icons = this.getCustomIcons(library, context);
        if (icons.size() == 1) {
            return icons.get(0);
        }
        return null;
    }

    @Override
    @NotNull
    public List<Icon> getCustomIcons(@NotNull Library library, StructureConfigurableContext context) {
        VirtualFile[] files = LibraryPresentationManagerImpl.getLibraryFiles(library, context);
        SmartList icons = new SmartList();
        LibraryDetectionManager.getInstance().processProperties(Arrays.asList(files), new LibraryDetectionManager.LibraryPropertiesProcessor((List)icons){
            final /* synthetic */ List val$icons;
            {
                this.val$icons = list;
            }

            @Override
            public <P extends LibraryProperties> boolean processProperties(@NotNull LibraryKind kind2, @NotNull P properties) {
                LibraryPresentationProvider provider2 = LibraryPresentationManagerImpl.this.getPresentationProvider(kind2);
                if (provider2 != null) {
                    ContainerUtil.addIfNotNull((Collection)this.val$icons, (Object)provider2.getIcon(properties));
                }
                return true;
            }
        });
        return icons;
    }

    @Override
    public boolean isLibraryOfKind(@NotNull List<VirtualFile> files, final @NotNull LibraryKind kind2) {
        return !LibraryDetectionManager.getInstance().processProperties(files, new LibraryDetectionManager.LibraryPropertiesProcessor(){

            @Override
            public <P extends LibraryProperties> boolean processProperties(@NotNull LibraryKind processedKind, @NotNull P properties) {
                return !kind2.equals(processedKind);
            }
        });
    }

    @Override
    public boolean isLibraryOfKind(@NotNull Library library, @NotNull LibrariesContainer librariesContainer, final @NotNull Set<? extends LibraryKind> acceptedKinds) {
        PersistentLibraryKind type2 = ((LibraryEx)library).getKind();
        if (type2 != null && acceptedKinds.contains(type2)) {
            return true;
        }
        VirtualFile[] files = librariesContainer.getLibraryFiles(library, OrderRootType.CLASSES);
        return !LibraryDetectionManager.getInstance().processProperties(Arrays.asList(files), new LibraryDetectionManager.LibraryPropertiesProcessor(){

            @Override
            public <P extends LibraryProperties> boolean processProperties(@NotNull LibraryKind processedKind, @NotNull P properties) {
                return !acceptedKinds.contains(processedKind);
            }
        });
    }

    @Override
    @NotNull
    public List<String> getDescriptions(@NotNull Library library, StructureConfigurableContext context) {
        VirtualFile[] files = LibraryPresentationManagerImpl.getLibraryFiles(library, context);
        return this.getDescriptions(files, Collections.emptySet());
    }

    @Override
    @NotNull
    public List<String> getDescriptions(@NotNull VirtualFile[] classRoots, final Set<LibraryKind> excludedKinds) {
        final SmartList result2 = new SmartList();
        LibraryDetectionManager.getInstance().processProperties(Arrays.asList(classRoots), new LibraryDetectionManager.LibraryPropertiesProcessor(){

            @Override
            public <P extends LibraryProperties> boolean processProperties(@NotNull LibraryKind kind2, @NotNull P properties) {
                LibraryPresentationProvider provider2;
                if (!excludedKinds.contains(kind2) && (provider2 = LibraryPresentationManagerImpl.this.getPresentationProvider(kind2)) != null) {
                    ContainerUtil.addIfNotNull((Collection)result2, (Object)provider2.getDescription(properties));
                }
                return true;
            }
        });
        return result2;
    }

    @Override
    public List<Library> getLibraries(@NotNull Set<LibraryKind> kinds, @NotNull Project project2, @Nullable StructureConfigurableContext context) {
        ArrayList<Library> libraries = new ArrayList<Library>();
        if (context != null) {
            Collections.addAll(libraries, context.getProjectLibrariesProvider().getModifiableModel().getLibraries());
            Collections.addAll(libraries, context.getGlobalLibrariesProvider().getModifiableModel().getLibraries());
        } else {
            LibraryTablesRegistrar registrar = LibraryTablesRegistrar.getInstance();
            Collections.addAll(libraries, registrar.getLibraryTable(project2).getLibraries());
            Collections.addAll(libraries, registrar.getLibraryTable().getLibraries());
        }
        Iterator iterator = libraries.iterator();
        while (iterator.hasNext()) {
            Library library = (Library)iterator.next();
            List<LibraryKind> libraryKinds = LibraryPresentationManagerImpl.getLibraryKinds(library, context);
            if (ContainerUtil.intersects(libraryKinds, kinds)) continue;
            iterator.remove();
        }
        return libraries;
    }
}

