/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ui.PathEditor;
import com.intellij.openapi.projectRoots.ui.SdkPathEditor;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.OrderRootTypeUIFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.jrt.JrtFileSystem;
import com.intellij.ui.components.JBList;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;

public class ClassesOrderRootTypeUIFactory
implements OrderRootTypeUIFactory {
    public SdkPathEditor createPathEditor(Sdk sdk) {
        return new MySdkPathEditor(new FileChooserDescriptor(true, true, true, false, true, true));
    }

    public Icon getIcon() {
        return AllIcons.Nodes.CompiledClassesFolder;
    }

    public String getNodeText() {
        return ProjectBundle.message((String)"library.classes.node", (Object[])new Object[0]);
    }

    private static boolean isJrtRoot(Object value2) {
        return value2 instanceof VirtualFile && JrtFileSystem.isModuleRoot((VirtualFile)((VirtualFile)value2));
    }

    private static class MySdkPathEditor
    extends SdkPathEditor {
        public MySdkPathEditor(FileChooserDescriptor descriptor) {
            super(ProjectBundle.message((String)"sdk.configure.classpath.tab", (Object[])new Object[0]), OrderRootType.CLASSES, descriptor);
        }

        protected boolean isRemoveActionEnabled(Object[] values) {
            if (!super.isRemoveActionEnabled(values)) {
                return false;
            }
            for (Object value2 : values) {
                if (!ClassesOrderRootTypeUIFactory.isJrtRoot(value2)) continue;
                return false;
            }
            return true;
        }

        protected ListCellRenderer createListCellRenderer(JBList list) {
            return new PathEditor.PathCellRenderer(){

                protected Icon getItemIcon(Object value2) {
                    return ClassesOrderRootTypeUIFactory.isJrtRoot(value2) ? AllIcons.Nodes.JavaModuleRoot : super.getItemIcon(value2);
                }
            };
        }
    }
}

