/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryDetectionManager;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorBase;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExistingLibraryEditor
extends LibraryEditorBase
implements Disposable {
    private final LibraryEx myLibrary;
    private final LibraryEditorListener myListener;
    private String myLibraryName = null;
    private LibraryProperties myLibraryProperties;
    private LibraryProperties myDetectedLibraryProperties;
    private LibraryEx.ModifiableModelEx myModel = null;
    private LibraryType<?> myDetectedType;
    private boolean myDetectedTypeComputed;

    public ExistingLibraryEditor(@NotNull Library library, @Nullable LibraryEditorListener listener2) {
        this.myLibrary = (LibraryEx)library;
        this.myListener = listener2;
    }

    public Library getLibrary() {
        return this.myLibrary;
    }

    @Override
    public String getName() {
        if (this.myLibraryName != null) {
            return this.myLibraryName;
        }
        return this.myLibrary.getName();
    }

    @Override
    public LibraryType<?> getType() {
        PersistentLibraryKind kind2 = this.myLibrary.getKind();
        if (kind2 != null) {
            return LibraryType.findByKind((LibraryKind)kind2);
        }
        return this.detectType();
    }

    @Override
    public void setType(@NotNull LibraryType<?> type2) {
        this.getModel().setKind(type2.getKind());
    }

    private LibraryType detectType() {
        if (!this.myDetectedTypeComputed) {
            Pair<LibraryType<?>, LibraryProperties<?>> pair;
            LibraryTable libraryTable = this.myLibrary.getTable();
            if ((libraryTable == null || libraryTable.isEditable()) && (pair = LibraryDetectionManager.getInstance().detectType(Arrays.asList(this.getFiles(OrderRootType.CLASSES)))) != null) {
                this.myDetectedType = (LibraryType)pair.getFirst();
                this.myDetectedLibraryProperties = (LibraryProperties)pair.getSecond();
            }
            this.myDetectedTypeComputed = true;
        }
        return this.myDetectedType;
    }

    @Override
    public LibraryProperties getProperties() {
        LibraryType<?> type2 = this.getType();
        if (type2 == null) {
            return null;
        }
        if (this.myDetectedType != null) {
            return this.myDetectedLibraryProperties;
        }
        if (this.myLibraryProperties == null) {
            this.myLibraryProperties = type2.getKind().createDefaultProperties();
            this.myLibraryProperties.loadState(this.getOriginalProperties().getState());
        }
        return this.myLibraryProperties;
    }

    @Override
    public void setProperties(LibraryProperties properties) {
        this.myLibraryProperties = properties;
    }

    private LibraryProperties getOriginalProperties() {
        return this.myLibrary.getProperties();
    }

    public void dispose() {
        if (this.myModel != null) {
            Disposer.dispose((Disposable)this.myModel);
        }
    }

    @Override
    public String[] getUrls(OrderRootType rootType) {
        if (this.myModel != null) {
            return this.myModel.getUrls(rootType);
        }
        return this.myLibrary.getUrls(rootType);
    }

    @Override
    public VirtualFile[] getFiles(OrderRootType rootType) {
        if (this.myModel != null) {
            return this.myModel.getFiles(rootType);
        }
        return this.myLibrary.getFiles(rootType);
    }

    @Override
    public String[] getExcludedRootUrls() {
        if (this.myModel != null) {
            return this.myModel.getExcludedRootUrls();
        }
        return this.myLibrary.getExcludedRootUrls();
    }

    @Override
    public void setName(String name) {
        String oldName = this.getModel().getName();
        this.myLibraryName = name;
        this.getModel().setName(name);
        if (this.myListener != null) {
            this.myListener.libraryRenamed((Library)this.myLibrary, oldName, name);
        }
    }

    @Override
    public void addRoot(VirtualFile file2, OrderRootType rootType) {
        this.getModel().addRoot(file2, rootType);
    }

    @Override
    public void addRoot(String url, OrderRootType rootType) {
        this.getModel().addRoot(url, rootType);
    }

    @Override
    public void addExcludedRoot(@NotNull String url) {
        this.getModel().addExcludedRoot(url);
    }

    @Override
    public void addJarDirectory(VirtualFile file2, boolean recursive, OrderRootType rootType) {
        this.getModel().addJarDirectory(file2, recursive, rootType);
    }

    @Override
    public void addJarDirectory(String url, boolean recursive, OrderRootType rootType) {
        this.getModel().addJarDirectory(url, recursive, rootType);
    }

    @Override
    public void removeRoot(String url, OrderRootType rootType) {
        boolean removed;
        while (removed = this.getModel().removeRoot(url, rootType)) {
        }
    }

    @Override
    public void removeExcludedRoot(@NotNull String url) {
        this.getModel().removeExcludedRoot(url);
    }

    public void commit() {
        if (this.myModel != null) {
            if (this.myLibraryProperties != null) {
                this.myModel.setProperties(this.myLibraryProperties);
            }
            this.myModel.commit();
            this.myModel = null;
            this.myLibraryName = null;
            this.myLibraryProperties = null;
        }
    }

    public LibraryEx.ModifiableModelEx getModel() {
        if (this.myModel == null) {
            this.myModel = this.myLibrary.getModifiableModel();
        }
        return this.myModel;
    }

    @Override
    public boolean hasChanges() {
        if (this.myModel != null && this.myModel.isChanged()) {
            return true;
        }
        return this.myLibraryProperties != null && !this.myLibraryProperties.equals((Object)this.getOriginalProperties());
    }

    @Override
    public boolean isJarDirectory(String url, OrderRootType rootType) {
        if (this.myModel != null) {
            return this.myModel.isJarDirectory(url, rootType);
        }
        return this.myLibrary.isJarDirectory(url, rootType);
    }

    @Override
    public boolean isValid(String url, OrderRootType orderRootType) {
        if (this.myModel != null) {
            return this.myModel.isValid(url, orderRootType);
        }
        return this.myLibrary.isValid(url, orderRootType);
    }

    @Override
    public Collection<OrderRootType> getOrderRootTypes() {
        return Arrays.asList(OrderRootType.getAllTypes());
    }
}

