/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class LibraryEditorBase
implements LibraryEditor {
    @Override
    public void removeAllRoots() {
        ArrayList<OrderRootType> types = new ArrayList<OrderRootType>(this.getOrderRootTypes());
        for (OrderRootType type2 : types) {
            String[] urls;
            for (String url : urls = this.getUrls(type2)) {
                this.removeRoot(url, type2);
            }
        }
    }

    protected abstract Collection<OrderRootType> getOrderRootTypes();

    public abstract void setProperties(LibraryProperties var1);

    public abstract void setType(@NotNull LibraryType<?> var1);

    @Override
    public void addRoots(Collection<? extends OrderRoot> roots) {
        for (OrderRoot orderRoot : roots) {
            if (orderRoot.isJarDirectory()) {
                this.addJarDirectory(orderRoot.getFile(), false, orderRoot.getType());
                continue;
            }
            this.addRoot(orderRoot.getFile(), orderRoot.getType());
        }
    }
}

