/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ui.FormBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryNameAndLevelPanel {
    private JTextField myLibraryNameField = new JTextField(25);
    private JComboBox myLevelComboBox;
    private String myDefaultLibraryName;

    public LibraryNameAndLevelPanel(@NotNull FormBuilder formBuilder, @NotNull String libraryName, @Nullable LibrariesContainer.LibraryLevel level) {
        this(formBuilder, libraryName, Arrays.asList(LibrariesContainer.LibraryLevel.values()), level);
    }

    public LibraryNameAndLevelPanel(@NotNull FormBuilder formBuilder, @NotNull String libraryName, @NotNull List<LibrariesContainer.LibraryLevel> availableLevels, @Nullable LibrariesContainer.LibraryLevel level) {
        formBuilder.addLabeledComponent("&Name:", (JComponent)this.myLibraryNameField);
        this.myLibraryNameField.setText(libraryName);
        this.myLevelComboBox = new JComboBox();
        if (level != null && !availableLevels.isEmpty()) {
            formBuilder.addLabeledComponent("&Level:", (JComponent)this.myLevelComboBox);
            final HashMap<LibrariesContainer.LibraryLevel, String> levels = new HashMap<LibrariesContainer.LibraryLevel, String>();
            levels.put(LibrariesContainer.LibraryLevel.GLOBAL, ProjectBundle.message((String)"combobox.item.global.library", (Object[])new Object[0]));
            levels.put(LibrariesContainer.LibraryLevel.PROJECT, ProjectBundle.message((String)"combobox.item.project.library", (Object[])new Object[0]));
            levels.put(LibrariesContainer.LibraryLevel.MODULE, ProjectBundle.message((String)"combobox.item.module.library", (Object[])new Object[0]));
            this.myLevelComboBox.setRenderer(new ListCellRendererWrapper(){

                public void customize(JList list, Object value2, int index, boolean selected, boolean hasFocus) {
                    if (value2 instanceof LibrariesContainer.LibraryLevel) {
                        LibrariesContainer.LibraryLevel level = (LibrariesContainer.LibraryLevel)((Object)value2);
                        this.setText((String)levels.get((Object)level));
                    }
                }
            });
            this.myLevelComboBox.setModel(new CollectionComboBoxModel(availableLevels, (Object)level));
        }
    }

    public String getLibraryName() {
        return this.myLibraryNameField.getText();
    }

    public LibrariesContainer.LibraryLevel getLibraryLevel() {
        return (LibrariesContainer.LibraryLevel)((Object)this.myLevelComboBox.getSelectedItem());
    }

    public JTextField getLibraryNameField() {
        return this.myLibraryNameField;
    }

    public JComboBox getLevelComboBox() {
        return this.myLevelComboBox;
    }

    public void setDefaultName(@NotNull String defaultLibraryName) {
        if (this.myDefaultLibraryName != null && this.myDefaultLibraryName.equals(this.getLibraryName())) {
            this.myLibraryNameField.setText(defaultLibraryName);
        }
        this.myDefaultLibraryName = defaultLibraryName;
    }

    public static FormBuilder createFormBuilder() {
        return FormBuilder.createFormBuilder();
    }
}

