/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.CommonBundle;
import com.intellij.facet.Facet;
import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.facet.impl.ui.actions.AddFacetToModuleAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ModuleGroupingTreeHelper;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.NamePathComponent;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleGrouperKt;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetEditorFacadeImpl;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureExtension;
import com.intellij.openapi.roots.ui.configuration.projectRoot.RemoveConfigurableHandler;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.TextConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.ui.navigation.Place;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleStructureConfigurable
extends BaseStructureConfigurable
implements Place.Navigator {
    private static final Comparator<MasterDetailsComponent.MyNode> NODE_COMPARATOR = (o1, o2) -> {
        NamedConfigurable configurable1 = o1.getConfigurable();
        NamedConfigurable configurable2 = o2.getConfigurable();
        if (configurable1.getClass() == configurable2.getClass()) {
            return StringUtil.naturalCompare((String)o1.getDisplayName(), (String)o2.getDisplayName());
        }
        Object editableObject1 = configurable1.getEditableObject();
        Object editableObject2 = configurable2.getEditableObject();
        if (editableObject2 instanceof Module && editableObject1 instanceof ModuleGroup) {
            return -1;
        }
        if (editableObject1 instanceof Module && editableObject2 instanceof ModuleGroup) {
            return 1;
        }
        if (editableObject2 instanceof Module && editableObject1 instanceof String) {
            return 1;
        }
        if (editableObject1 instanceof Module && editableObject2 instanceof String) {
            return -1;
        }
        if (editableObject2 instanceof Module && editableObject1 instanceof Facet) {
            return 1;
        }
        if (editableObject1 instanceof Module && editableObject2 instanceof Facet) {
            return -1;
        }
        if (editableObject2 instanceof ModuleGroup && editableObject1 instanceof String) {
            return 1;
        }
        if (editableObject1 instanceof ModuleGroup && editableObject2 instanceof String) {
            return -1;
        }
        return 0;
    };
    private boolean myHideModuleGroups;
    private boolean myFlattenModules;
    private final ModuleManager myModuleManager;
    private final FacetEditorFacadeImpl myFacetEditorFacade;
    private final List<RemoveConfigurableHandler<?>> myRemoveHandlers;

    public ModuleStructureConfigurable(Project project2, ModuleManager manager) {
        super(project2);
        this.myFacetEditorFacade = new FacetEditorFacadeImpl(this, this.TREE_UPDATER);
        this.myModuleManager = manager;
        this.myRemoveHandlers = new ArrayList();
        this.myRemoveHandlers.add(new ModuleRemoveHandler());
        this.myRemoveHandlers.add(new FacetInModuleRemoveHandler());
        for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            this.myRemoveHandlers.addAll(extension.getRemoveHandlers());
        }
    }

    protected String getComponentStateKey() {
        return "ModuleStructureConfigurable.UI";
    }

    @Override
    protected void initTree() {
        super.initTree();
        this.myTree.setRootVisible(false);
    }

    protected ArrayList<AnAction> getAdditionalActions() {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        result2.add(ActionManager.getInstance().getAction("MoveModuleToGroup"));
        return result2;
    }

    public void addNode(MasterDetailsComponent.MyNode nodeToAdd, MasterDetailsComponent.MyNode parent) {
        super.addNode(nodeToAdd, parent);
    }

    @Override
    @NotNull
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> result2 = super.createActions(fromPopup);
        if (fromPopup) {
            result2.add((AnAction)Separator.getInstance());
            result2.add((AnAction)new FlattenModulesAction());
            result2.add((AnAction)new HideGroupsAction());
            this.addCollapseExpandActions(result2);
        }
        return result2;
    }

    @Override
    @NotNull
    protected List<? extends AnAction> createCopyActions(boolean fromPopup) {
        return Collections.singletonList(new MyCopyAction());
    }

    @Override
    protected void loadTree() {
        this.createProjectNodes();
        this.getTreeModel().reload();
        this.myUiDisposed = false;
    }

    @Override
    @NotNull
    protected Collection<? extends ProjectStructureElement> getProjectStructureElements() {
        ArrayList<ModuleProjectStructureElement> result2 = new ArrayList<ModuleProjectStructureElement>();
        for (Module module2 : this.myModuleManager.getModules()) {
            result2.add(new ModuleProjectStructureElement(this.myContext, module2));
        }
        return result2;
    }

    protected void updateSelection(@Nullable NamedConfigurable configurable) {
        FacetStructureConfigurable.getInstance(this.myProject).disposeMultipleSettingsEditor();
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.updateSelection(configurable);
        if (configurable != null) {
            this.updateModuleEditorSelection(configurable);
        }
    }

    protected boolean isAutoScrollEnabled() {
        return this.myAutoScrollEnabled;
    }

    protected boolean updateMultiSelection(List<NamedConfigurable> selectedConfigurables) {
        return FacetStructureConfigurable.getInstance(this.myProject).updateMultiSelection(selectedConfigurables, this.getDetailsComponent());
    }

    private void updateModuleEditorSelection(NamedConfigurable configurable) {
        ModuleConfigurable moduleConfigurable;
        ModuleEditor editor;
        if (configurable instanceof ModuleConfigurable && (editor = (moduleConfigurable = (ModuleConfigurable)configurable).getModuleEditor()) != null) {
            editor.init(this.myHistory);
        }
        if (configurable instanceof FacetConfigurable) {
            ((FacetConfigurable)configurable).getEditor().onFacetSelected();
        }
    }

    private void createProjectNodes() {
        ModuleGrouper moduleGrouper = this.getModuleGrouper();
        ModuleGroupingTreeHelper<MasterDetailsComponent.MyNode> helper = ModuleGroupingTreeHelper.forEmptyTree(!this.myHideModuleGroups && !this.myFlattenModules, moduleGrouper, ModuleStructureConfigurable::createModuleGroupNode, this::createModuleNode, this.getNodeComparator());
        helper.createModuleNodes(Arrays.asList(this.myModuleManager.getModules()), this.myRoot, this.getTreeModel());
        if (ModuleStructureConfigurable.containsSecondLevelNodes((TreeNode)this.myRoot)) {
            this.myTree.setShowsRootHandles(true);
        }
        this.sortDescendants(this.myRoot);
        if (this.myProject.isDefault()) {
            this.myRoot.removeAllChildren();
        }
        this.addRootNodesFromExtensions(this.myRoot, this.myProject);
    }

    private static boolean containsSecondLevelNodes(TreeNode rootNode) {
        int count = rootNode.getChildCount();
        for (int i2 = 0; i2 < count; ++i2) {
            TreeNode child = rootNode.getChildAt(i2);
            if (child.getChildCount() <= 0) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private ModuleNode createModuleNode(Module module2, ModuleGrouper moduleGrouper) {
        ModuleConfigurable configurable = new ModuleConfigurable(this.myContext.myModulesConfigurator, module2, this.TREE_UPDATER, moduleGrouper);
        List groupPath = moduleGrouper.getModuleAsGroupPath(module2);
        ModuleNode node = new ModuleNode(configurable, groupPath != null ? new ModuleGroup(groupPath) : null);
        this.myFacetEditorFacade.addFacetsNodes(module2, node);
        this.addNodesFromExtensions(module2, node);
        return node;
    }

    @NotNull
    private static MasterDetailsComponent.MyNode createModuleGroupNode(ModuleGroup moduleGroup) {
        TextConfigurable<ModuleGroup> moduleGroupConfigurable = new TextConfigurable<ModuleGroup>(moduleGroup, moduleGroup.toString(), ProjectBundle.message((String)"module.group.banner.text", (Object[])new Object[]{moduleGroup.toString()}), ProjectBundle.message((String)"project.roots.module.groups.text", (Object[])new Object[0]), PlatformIcons.CLOSED_MODULE_GROUP_ICON);
        return new ModuleGroupNodeImpl(moduleGroupConfigurable, moduleGroup);
    }

    private void addRootNodesFromExtensions(MasterDetailsComponent.MyNode root, Project project2) {
        for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            extension.addRootNodes(root, project2, this.TREE_UPDATER);
        }
    }

    private void addNodesFromExtensions(Module module2, MasterDetailsComponent.MyNode moduleNode) {
        for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            extension.addModuleNodeChildren(module2, moduleNode, this.TREE_UPDATER);
        }
    }

    public boolean updateProjectTree(Module[] modules) {
        if (this.myRoot.getChildCount() == 0) {
            return false;
        }
        ArrayList<Pair> nodes = new ArrayList<Pair>(modules.length);
        for (Module module2 : modules) {
            MasterDetailsComponent.MyNode node = this.findModuleNode(module2);
            LOG.assertTrue(node != null, (Object)("Module " + module2.getName() + " is not in project."));
            nodes.add(Pair.create((Object)node, (Object)module2));
        }
        ModuleGroupingTreeHelper<MasterDetailsComponent.MyNode> helper = this.createGroupingHelper();
        helper.moveModuleNodesToProperGroup(nodes, this.myRoot, this.getTreeModel(), (JTree)this.myTree);
        return true;
    }

    private DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.myTree.getModel();
    }

    @NotNull
    private ModuleGroupingTreeHelper<MasterDetailsComponent.MyNode> createGroupingHelper() {
        return ModuleGroupingTreeHelper.forTree(this.myRoot, node -> node instanceof ModuleGroupNode ? ((ModuleGroupNode)node).getModuleGroup() : null, node -> node instanceof ModuleNode ? ((ModuleNode)node).getModule() : null, !this.myHideModuleGroups && !this.myFlattenModules, this.getModuleGrouper(), ModuleStructureConfigurable::createModuleGroupNode, this::createModuleNode, this.getNodeComparator());
    }

    protected Comparator<MasterDetailsComponent.MyNode> getNodeComparator() {
        List comparators = ContainerUtil.mapNotNull((Object[])ModuleStructureExtension.EP_NAME.getExtensions(), moduleStructureExtension -> moduleStructureExtension.getNodeComparator());
        return new MergingComparator<MasterDetailsComponent.MyNode>(ContainerUtil.concat((List)comparators, Collections.singletonList(NODE_COMPARATOR)));
    }

    @Override
    public void init(StructureConfigurableContext context) {
        super.init(context);
        this.addItemsChangeListener(new MasterDetailsComponent.ItemsChangeListener(){

            public void itemChanged(@Nullable Object deletedItem) {
                if (deletedItem instanceof Library) {
                    Library library = (Library)deletedItem;
                    MasterDetailsComponent.MyNode node = MasterDetailsComponent.findNodeByObject((TreeNode)ModuleStructureConfigurable.this.myRoot, (Object)library);
                    if (node != null) {
                        TreeNode parent = node.getParent();
                        node.removeFromParent();
                        ModuleStructureConfigurable.this.getTreeModel().reload(parent);
                    }
                    ModuleStructureConfigurable.this.myContext.getDaemonAnalyzer().removeElement(new LibraryProjectStructureElement(ModuleStructureConfigurable.this.myContext, library));
                }
            }

            public void itemsExternallyChanged() {
            }
        });
    }

    @Override
    public void reset() {
        super.reset();
        for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            extension.reset(this.myProject);
        }
    }

    public void apply() throws ConfigurationException {
        this.checkForEmptyAndDuplicatedNames(ProjectBundle.message((String)"rename.message.prefix.module", (Object[])new Object[0]), ProjectBundle.message((String)"rename.module.title", (Object[])new Object[0]), ModuleConfigurable.class);
        for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            if (!extension.isModified()) continue;
            extension.apply();
        }
        if (this.myContext.myModulesConfigurator.isModified()) {
            this.myContext.myModulesConfigurator.apply();
        }
        for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            extension.afterModelCommit();
        }
    }

    public boolean isModified() {
        if (this.myContext.myModulesConfigurator.isModified()) {
            return true;
        }
        for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            if (!extension.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void disposeUIResources() {
        super.disposeUIResources();
        this.myFacetEditorFacade.clearMaps(true);
        this.myContext.myModulesConfigurator.disposeUIResources();
        super.disposeUIResources();
        for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            extension.disposeUIResources();
        }
    }

    public void dispose() {
    }

    @NotNull
    public JComponent createComponent() {
        return new MyDataProviderWrapper(super.createComponent());
    }

    protected void processRemovedItems() {
    }

    protected boolean wasObjectStored(Object editableObject) {
        return false;
    }

    public String getDisplayName() {
        return ProjectBundle.message((String)"project.roots.display.name", (Object[])new Object[0]);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        String topic = super.getHelpTopic();
        if (topic != null) {
            return topic;
        }
        return "reference.settingsdialog.project.structure.module";
    }

    public ActionCallback selectOrderEntry(@NotNull Module module2, @Nullable OrderEntry orderEntry) {
        for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            ActionCallback callback = extension.selectOrderEntry(module2, orderEntry);
            if (callback == null) continue;
            return callback;
        }
        Place p = new Place();
        p.putPath("category", (Object)this);
        Runnable r = null;
        MasterDetailsComponent.MyNode node = this.findModuleNode(module2);
        if (node != null) {
            p.putPath("treeObject", (Object)module2);
            p.putPath("selectedEditor", (Object)ClasspathEditor.NAME);
            r = () -> {
                ModuleEditor moduleEditor;
                ModuleConfigurationEditor editor;
                if (orderEntry != null && (editor = (moduleEditor = ((ModuleConfigurable)node.getConfigurable()).getModuleEditor()).getEditor(ClasspathEditor.NAME)) instanceof ClasspathEditor) {
                    ((ClasspathEditor)editor).selectOrderEntry(orderEntry);
                }
            };
        }
        ActionCallback result2 = ProjectStructureConfigurable.getInstance(this.myProject).navigateTo(p, true);
        return r != null ? result2.doWhenDone(r) : result2;
    }

    private ModuleGrouper getModuleGrouper() {
        return ModuleGrouper.instanceFor((Project)this.myProject, (ModifiableModuleModel)this.myContext.myModulesConfigurator.getModuleModel());
    }

    public static ModuleStructureConfigurable getInstance(Project project2) {
        return (ModuleStructureConfigurable)((Object)ServiceManager.getService((Project)project2, ModuleStructureConfigurable.class));
    }

    public Project getProject() {
        return this.myProject;
    }

    public Module[] getModules() {
        if (this.myContext.myModulesConfigurator != null) {
            ModifiableModuleModel model = this.myContext.myModulesConfigurator.getModuleModel();
            return model.getModules();
        }
        return this.myModuleManager.getModules();
    }

    public void removeLibraryOrderEntry(Module module2, Library library) {
        OrderEntry[] entries;
        ModuleEditor moduleEditor = this.myContext.myModulesConfigurator.getModuleEditor(module2);
        LOG.assertTrue(moduleEditor != null, (Object)"Current module editor was not initialized");
        ModifiableRootModel modelProxy = moduleEditor.getModifiableRootModelProxy();
        for (OrderEntry entry : entries = modelProxy.getOrderEntries()) {
            if (!(entry instanceof LibraryOrderEntry) || !Comparing.strEqual((String)entry.getPresentableName(), (String)library.getName())) continue;
            modelProxy.removeOrderEntry(entry);
            break;
        }
        this.myContext.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(this.myContext, module2));
        this.myTree.repaint();
    }

    public void addLibraryOrderEntry(Module module2, Library library) {
        OrderEntry[] entries;
        ModuleEditor moduleEditor = this.myContext.myModulesConfigurator.getModuleEditor(module2);
        LOG.assertTrue(moduleEditor != null, (Object)"Current module editor was not initialized");
        ModifiableRootModel modelProxy = moduleEditor.getModifiableRootModelProxy();
        for (OrderEntry entry : entries = modelProxy.getOrderEntries()) {
            if (!(entry instanceof LibraryOrderEntry) || !Comparing.strEqual((String)entry.getPresentableName(), (String)library.getName()) || Messages.showYesNoDialog((Project)module2.getProject(), (String)ProjectBundle.message((String)"project.roots.replace.library.entry.message", (Object[])new Object[]{entry.getPresentableName()}), (String)ProjectBundle.message((String)"project.roots.replace.library.entry.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon()) != 0) continue;
            modelProxy.removeOrderEntry(entry);
            break;
        }
        modelProxy.addLibraryEntry(library);
        this.myContext.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(this.myContext, module2));
        this.myTree.repaint();
    }

    @Nullable
    public MasterDetailsComponent.MyNode findModuleNode(Module module2) {
        return ModuleStructureConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)module2);
    }

    public FacetEditorFacadeImpl getFacetEditorFacade() {
        return this.myFacetEditorFacade;
    }

    public ProjectFacetsConfigurator getFacetConfigurator() {
        return this.myContext.myModulesConfigurator.getFacetsConfigurator();
    }

    private void addModule(boolean anImport) {
        List<Module> modules = this.myContext.myModulesConfigurator.addModule((Component)this.myTree, anImport);
        if (modules != null) {
            for (Module module2 : modules) {
                this.addModuleNode(module2);
            }
        }
    }

    private void addModuleNode(Module module2) {
        TreePath selectionPath = this.myTree.getSelectionPath();
        MasterDetailsComponent.MyNode parent = null;
        if (selectionPath != null) {
            ModifiableModuleModel modifiableModuleModel;
            String[] groupPath;
            MasterDetailsComponent.MyNode selected = (MasterDetailsComponent.MyNode)selectionPath.getLastPathComponent();
            Object o = selected.getConfigurable().getEditableObject();
            if (o instanceof ModuleGroup) {
                this.myContext.myModulesConfigurator.getModuleModel().setModuleGroupPath(module2, ((ModuleGroup)o).getGroupPath());
                parent = selected;
            } else if (o instanceof Module && (groupPath = (modifiableModuleModel = this.myContext.myModulesConfigurator.getModuleModel()).getModuleGroupPath((Module)o)) != null) {
                modifiableModuleModel.setModuleGroupPath(module2, groupPath);
                parent = ModuleStructureConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)new ModuleGroup(Arrays.asList(groupPath)));
            }
        }
        if (parent == null) {
            parent = this.myRoot;
        }
        ModuleNode node = this.createModuleNode(module2, this.getModuleGrouper());
        TreeUtil.insertNode((MutableTreeNode)node, (MutableTreeNode)parent, (DefaultTreeModel)this.getTreeModel(), this.getNodeComparator());
        this.selectNodeInTree((DefaultMutableTreeNode)((Object)node));
        ProjectStructureDaemonAnalyzer daemonAnalyzer = this.myContext.getDaemonAnalyzer();
        daemonAnalyzer.queueUpdate(new ModuleProjectStructureElement(this.myContext, module2));
        daemonAnalyzer.queueUpdateForAllElementsWithErrors();
    }

    @Nullable
    public Module getSelectedModule() {
        Object selectedObject = this.getSelectedObject();
        if (selectedObject instanceof Module) {
            return (Module)selectedObject;
        }
        if (selectedObject instanceof Library && ((Library)selectedObject).getTable() == null) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myTree.getSelectionPath().getLastPathComponent();
            return (Module)((MasterDetailsComponent.MyNode)node.getParent()).getConfigurable().getEditableObject();
        }
        return null;
    }

    @NotNull
    @NonNls
    public String getId() {
        return "project.structure";
    }

    @Nullable
    public Module getModule(String moduleName) {
        if (moduleName == null) {
            return null;
        }
        return this.myContext != null && this.myContext.myModulesConfigurator != null ? this.myContext.myModulesConfigurator.getModule(moduleName) : this.myModuleManager.findModuleByName(moduleName);
    }

    public StructureConfigurableContext getContext() {
        return this.myContext;
    }

    private static boolean canBeCopiedByExtension(NamedConfigurable configurable) {
        for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            if (!extension.canBeCopied(configurable)) continue;
            return true;
        }
        return false;
    }

    private void copyByExtension(NamedConfigurable configurable) {
        for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            extension.copy(configurable, this.TREE_UPDATER);
        }
    }

    private void regroupModules() {
        DefaultMutableTreeNode selection = null;
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null) {
            selection = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        }
        this.createGroupingHelper().moveAllModuleNodesToProperGroups(this.myRoot, this.getTreeModel());
        if (selection != null) {
            TreeUtil.selectInTree((DefaultMutableTreeNode)selection, (boolean)true, (JTree)this.myTree);
        }
    }

    @Override
    protected BaseStructureConfigurable.AbstractAddGroup createAddAction() {
        return new BaseStructureConfigurable.AbstractAddGroup(ProjectBundle.message((String)"add.new.header.text", (Object[])new Object[0])){

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                ArrayList<Object> result2 = new ArrayList<Object>();
                AddModuleAction addModuleAction = new AddModuleAction(false);
                addModuleAction.getTemplatePresentation().setText("New Module");
                result2.add((Object)addModuleAction);
                AddModuleAction importModuleAction = new AddModuleAction(true);
                importModuleAction.getTemplatePresentation().setText("Import Module");
                importModuleAction.getTemplatePresentation().setIcon(AllIcons.ToolbarDecorator.Import);
                result2.add((Object)importModuleAction);
                Collection<AnAction> actions = AddFacetToModuleAction.createAddFrameworkActions(ModuleStructureConfigurable.this.myFacetEditorFacade, ModuleStructureConfigurable.this.myProject);
                if (!actions.isEmpty()) {
                    result2.add(new Separator(ProjectBundle.message((String)"add.group.framework.separator", (Object[])new Object[0])));
                    result2.addAll(actions);
                }
                NullableComputable selectedNodeRetriever = () -> {
                    Object lastPathComponent;
                    TreePath selectionPath = ModuleStructureConfigurable.this.myTree.getSelectionPath();
                    Object object = lastPathComponent = selectionPath == null ? null : selectionPath.getLastPathComponent();
                    if (lastPathComponent instanceof MasterDetailsComponent.MyNode) {
                        return (MasterDetailsComponent.MyNode)lastPathComponent;
                    }
                    return null;
                };
                ArrayList<AnAction> actionsFromExtensions = new ArrayList<AnAction>();
                for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
                    actionsFromExtensions.addAll(extension.createAddActions((NullableComputable<MasterDetailsComponent.MyNode>)selectedNodeRetriever, ModuleStructureConfigurable.this.TREE_UPDATER, ModuleStructureConfigurable.this.myProject, ModuleStructureConfigurable.this.myRoot));
                }
                if (!actionsFromExtensions.isEmpty() && !result2.isEmpty()) {
                    result2.add(new Separator());
                }
                result2.addAll(actionsFromExtensions);
                return result2.toArray(new AnAction[result2.size()]);
            }
        };
    }

    protected List<RemoveConfigurableHandler<?>> getRemoveHandlers() {
        return this.myRemoveHandlers;
    }

    @Nullable
    protected String getEmptySelectionString() {
        return ProjectBundle.message((String)"empty.module.selection.string", (Object[])new Object[0]);
    }

    private static class MergingComparator<T>
    implements Comparator<T> {
        private final List<Comparator<T>> myDelegates;

        public MergingComparator(List<Comparator<T>> delegates) {
            this.myDelegates = delegates;
        }

        @Override
        public int compare(T o1, T o2) {
            for (Comparator<T> delegate : this.myDelegates) {
                int value2 = delegate.compare(o1, o2);
                if (value2 == 0) continue;
                return value2;
            }
            return 0;
        }
    }

    private class AddModuleAction
    extends AnAction
    implements DumbAware {
        private final boolean myImport;

        public AddModuleAction(boolean anImport) {
            super(ProjectBundle.message((String)"add.new.module.text.full", (Object[])new Object[0]), null, AllIcons.Actions.Module);
            this.myImport = anImport;
        }

        public void actionPerformed(AnActionEvent e) {
            ModuleStructureConfigurable.this.addModule(this.myImport);
        }
    }

    private class MyCopyAction
    extends AnAction
    implements DumbAware {
        private MyCopyAction() {
            super(CommonBundle.message((String)"button.copy", (Object[])new Object[0]), CommonBundle.message((String)"button.copy", (Object[])new Object[0]), COPY_ICON);
        }

        public void actionPerformed(AnActionEvent e) {
            NamedConfigurable namedConfigurable = ModuleStructureConfigurable.this.getSelectedConfigurable();
            if (namedConfigurable instanceof ModuleConfigurable) {
                try {
                    ModuleEditor moduleEditor = ((ModuleConfigurable)namedConfigurable).getModuleEditor();
                    String modulePresentation = IdeBundle.message((String)"project.new.wizard.module.identification", (Object[])new Object[0]);
                    final NamePathComponent component = new NamePathComponent(IdeBundle.message((String)"label.module.name", (Object[])new Object[0]), IdeBundle.message((String)"label.component.file.location", (Object[])new Object[]{StringUtil.capitalize((String)modulePresentation)}), IdeBundle.message((String)"title.select.project.file.directory", (Object[])new Object[]{modulePresentation}), IdeBundle.message((String)"description.select.project.file.directory", (Object[])new Object[]{StringUtil.capitalize((String)modulePresentation)}), true, false);
                    Module originalModule = moduleEditor.getModule();
                    if (originalModule != null) {
                        component.setPath(FileUtil.toSystemDependentName((String)PathUtil.getParentPath((String)originalModule.getModuleFilePath())));
                    }
                    DialogBuilder dialogBuilder = new DialogBuilder((Component)ModuleStructureConfigurable.this.myTree);
                    dialogBuilder.setTitle(ProjectBundle.message((String)"copy.module.dialog.title", (Object[])new Object[0]));
                    dialogBuilder.setCenterPanel((JComponent)component);
                    dialogBuilder.setPreferredFocusComponent((JComponent)component.getNameComponent());
                    dialogBuilder.setOkOperation(() -> {
                        String name = component.getNameValue();
                        if (name.length() == 0) {
                            Messages.showErrorDialog((String)ProjectBundle.message((String)"enter.module.copy.name.error.message", (Object[])new Object[0]), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]));
                            return;
                        }
                        if (ModuleStructureConfigurable.this.getModule(name) != null) {
                            Messages.showErrorDialog((String)ProjectBundle.message((String)"module.0.already.exists.error.message", (Object[])new Object[]{name}), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]));
                            return;
                        }
                        if (component.getPath().length() == 0) {
                            Messages.showErrorDialog((String)IdeBundle.message((String)"prompt.enter.project.file.location", (Object[])new Object[]{modulePresentation}), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]));
                            return;
                        }
                        if (!ProjectWizardUtil.createDirectoryIfNotExists(IdeBundle.message((String)"directory.project.file.directory", (Object[])new Object[]{modulePresentation}), component.getPath(), true)) {
                            Messages.showErrorDialog((String)ProjectBundle.message((String)"path.0.is.invalid.error.message", (Object[])new Object[]{component.getPath()}), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]));
                            return;
                        }
                        dialogBuilder.getDialogWrapper().close(0);
                    });
                    if (dialogBuilder.show() != 0) {
                        return;
                    }
                    final ModifiableRootModel rootModel = moduleEditor.getModifiableRootModel();
                    String path = component.getPath();
                    ModuleBuilder builder = new ModuleBuilder(){

                        public void setupRootModel(ModifiableRootModel modifiableRootModel) throws ConfigurationException {
                            if (rootModel.isSdkInherited()) {
                                modifiableRootModel.inheritSdk();
                            } else {
                                modifiableRootModel.setSdk(rootModel.getSdk());
                            }
                            ((CompilerModuleExtension)modifiableRootModel.getModuleExtension(CompilerModuleExtension.class)).inheritCompilerOutputPath(true);
                            ((LanguageLevelModuleExtension)modifiableRootModel.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(LanguageLevelModuleExtensionImpl.getInstance((Module)rootModel.getModule()).getLanguageLevel());
                            for (OrderEntry entry : rootModel.getOrderEntries()) {
                                if (entry instanceof JdkOrderEntry || entry instanceof ModuleSourceOrderEntry || !(entry instanceof ClonableOrderEntry)) continue;
                                modifiableRootModel.addOrderEntry(((ClonableOrderEntry)entry).cloneEntry((RootModelImpl)modifiableRootModel, (ProjectRootManagerImpl)ProjectRootManager.getInstance((Project)ModuleStructureConfigurable.this.myProject), VirtualFilePointerManager.getInstance()));
                            }
                            VirtualFile content = LocalFileSystem.getInstance().findFileByPath(component.getPath());
                            if (content == null) {
                                content = LocalFileSystem.getInstance().refreshAndFindFileByPath(component.getPath());
                            }
                            modifiableRootModel.addContentEntry(content);
                        }

                        public ModuleType getModuleType() {
                            return ModuleType.get((Module)rootModel.getModule());
                        }
                    };
                    builder.setName(component.getNameValue());
                    builder.setModuleFilePath(path + "/" + builder.getName() + ".iml");
                    Module module2 = ModuleStructureConfigurable.this.myContext.myModulesConfigurator.addModule(builder);
                    if (module2 != null) {
                        ModuleStructureConfigurable.this.addModuleNode(module2);
                    }
                }
                catch (Exception e1) {
                    LOG.error((Throwable)e1);
                }
            } else {
                ModuleStructureConfigurable.this.copyByExtension(namedConfigurable);
            }
        }

        public void update(AnActionEvent e) {
            TreePath[] selectionPaths = ModuleStructureConfigurable.this.myTree.getSelectionPaths();
            if (selectionPaths == null || selectionPaths.length != 1) {
                e.getPresentation().setEnabled(false);
            } else {
                NamedConfigurable selectedConfigurable = ModuleStructureConfigurable.this.getSelectedConfigurable();
                e.getPresentation().setEnabled(selectedConfigurable instanceof ModuleConfigurable || ModuleStructureConfigurable.canBeCopiedByExtension(selectedConfigurable));
            }
        }
    }

    private class HideGroupsAction
    extends ToggleAction
    implements DumbAware {
        public HideGroupsAction() {
            super("", "", AllIcons.ObjectBrowser.CompactEmptyPackages);
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            String text = ProjectBundle.message((String)(ModuleStructureConfigurable.this.myHideModuleGroups ? "project.roots.plain.mode.action.text.enabled" : "project.roots.plain.mode.action.text.disabled"), (Object[])new Object[0]);
            presentation.setText(text);
            presentation.setDescription(text);
            if (ModuleStructureConfigurable.this.myContext.myModulesConfigurator != null) {
                presentation.setVisible(ModuleStructureConfigurable.this.myContext.myModulesConfigurator.getModuleModel().hasModuleGroups());
            }
        }

        public boolean isSelected(AnActionEvent e) {
            return ModuleStructureConfigurable.this.myHideModuleGroups;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ModuleStructureConfigurable.this.myHideModuleGroups = state;
            ModuleStructureConfigurable.this.regroupModules();
        }
    }

    private class FlattenModulesAction
    extends ToggleAction
    implements DumbAware {
        public FlattenModulesAction() {
            super(ProjectBundle.message((String)"project.roots.flatten.modules.action.text", (Object[])new Object[0]), ProjectBundle.message((String)"project.roots.flatten.modules.action.description", (Object[])new Object[0]), AllIcons.ObjectBrowser.FlattenModules);
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabledAndVisible(ModuleGrouperKt.isQualifiedModuleNamesEnabled() && !ModuleStructureConfigurable.this.myContext.getModulesConfigurator().getModuleModel().hasModuleGroups());
        }

        public boolean isSelected(AnActionEvent e) {
            return ModuleStructureConfigurable.this.myFlattenModules;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ModuleStructureConfigurable.this.myFlattenModules = state;
            ModuleStructureConfigurable.this.regroupModules();
        }
    }

    private class MyDataProviderWrapper
    extends JPanel
    implements DataProvider {
        public MyDataProviderWrapper(JComponent component) {
            super(new BorderLayout());
            this.add((Component)component, "Center");
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            TreePath[] paths;
            if (LangDataKeys.MODULE_CONTEXT_ARRAY.is(dataId) && (paths = ModuleStructureConfigurable.this.myTree.getSelectionPaths()) != null) {
                ArrayList<Module> modules = new ArrayList<Module>();
                for (TreePath path : paths) {
                    MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)path.getLastPathComponent();
                    NamedConfigurable configurable = node.getConfigurable();
                    LOG.assertTrue(configurable != null, (Object)"already disposed");
                    Object o = configurable.getEditableObject();
                    if (!(o instanceof Module)) continue;
                    modules.add((Module)o);
                }
                return !modules.isEmpty() ? modules.toArray(new Module[modules.size()]) : null;
            }
            if (LangDataKeys.MODULE_CONTEXT.is(dataId)) {
                return ModuleStructureConfigurable.this.getSelectedModule();
            }
            if (LangDataKeys.MODIFIABLE_MODULE_MODEL.is(dataId)) {
                return ModuleStructureConfigurable.this.myContext.myModulesConfigurator.getModuleModel();
            }
            return null;
        }
    }

    private class ModuleRemoveHandler
    extends RemoveConfigurableHandler<Module> {
        public ModuleRemoveHandler() {
            super(ModuleConfigurable.class);
        }

        @Override
        public boolean remove(@NotNull Collection<Module> modules) {
            ModulesConfigurator modulesConfigurator = ModuleStructureConfigurable.this.myContext.myModulesConfigurator;
            List<Module> deleted = modulesConfigurator.deleteModules(modules);
            if (deleted.isEmpty()) {
                return false;
            }
            for (Module module2 : deleted) {
                List<Facet> removed = modulesConfigurator.getFacetsConfigurator().removeAllFacets(module2);
                FacetStructureConfigurable.getInstance(ModuleStructureConfigurable.this.myProject).removeFacetNodes(removed);
                ModuleStructureConfigurable.this.myContext.getDaemonAnalyzer().removeElement(new ModuleProjectStructureElement(ModuleStructureConfigurable.this.myContext, module2));
                for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
                    extension.moduleRemoved(module2);
                }
            }
            return true;
        }
    }

    private class FacetInModuleRemoveHandler
    extends RemoveConfigurableHandler<Facet> {
        public FacetInModuleRemoveHandler() {
            super(FacetConfigurable.class);
        }

        @Override
        public boolean remove(@NotNull Collection<Facet> facets) {
            for (Facet facet : facets) {
                List<Facet> removed = ModuleStructureConfigurable.this.myContext.myModulesConfigurator.getFacetsConfigurator().removeFacet(facet);
                FacetStructureConfigurable.getInstance(ModuleStructureConfigurable.this.myProject).removeFacetNodes(removed);
            }
            return true;
        }
    }

    private static class ModuleGroupNodeImpl
    extends MasterDetailsComponent.MyNode
    implements ModuleGroupNode {
        private final ModuleGroup myModuleGroup;

        public ModuleGroupNodeImpl(@NotNull NamedConfigurable configurable, @NotNull ModuleGroup moduleGroup) {
            super(configurable, true);
            this.myModuleGroup = moduleGroup;
        }

        @Override
        public ModuleGroup getModuleGroup() {
            return this.myModuleGroup;
        }
    }

    private static interface ModuleGroupNode
    extends MutableTreeNode {
        @Nullable
        public ModuleGroup getModuleGroup();
    }

    private class ModuleNode
    extends MasterDetailsComponent.MyNode
    implements ModuleGroupNode {
        private final ModuleGroup myModuleAsGroup;

        public ModuleNode(@Nullable ModuleConfigurable configurable, ModuleGroup moduleAsGroup) {
            super((NamedConfigurable)configurable);
            this.myModuleAsGroup = moduleAsGroup;
        }

        @Override
        public ModuleGroup getModuleGroup() {
            return this.myModuleAsGroup;
        }

        @NotNull
        public String getDisplayName() {
            return ModuleStructureConfigurable.this.myFlattenModules ? this.getModule().getName() : this.getModuleGrouper().getShortenedName(this.getModule());
        }

        private ModuleGrouper getModuleGrouper() {
            return this.getConfigurable().getModuleGrouper();
        }

        public ModuleConfigurable getConfigurable() {
            return (ModuleConfigurable)super.getConfigurable();
        }

        private Module getModule() {
            return this.getConfigurable().getModule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reloadNode(DefaultTreeModel treeModel) {
            boolean autoScrollWasEnabled = ModuleStructureConfigurable.this.myAutoScrollEnabled;
            try {
                ModuleStructureConfigurable.this.myAutoScrollEnabled = false;
                ModuleGroupingTreeHelper helper = ModuleStructureConfigurable.this.createGroupingHelper();
                MasterDetailsComponent.MyNode newNode = helper.moveModuleNodeToProperGroup(this, this.getModule(), ModuleStructureConfigurable.this.myRoot, treeModel, (JTree)ModuleStructureConfigurable.this.myTree);
                treeModel.reload((TreeNode)newNode);
            }
            finally {
                ModuleStructureConfigurable.this.myAutoScrollEnabled = autoScrollWasEnabled;
            }
        }
    }
}

