/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.GlobalLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureLibraryTableModifiableModelProvider;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProjectLibrariesConfigurable
extends BaseLibrariesConfigurable {
    public ProjectLibrariesConfigurable(Project project2) {
        super(project2, "project");
    }

    protected String getComponentStateKey() {
        return "ProjectLibrariesConfigurable.UI";
    }

    @Nls
    public String getDisplayName() {
        return "Libraries";
    }

    @NotNull
    @NonNls
    public String getId() {
        return "project.libraries";
    }

    @Override
    public StructureLibraryTableModifiableModelProvider getModelProvider() {
        return this.myContext.getProjectLibrariesProvider();
    }

    @Override
    public BaseLibrariesConfigurable getOppositeGroup() {
        return GlobalLibrariesConfigurable.getInstance(this.myProject);
    }

    public static ProjectLibrariesConfigurable getInstance(Project project2) {
        return (ProjectLibrariesConfigurable)((Object)ServiceManager.getService((Project)project2, ProjectLibrariesConfigurable.class));
    }

    @Override
    public LibraryTablePresentation getLibraryTablePresentation() {
        return LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject).getPresentation();
    }

    @Override
    protected String getAddText() {
        return ProjectBundle.message((String)"add.new.project.library.text", (Object[])new Object[0]);
    }
}

