/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.ValidatableSdkAdditionalData;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSdksModel
implements SdkModel {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel");
    private final HashMap<Sdk, Sdk> myProjectSdks = new HashMap();
    private final EventDispatcher<SdkModel.Listener> mySdkEventsDispatcher = EventDispatcher.create(SdkModel.Listener.class);
    private boolean myModified = false;
    private Sdk myProjectSdk;
    private boolean myInitialized = false;

    public SdkModel.Listener getMulticaster() {
        return (SdkModel.Listener)this.mySdkEventsDispatcher.getMulticaster();
    }

    public Sdk[] getSdks() {
        return this.myProjectSdks.values().toArray(new Sdk[this.myProjectSdks.size()]);
    }

    @Nullable
    public Sdk findSdk(String sdkName) {
        for (Sdk projectJdk : this.myProjectSdks.values()) {
            if (!Comparing.strEqual((String)projectJdk.getName(), (String)sdkName)) continue;
            return projectJdk;
        }
        return null;
    }

    public void addListener(SdkModel.Listener listener2) {
        this.mySdkEventsDispatcher.addListener((EventListener)listener2);
    }

    public void removeListener(SdkModel.Listener listener2) {
        this.mySdkEventsDispatcher.removeListener((EventListener)listener2);
    }

    public void reset(@Nullable Project project2) {
        Sdk[] projectSdks;
        this.myProjectSdks.clear();
        for (Sdk sdk : projectSdks = ProjectJdkTable.getInstance().getAllJdks()) {
            try {
                this.myProjectSdks.put(sdk, (Sdk)sdk.clone());
            }
            catch (CloneNotSupportedException e) {
                LOG.error((Throwable)e);
            }
        }
        if (project2 != null) {
            this.myProjectSdk = this.findSdk(ProjectRootManager.getInstance((Project)project2).getProjectSdkName());
        }
        this.myModified = false;
        this.myInitialized = true;
    }

    public void disposeUIResources() {
        this.myProjectSdks.clear();
        this.myInitialized = false;
    }

    public HashMap<Sdk, Sdk> getProjectSdks() {
        return this.myProjectSdks;
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void apply() throws ConfigurationException {
        this.apply(null);
    }

    public void apply(@Nullable MasterDetailsComponent configurable) throws ConfigurationException {
        this.apply(configurable, false);
    }

    public void apply(@Nullable MasterDetailsComponent configurable, boolean addedOnly) throws ConfigurationException {
        String[] errorString = new String[1];
        if (!this.canApply(errorString, configurable, addedOnly)) {
            throw new ConfigurationException(errorString[0]);
        }
        this.doApply();
        this.myModified = false;
    }

    private void doApply() {
        ApplicationManager.getApplication().runWriteAction(() -> {
            ArrayList<Sdk> itemsInTable = new ArrayList<Sdk>();
            ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
            Sdk[] allFromTable = jdkTable.getAllJdks();
            for (Sdk tableItem : allFromTable) {
                if (this.myProjectSdks.containsKey(tableItem)) {
                    itemsInTable.add(tableItem);
                    continue;
                }
                jdkTable.removeJdk(tableItem);
            }
            for (Sdk originalJdk : itemsInTable) {
                Sdk modifiedJdk = this.myProjectSdks.get(originalJdk);
                LOG.assertTrue(modifiedJdk != null);
                LOG.assertTrue(originalJdk != modifiedJdk);
                jdkTable.updateJdk(originalJdk, modifiedJdk);
            }
            Object[] allJdks = jdkTable.getAllJdks();
            for (Sdk projectJdk : this.myProjectSdks.keySet()) {
                LOG.assertTrue(projectJdk != null);
                if (ArrayUtilRt.find((Object[])allJdks, (Object)projectJdk) != -1) continue;
                jdkTable.addJdk(projectJdk);
                jdkTable.updateJdk(projectJdk, this.myProjectSdks.get(projectJdk));
            }
        });
    }

    private boolean canApply(String[] errorString, @Nullable MasterDetailsComponent rootConfigurable, boolean addedOnly) throws ConfigurationException {
        LinkedHashMap<Sdk, Sdk> sdks = new LinkedHashMap<Sdk, Sdk>(this.myProjectSdks);
        if (addedOnly) {
            Sdk[] allJdks;
            for (Sdk jdk2 : allJdks = ProjectJdkTable.getInstance().getAllJdks()) {
                sdks.remove(jdk2);
            }
        }
        ArrayList<String> allNames = new ArrayList<String>();
        Sdk itemWithError = null;
        for (Sdk currItem : sdks.values()) {
            String currName = currItem.getName();
            if (currName.isEmpty()) {
                itemWithError = currItem;
                errorString[0] = ProjectBundle.message((String)"sdk.list.name.required.error", (Object[])new Object[0]);
                break;
            }
            if (allNames.contains(currName)) {
                itemWithError = currItem;
                errorString[0] = ProjectBundle.message((String)"sdk.list.unique.name.required.error", (Object[])new Object[0]);
                break;
            }
            SdkAdditionalData sdkAdditionalData = currItem.getSdkAdditionalData();
            if (sdkAdditionalData instanceof ValidatableSdkAdditionalData) {
                try {
                    ((ValidatableSdkAdditionalData)sdkAdditionalData).checkValid((SdkModel)this);
                }
                catch (ConfigurationException e) {
                    Object projectJdk;
                    if (!(rootConfigurable == null || (projectJdk = rootConfigurable.getSelectedObject()) instanceof Sdk && Comparing.strEqual((String)((Sdk)projectJdk).getName(), (String)currName))) {
                        rootConfigurable.selectNodeInTree(currName);
                    }
                    throw new ConfigurationException(ProjectBundle.message((String)"sdk.configuration.exception", (Object[])new Object[]{currName}) + " " + e.getMessage());
                }
            }
            allNames.add(currName);
        }
        if (itemWithError == null) {
            return true;
        }
        if (rootConfigurable != null) {
            rootConfigurable.selectNodeInTree(itemWithError.getName());
        }
        return false;
    }

    public void removeSdk(Sdk editableObject) {
        Sdk projectJdk = null;
        for (Sdk jdk2 : this.myProjectSdks.keySet()) {
            if (this.myProjectSdks.get(jdk2) != editableObject) continue;
            projectJdk = jdk2;
            break;
        }
        if (projectJdk != null) {
            this.myProjectSdks.remove(projectJdk);
            ((SdkModel.Listener)this.mySdkEventsDispatcher.getMulticaster()).beforeSdkRemove(projectJdk);
            this.myModified = true;
        }
    }

    public void createAddActions(@NotNull DefaultActionGroup group, @NotNull JComponent parent, @NotNull Consumer<Sdk> updateTree) {
        this.createAddActions(group, parent, updateTree, null);
    }

    public void createAddActions(@NotNull DefaultActionGroup group, @NotNull JComponent parent, @NotNull Consumer<Sdk> updateTree, @Nullable Condition<SdkTypeId> filter) {
        this.createAddActions(group, parent, null, updateTree, filter);
    }

    public void createAddActions(@NotNull DefaultActionGroup group, final @NotNull JComponent parent, final @Nullable Sdk selectedSdk, final @NotNull Consumer<Sdk> updateTree, @Nullable Condition<SdkTypeId> filter) {
        SdkType[] types;
        for (final SdkType type2 : types = SdkType.getAllTypes()) {
            if (filter != null && !filter.value((Object)type2)) continue;
            DumbAwareAction addAction = new DumbAwareAction(type2.getPresentableName(), null, type2.getIconForAddAction()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    ProjectSdksModel.this.doAdd(parent, selectedSdk, type2, (Consumer<Sdk>)updateTree);
                }
            };
            group.add((AnAction)addAction);
        }
    }

    public void doAdd(@NotNull JComponent parent, @NotNull SdkType type2, @NotNull Consumer<Sdk> callback) {
        this.doAdd(parent, null, type2, callback);
    }

    public void doAdd(@NotNull JComponent parent, @Nullable Sdk selectedSdk, @NotNull SdkType type2, @NotNull Consumer<Sdk> callback) {
        this.myModified = true;
        if (type2.supportsCustomCreateUI()) {
            type2.showCustomCreateUI((SdkModel)this, parent, selectedSdk, sdk -> this.setupSdk((Sdk)sdk, callback));
        } else {
            SdkConfigurationUtil.selectSdkHome(type2, (Consumer<String>)((Consumer)home -> this.addSdk(type2, (String)home, callback)));
        }
    }

    public void addSdk(@NotNull SdkType type2, @NotNull String home, @Nullable Consumer<Sdk> callback) {
        String newSdkName = SdkConfigurationUtil.createUniqueSdkName(type2, home, this.myProjectSdks.values());
        ProjectJdkImpl newJdk = new ProjectJdkImpl(newSdkName, (SdkTypeId)type2);
        newJdk.setHomePath(home);
        this.setupSdk(newJdk, callback);
    }

    private void setupSdk(Sdk newJdk, @Nullable Consumer<Sdk> callback) {
        String home = newJdk.getHomePath();
        SdkType sdkType = (SdkType)newJdk.getSdkType();
        if (!sdkType.setupSdkPaths(newJdk, (SdkModel)this)) {
            return;
        }
        if (newJdk.getVersionString() == null) {
            String message2 = ProjectBundle.message((String)"sdk.java.corrupt.error", (Object[])new Object[]{home});
            Messages.showMessageDialog((String)message2, (String)ProjectBundle.message((String)"sdk.java.corrupt.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
        this.doAdd(newJdk, callback);
    }

    public void addSdk(Sdk sdk) {
        this.doAdd(sdk, null);
    }

    public void doAdd(Sdk newSdk, @Nullable Consumer<Sdk> updateTree) {
        this.myModified = true;
        try {
            Sdk editableCopy = (Sdk)newSdk.clone();
            this.myProjectSdks.put(newSdk, editableCopy);
            if (updateTree != null) {
                updateTree.consume((Object)editableCopy);
            }
            ((SdkModel.Listener)this.mySdkEventsDispatcher.getMulticaster()).sdkAdded(editableCopy);
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    public Sdk findSdk(@Nullable Sdk modelJdk) {
        for (Sdk jdk2 : this.myProjectSdks.keySet()) {
            if (!Comparing.equal((Object)this.myProjectSdks.get(jdk2), (Object)modelJdk)) continue;
            return jdk2;
        }
        return null;
    }

    @Nullable
    public Sdk getProjectSdk() {
        if (!this.myProjectSdks.containsValue(this.myProjectSdk)) {
            return null;
        }
        return this.myProjectSdk;
    }

    public void setProjectSdk(Sdk projectSdk) {
        this.myProjectSdk = projectSdk;
    }

    public boolean isInitialized() {
        return this.myInitialized;
    }
}

