/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsSettings;
import com.intellij.util.containers.SortedList;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProjectStructureProblemsSettingsBase
extends ProjectStructureProblemsSettings
implements PersistentStateComponent<ProjectStructureProblemsSettingsBase> {
    @AbstractCollection(surroundWithTag=false, elementTag="problem", elementValueAttribute="id")
    @Tag(value="ignored-problems")
    public List<String> myIgnoredProblems = new SortedList(String.CASE_INSENSITIVE_ORDER);

    public ProjectStructureProblemsSettingsBase getState() {
        return this;
    }

    public void loadState(ProjectStructureProblemsSettingsBase state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    @Override
    public boolean isIgnored(@NotNull ProjectStructureProblemDescription description) {
        return this.myIgnoredProblems.contains(description.getId());
    }

    @Override
    public void setIgnored(@NotNull ProjectStructureProblemDescription description, boolean ignored) {
        String id = description.getId();
        if (ignored) {
            this.myIgnoredProblems.add(id);
        } else {
            this.myIgnoredProblems.remove(id);
        }
    }
}

