/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowWrapperBuilder {
    @NotNull
    private final WindowWrapper.Mode myMode;
    @NotNull
    private final JComponent myComponent;
    @Nullable
    private Project myProject;
    @Nullable
    private Component myParent;
    @Nullable
    private String myTitle;
    @Nullable
    private Computable<JComponent> myPreferredFocusedComponent;
    @Nullable
    private String myDimensionServiceKey;
    @Nullable
    private Runnable myOnShowCallback;

    public WindowWrapperBuilder(@NotNull WindowWrapper.Mode mode, @NotNull JComponent component) {
        this.myMode = mode;
        this.myComponent = component;
    }

    @NotNull
    public WindowWrapperBuilder setProject(@Nullable Project project2) {
        this.myProject = project2;
        return this;
    }

    @NotNull
    public WindowWrapperBuilder setParent(@Nullable Component parent) {
        this.myParent = parent;
        return this;
    }

    @NotNull
    public WindowWrapperBuilder setTitle(@Nullable String title) {
        this.myTitle = title;
        return this;
    }

    @NotNull
    public WindowWrapperBuilder setPreferredFocusedComponent(@Nullable JComponent preferredFocusedComponent) {
        this.myPreferredFocusedComponent = new Computable.PredefinedValueComputable((Object)preferredFocusedComponent);
        return this;
    }

    @NotNull
    public WindowWrapperBuilder setPreferredFocusedComponent(@Nullable Computable<JComponent> computable) {
        this.myPreferredFocusedComponent = computable;
        return this;
    }

    @NotNull
    public WindowWrapperBuilder setDimensionServiceKey(@Nullable String dimensionServiceKey) {
        this.myDimensionServiceKey = dimensionServiceKey;
        return this;
    }

    @NotNull
    public WindowWrapperBuilder setOnShowCallback(@NotNull Runnable callback) {
        this.myOnShowCallback = callback;
        return this;
    }

    @NotNull
    public WindowWrapper build() {
        switch (this.myMode) {
            case FRAME: {
                return new FrameWindowWrapper(this);
            }
            case MODAL: 
            case NON_MODAL: {
                return new DialogWindowWrapper(this);
            }
        }
        throw new IllegalArgumentException(this.myMode.toString());
    }

    private static void installOnShowCallback(@Nullable Window window, final @Nullable Runnable onShowCallback) {
        if (window == null || onShowCallback == null) {
            return;
        }
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                onShowCallback.run();
                e.getWindow().removeWindowListener(this);
            }
        });
    }

    private static class FrameWindowWrapper
    implements WindowWrapper {
        @Nullable
        private final Project myProject;
        @NotNull
        private final JComponent myComponent;
        @NotNull
        private final WindowWrapper.Mode myMode;
        @Nullable
        private final Runnable myOnShowCallback;
        @NotNull
        private final MyFrameWrapper myFrame;

        public FrameWindowWrapper(@NotNull WindowWrapperBuilder builder) {
            assert (builder.myMode == WindowWrapper.Mode.FRAME);
            this.myProject = builder.myProject;
            this.myComponent = builder.myComponent;
            this.myMode = builder.myMode;
            this.myFrame = new MyFrameWrapper(builder.myProject, builder.myDimensionServiceKey);
            this.myFrame.setParameters((Computable<JComponent>)builder.myPreferredFocusedComponent);
            this.myOnShowCallback = builder.myOnShowCallback;
            this.myFrame.setComponent(builder.myComponent);
            this.myFrame.setTitle(builder.myTitle);
            this.myFrame.closeOnEsc();
            Disposer.register((Disposable)this.myFrame, (Disposable)this);
        }

        public void show() {
            this.myFrame.show();
            if (this.myOnShowCallback != null) {
                this.myOnShowCallback.run();
            }
        }

        @Nullable
        public Project getProject() {
            return this.myProject;
        }

        @NotNull
        public JComponent getComponent() {
            return this.myComponent;
        }

        @NotNull
        public WindowWrapper.Mode getMode() {
            return this.myMode;
        }

        @NotNull
        public Window getWindow() {
            return this.myFrame.getFrame();
        }

        public void setTitle(@Nullable String title) {
            title = StringUtil.notNullize((String)title);
            this.myFrame.setTitle(title);
            Window window = this.getWindow();
            if (window instanceof JFrame) {
                ((JFrame)window).setTitle(title);
            }
            if (window instanceof JDialog) {
                ((JDialog)window).setTitle(title);
            }
        }

        public void setImage(@Nullable Image image) {
            this.myFrame.setImage(image);
        }

        public void close() {
            this.myFrame.close();
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myFrame);
        }

        private static class MyFrameWrapper
        extends FrameWrapper {
            private Computable<JComponent> myPreferredFocusedComponent;

            public MyFrameWrapper(Project project2, @Nullable @NonNls String dimensionServiceKey) {
                super(project2, dimensionServiceKey);
            }

            public void setParameters(@Nullable Computable<JComponent> preferredFocusedComponent) {
                this.myPreferredFocusedComponent = preferredFocusedComponent;
            }

            @Override
            public void dispose() {
                this.myPreferredFocusedComponent = null;
                super.dispose();
            }

            @Override
            public JComponent getPreferredFocusedComponent() {
                if (this.myPreferredFocusedComponent != null) {
                    return (JComponent)this.myPreferredFocusedComponent.compute();
                }
                return super.getPreferredFocusedComponent();
            }
        }
    }

    private static class DialogWindowWrapper
    implements WindowWrapper {
        @Nullable
        private final Project myProject;
        @NotNull
        private final JComponent myComponent;
        @NotNull
        private final WindowWrapper.Mode myMode;
        @NotNull
        private final MyDialogWrapper myDialog;

        public DialogWindowWrapper(@NotNull WindowWrapperBuilder builder) {
            this.myProject = builder.myProject;
            this.myComponent = builder.myComponent;
            this.myMode = builder.myMode;
            this.myDialog = builder.myParent != null ? new MyDialogWrapper(builder.myParent, builder.myComponent) : new MyDialogWrapper(builder.myProject, builder.myComponent);
            this.myDialog.setParameters(builder.myDimensionServiceKey, (Computable<JComponent>)builder.myPreferredFocusedComponent);
            WindowWrapperBuilder.installOnShowCallback(this.myDialog.getWindow(), builder.myOnShowCallback);
            this.setTitle(builder.myTitle);
            switch (builder.myMode) {
                case MODAL: {
                    this.myDialog.setModal(true);
                    break;
                }
                case NON_MODAL: {
                    this.myDialog.setModal(false);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.myDialog.init();
            Disposer.register((Disposable)this.myDialog.getDisposable(), (Disposable)this);
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myDialog.getDisposable());
        }

        public void show() {
            this.myDialog.show();
        }

        @Nullable
        public Project getProject() {
            return this.myProject;
        }

        @NotNull
        public JComponent getComponent() {
            return this.myComponent;
        }

        @NotNull
        public WindowWrapper.Mode getMode() {
            return this.myMode;
        }

        @NotNull
        public Window getWindow() {
            return this.myDialog.getWindow();
        }

        public void setTitle(@Nullable String title) {
            this.myDialog.setTitle(StringUtil.notNullize((String)title));
        }

        public void setImage(@Nullable Image image) {
        }

        public void close() {
            this.myDialog.close(1);
        }

        private static class MyDialogWrapper
        extends DialogWrapper {
            @NotNull
            private JComponent myComponent;
            @Nullable
            private String myDimensionServiceKey;
            @Nullable
            private Computable<JComponent> myPreferredFocusedComponent;

            public MyDialogWrapper(@Nullable Project project2, @NotNull JComponent component) {
                super(project2, true);
                this.myComponent = component;
            }

            public MyDialogWrapper(@NotNull Component parent, @NotNull JComponent component) {
                super(parent, true);
                this.myComponent = component;
            }

            public void setParameters(@Nullable String dimensionServiceKey, @Nullable Computable<JComponent> preferredFocusedComponent) {
                this.myDimensionServiceKey = dimensionServiceKey;
                this.myPreferredFocusedComponent = preferredFocusedComponent;
            }

            @Nullable
            protected Border createContentPaneBorder() {
                return null;
            }

            protected JComponent createCenterPanel() {
                return this.myComponent;
            }

            @NotNull
            protected Action[] createActions() {
                return new Action[0];
            }

            @Nullable
            protected JComponent createSouthPanel() {
                return null;
            }

            @Nullable
            protected String getDimensionServiceKey() {
                return this.myDimensionServiceKey;
            }

            @Nullable
            public JComponent getPreferredFocusedComponent() {
                if (this.myPreferredFocusedComponent != null) {
                    return (JComponent)this.myPreferredFocusedComponent.compute();
                }
                return super.getPreferredFocusedComponent();
            }
        }
    }
}

