/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.ex;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.UIBundle;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessagesEx
extends Messages {
    public static MessageInfo fileIsReadOnly(Project project2, String filePath) {
        return MessagesEx.error(project2, UIBundle.message((String)"file.is.read.only.message.text", (Object[])new Object[]{filePath}));
    }

    public static MessageInfo filesAreReadOnly(Project project2, String[] files) {
        if (files.length == 1) {
            return MessagesEx.fileIsReadOnly(project2, files[0]);
        }
        return MessagesEx.error(project2, UIBundle.message((String)"files.are.read.only.message.text", (Object[])new Object[]{MessagesEx.filePaths(files)}));
    }

    private static String filePaths(String[] files) {
        return StringUtil.join((String[])files, (String)",\n");
    }

    public static MessageInfo fileIsReadOnly(Project project2, VirtualFile file2) {
        return MessagesEx.fileIsReadOnly(project2, file2.getPresentableUrl());
    }

    public static MessageInfo error(Project project2, String message2) {
        return MessagesEx.error(project2, message2, UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]));
    }

    @NotNull
    public static MessageInfo error(Project project2, String message2, String title) {
        return new MessageInfo(project2, message2, title);
    }

    public static void showErrorDialog(@Nullable Component parent, String message2, @NotNull String title) {
        if (parent != null) {
            Messages.showErrorDialog((Component)parent, (String)message2, (String)title);
        } else {
            MessagesEx.showErrorDialog((String)message2, (String)title);
        }
    }

    public static void showWarningDialog(@Nullable Component parent, String message2, @NotNull String title) {
        if (parent != null) {
            Messages.showWarningDialog((Component)parent, (String)message2, (String)title);
        } else {
            MessagesEx.showWarningDialog((String)message2, (String)title);
        }
    }

    public static void showInfoMessage(@Nullable Component parent, String message2, @NotNull String title) {
        if (parent != null) {
            Messages.showInfoMessage((Component)parent, (String)message2, (String)title);
        } else {
            MessagesEx.showInfoMessage((String)message2, (String)title);
        }
    }

    public static int showOkCancelDialog(@Nullable Component parent, String message2, String title, Icon icon) {
        return parent != null ? Messages.showOkCancelDialog((Component)parent, (String)message2, (String)title, (Icon)icon) : MessagesEx.showOkCancelDialog((String)message2, (String)title, (Icon)icon);
    }

    public static abstract class BaseInputInfo<ThisClass extends BaseInputInfo>
    extends BaseDialogInfo<ThisClass> {
        public BaseInputInfo(Project project2) {
            super(project2);
        }

        public String forceUserInput() {
            this.setOptions(new String[]{CommonBundle.getOkButtonText()}, 0);
            return this.askUser().getInput();
        }

        public abstract UserInput askUser();
    }

    public static class InputInfo
    extends BaseInputInfo<InputInfo> {
        private String myDefaultValue;

        public InputInfo(Project project2) {
            super(project2);
            this.setOptions(new String[]{CommonBundle.getOkButtonText(), CommonBundle.getCancelButtonText()}, 0);
        }

        @Override
        public UserInput askUser() {
            Messages.InputDialog dialog2 = new Messages.InputDialog(this.getProject(), this.getMessage(), this.getTitle(), this.getIcon(), this.myDefaultValue, null, this.getOptions(), this.getDefaultOption());
            dialog2.show();
            return new UserInput(dialog2.getTextField().getText(), dialog2.getExitCode());
        }

        @Override
        @NotNull
        public InputInfo getThis() {
            return this;
        }

        public void setDefaultValue(String defaultValue) {
            this.myDefaultValue = defaultValue;
        }
    }

    public static class UserInput {
        private final int mySelectedOption;
        private final String myInput;

        public UserInput(String choice, int option) {
            this.mySelectedOption = option;
            this.myInput = choice;
        }

        public String getInput() {
            return this.myInput;
        }

        public int getSelectedOption() {
            return this.mySelectedOption;
        }
    }

    public static class ChoiceInfo
    extends BaseInputInfo<ChoiceInfo> {
        private String[] myChoises = ArrayUtil.EMPTY_STRING_ARRAY;
        private String myDefaultChoice = null;

        public ChoiceInfo(Project project2) {
            super(project2);
            this.setIcon(Messages.getQuestionIcon());
            this.setOptions(new String[]{CommonBundle.getOkButtonText()}, 0);
        }

        @Override
        @NotNull
        public ChoiceInfo getThis() {
            return this;
        }

        public ChoiceInfo setChoices(String[] choices, String defaultChoice) {
            this.myChoises = choices;
            this.myDefaultChoice = defaultChoice;
            return this.getThis();
        }

        @Override
        public UserInput askUser() {
            Messages.ChooseDialog dialog2 = new Messages.ChooseDialog(this.getProject(), this.getMessage(), this.getTitle(), this.getIcon(), this.myChoises, this.myDefaultChoice, this.getOptions(), this.getDefaultOption());
            dialog2.setValidator(null);
            JComboBox comboBox = dialog2.getComboBox();
            comboBox.setEditable(false);
            comboBox.setSelectedItem(this.myDefaultChoice);
            dialog2.show();
            Object selectedItem = comboBox.getSelectedItem();
            return new UserInput(selectedItem != null ? selectedItem.toString() : null, dialog2.getExitCode());
        }
    }

    public static class MessageInfo
    extends BaseDialogInfo<MessageInfo> {
        public MessageInfo(Project project2, String message2, String title) {
            super(project2, message2, title, Messages.getErrorIcon());
        }

        public int showNow() {
            return Messages.showDialog((Project)this.getProject(), (String)this.getMessage(), (String)this.getTitle(), (String[])this.getOptions(), (int)this.getDefaultOption(), (Icon)this.getIcon());
        }

        public void showLater() {
            ApplicationManager.getApplication().invokeLater(() -> this.showNow(), ApplicationManager.getApplication().getDisposed());
        }

        @Messages.YesNoResult
        public int askYesNo() {
            this.setIcon(Messages.getQuestionIcon());
            return Messages.showYesNoDialog((Project)this.getProject(), (String)this.getMessage(), (String)this.getTitle(), (Icon)this.getIcon());
        }

        public int ask(String[] options, int defaultOptionIndex) {
            this.setOptions(options, defaultOptionIndex);
            return this.showNow();
        }

        @Override
        @NotNull
        protected MessageInfo getThis() {
            return this;
        }
    }

    public static abstract class BaseDialogInfo<ThisClass extends BaseDialogInfo> {
        private final Project myProject;
        private String myMessage;
        private String myTitle;
        private Icon myIcon;
        private String[] myOptions = new String[]{CommonBundle.getOkButtonText()};
        private int myDefaultOption = 0;

        protected BaseDialogInfo(Project project2) {
            this.myProject = project2;
        }

        public BaseDialogInfo(Project project2, @NotNull String message2, String title, Icon icon) {
            this(project2);
            this.myMessage = message2;
            this.myTitle = title;
            this.myIcon = icon;
        }

        @NotNull
        public ThisClass setTitle(String title) {
            this.myTitle = title;
            return this.getThis();
        }

        public String getMessage() {
            return this.myMessage;
        }

        @NotNull
        public ThisClass appendMessage(@NotNull String message2) {
            this.myMessage = this.myMessage + message2;
            return this.getThis();
        }

        public void setOptions(String[] options, int defaultOption) {
            this.myOptions = options;
            this.myDefaultOption = defaultOption;
        }

        @NotNull
        protected abstract ThisClass getThis();

        @NotNull
        public ThisClass setIcon(Icon icon) {
            this.myIcon = icon;
            return this.getThis();
        }

        public void setMessage(@NotNull String message2) {
            this.myMessage = message2;
        }

        public Project getProject() {
            return this.myProject;
        }

        public String getTitle() {
            return this.myTitle;
        }

        public String[] getOptions() {
            return this.myOptions;
        }

        public int getDefaultOption() {
            return this.myDefaultOption;
        }

        public Icon getIcon() {
            return this.myIcon;
        }
    }
}

