/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

public enum ChannelStatus {
    EAP("eap", "Canary Channel"),
    MILESTONE("milestone", "Dev Channel"),
    BETA("beta", "Beta Channel"),
    RELEASE("release", "Stable Channel");

    private final String myCode;
    private final String myDisplayName;

    private ChannelStatus(String code2, String displayName) {
        this.myCode = code2;
        this.myDisplayName = displayName;
    }

    public static ChannelStatus fromCode(String code2) {
        for (ChannelStatus type2 : ChannelStatus.values()) {
            if (!type2.getCode().equalsIgnoreCase(code2)) continue;
            return type2;
        }
        return RELEASE;
    }

    public String getCode() {
        return this.myCode;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public String toString() {
        return this.myDisplayName;
    }
}

