/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateStrategy;
import com.intellij.openapi.util.BuildNumber;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckForUpdateResult {
    private final UpdateStrategy.State myState;
    private final BuildInfo myNewBuild;
    private final UpdateChannel myUpdatedChannel;
    private final Exception myError;

    public CheckForUpdateResult(@Nullable BuildInfo newBuild, @Nullable UpdateChannel updatedChannel) {
        this.myState = UpdateStrategy.State.LOADED;
        this.myNewBuild = newBuild;
        this.myUpdatedChannel = updatedChannel;
        this.myError = null;
    }

    public CheckForUpdateResult(@NotNull UpdateStrategy.State state, @Nullable Exception e) {
        this.myState = state;
        this.myNewBuild = null;
        this.myUpdatedChannel = null;
        this.myError = e;
    }

    @NotNull
    public UpdateStrategy.State getState() {
        return this.myState;
    }

    @Nullable
    public BuildInfo getNewBuild() {
        return this.myNewBuild;
    }

    @Nullable
    public PatchInfo findPatchForBuild(@NotNull BuildNumber build) {
        List patches = this.myNewBuild != null ? this.myNewBuild.getPatches() : Collections.emptyList();
        return patches.stream().filter(p -> p.isAvailable() && p.getFromBuild().compareTo(build) == 0).findFirst().orElse(null);
    }

    @Nullable
    public UpdateChannel getUpdatedChannel() {
        return this.myUpdatedChannel;
    }

    @Nullable
    public Exception getError() {
        return this.myError;
    }
}

