/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.ApplicationComponentAdapter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateInstaller;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.UpdateSettingsConfigurable;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Alarm;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class UpdateCheckerComponent
implements ApplicationComponentAdapter,
Disposable {
    private static final Logger LOG = Logger.getInstance(UpdateCheckerComponent.class);
    private static final long CHECK_INTERVAL = 28800000L;
    private final Alarm myCheckForUpdatesAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private final Runnable myCheckRunnable = () -> {
        UpdateChecker.updateAndShowResult();
        this.queueNextCheck(28800000L);
    };
    private final UpdateSettings mySettings;

    public UpdateCheckerComponent(@NotNull Application app, @NotNull UpdateSettings settings) {
        Disposer.register((Disposable)this, (Disposable)this.myCheckForUpdatesAlarm);
        this.mySettings = settings;
        this.updateDefaultChannel();
        this.checkSecureConnection(app);
        this.scheduleOnStartCheck(app);
        UpdateCheckerComponent.cleanupPatch();
    }

    private void updateDefaultChannel() {
        ChannelStatus current = this.mySettings.getSelectedChannelStatus();
        LOG.info("channel: " + current.getCode());
        boolean eap = ApplicationInfoEx.getInstanceEx().isEAP();
        if (eap && current != ChannelStatus.EAP && UpdateStrategyCustomization.getInstance().forceEapUpdateChannelForEapBuilds()) {
            this.mySettings.setSelectedChannelStatus(ChannelStatus.EAP);
            LOG.info("channel forced to 'eap'");
            if (!ConfigImportHelper.isFirstSession()) {
                String title = IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]);
                String message2 = IdeBundle.message((String)"update.channel.enforced", (Object[])new Object[]{ChannelStatus.EAP});
                UpdateChecker.NOTIFICATIONS.createNotification(title, message2, NotificationType.INFORMATION, null).notify(null);
            }
        }
        if (!eap && current == ChannelStatus.EAP && ConfigImportHelper.isConfigImported()) {
            this.mySettings.setSelectedChannelStatus(ChannelStatus.RELEASE);
            LOG.info("channel set to 'release'");
        }
    }

    private void checkSecureConnection(final Application app) {
        if (this.mySettings.isSecureConnection() && !this.mySettings.canUseSecureConnection()) {
            this.mySettings.setSecureConnection(false);
            String title = IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]);
            String message2 = IdeBundle.message((String)"update.sni.disabled.message", (Object[])new Object[0]);
            UpdateChecker.NOTIFICATIONS.createNotification(title, message2, NotificationType.WARNING, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    notification.expire();
                    app.invokeLater(() -> ShowSettingsUtil.getInstance().showSettingsDialog(null, UpdateSettingsConfigurable.class), ModalityState.NON_MODAL);
                }
            }).notify(null);
        }
    }

    private void scheduleOnStartCheck(Application app) {
        if (!this.mySettings.isCheckNeeded()) {
            return;
        }
        app.getMessageBus().connect((Disposable)app).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            @Override
            public void appFrameCreated(String[] commandLineArgs, @NotNull Ref<Boolean> willOpenProject) {
                UpdateCheckerComponent.this.myCheckRunnable.run();
            }
        });
    }

    private static void cleanupPatch() {
        new Task.Backgroundable(null, IdeBundle.message((String)"update.cleaning.patch.progress", (Object[])new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                UpdateInstaller.cleanupPatch();
            }
        }.queue();
    }

    private void queueNextCheck(long interval) {
        this.myCheckForUpdatesAlarm.addRequest(this.myCheckRunnable, interval);
    }

    public void initComponent() {
        PluginsAdvertiser.ensureDeleted();
    }

    public void dispose() {
    }

    public void queueNextCheck() {
        this.queueNextCheck(28800000L);
    }

    public void cancelChecks() {
        this.myCheckForUpdatesAlarm.cancelAllRequests();
    }
}

