/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CommitCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        PsiFile file2 = parameters2.getOriginalFile();
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document == null) {
            return;
        }
        CommitMessage commitMessage = (CommitMessage)document.getUserData(CommitMessage.DATA_KEY);
        if (commitMessage == null) {
            return;
        }
        result2.stopHere();
        if (parameters2.getInvocationCount() <= 0) {
            return;
        }
        List<ChangeList> lists = commitMessage.getChangeLists();
        if (lists.isEmpty()) {
            return;
        }
        String prefix = TextFieldWithAutoCompletionListProvider.getCompletionPrefix(parameters2);
        CompletionResultSet insensitive = result2.caseInsensitive().withPrefixMatcher((PrefixMatcher)new CamelHumpMatcher(prefix));
        for (ChangeList list : lists) {
            for (Change change : list.getChanges()) {
                ContentRevision revision = change.getAfterRevision() == null ? change.getBeforeRevision() : change.getAfterRevision();
                if (revision == null) continue;
                FilePath filePath = revision.getFile();
                LookupElementBuilder element = LookupElementBuilder.create((String)filePath.getName()).withIcon(filePath.getFileType().getIcon());
                insensitive.addElement((LookupElement)element);
            }
        }
    }
}

