/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.PathUtil;
import com.intellij.util.text.FilePathHashingStrategy;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteFilePath
implements FilePath {
    private static final TObjectHashingStrategy<String> CASE_SENSITIVE_STRATEGY = FilePathHashingStrategy.create((boolean)true);
    @NotNull
    private final String myPath;
    private final boolean myIsDirectory;

    public RemoteFilePath(@NotNull String path, boolean isDirectory) {
        this.myPath = path;
        this.myIsDirectory = isDirectory;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return null;
    }

    @Nullable
    public VirtualFile getVirtualFileParent() {
        return null;
    }

    @NotNull
    public File getIOFile() {
        return new File(this.myPath);
    }

    @NotNull
    public String getName() {
        return PathUtil.getFileName((String)this.myPath);
    }

    @NotNull
    public String getPresentableUrl() {
        return this.getPath();
    }

    @Nullable
    public Document getDocument() {
        return null;
    }

    @NotNull
    public Charset getCharset() {
        return this.getCharset(null);
    }

    @NotNull
    public Charset getCharset(@Nullable Project project2) {
        EncodingManager em = project2 == null ? EncodingManager.getInstance() : EncodingProjectManager.getInstance((Project)project2);
        return em.getDefaultCharset();
    }

    @NotNull
    public FileType getFileType() {
        return FileTypeManager.getInstance().getFileTypeByFileName(this.getName());
    }

    public void refresh() {
    }

    public void hardRefresh() {
    }

    @NotNull
    public String getPath() {
        return this.myPath;
    }

    public boolean isDirectory() {
        return this.myIsDirectory;
    }

    public boolean isUnder(@NotNull FilePath parent, boolean strict) {
        return FileUtil.isAncestor((String)parent.getPath(), (String)this.getPath(), (boolean)strict);
    }

    @Nullable
    public FilePath getParentPath() {
        String parent = PathUtil.getParentPath((String)this.myPath);
        return parent.isEmpty() ? null : new RemoteFilePath(parent, true);
    }

    public boolean isNonLocal() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteFilePath other = (RemoteFilePath)o;
        if (this.myIsDirectory != other.myIsDirectory) {
            return false;
        }
        return CASE_SENSITIVE_STRATEGY.equals((Object)this.myPath, (Object)other.myPath);
    }

    public int hashCode() {
        int result2 = CASE_SENSITIVE_STRATEGY.computeHashCode((Object)this.myPath);
        result2 = 31 * result2 + (this.myIsDirectory ? 1 : 0);
        return result2;
    }
}

