/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsNotifier {
    public static final NotificationGroup NOTIFICATION_GROUP_ID = NotificationGroup.toolWindowGroup((String)"Vcs Messages", (String)ChangesViewContentManager.TOOLWINDOW_ID);
    public static final NotificationGroup IMPORTANT_ERROR_NOTIFICATION = new NotificationGroup("Vcs Important Messages", NotificationDisplayType.STICKY_BALLOON, true);
    public static final NotificationGroup STANDARD_NOTIFICATION = new NotificationGroup("Vcs Notifications", NotificationDisplayType.BALLOON, true);
    public static final NotificationGroup SILENT_NOTIFICATION = new NotificationGroup("Vcs Silent Notifications", NotificationDisplayType.NONE, true);
    @NotNull
    private final Project myProject;

    public static VcsNotifier getInstance(@NotNull Project project2) {
        return (VcsNotifier)ServiceManager.getService((Project)project2, VcsNotifier.class);
    }

    public VcsNotifier(@NotNull Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public static Notification createNotification(@NotNull NotificationGroup notificationGroup, @NotNull String title, @NotNull String message2, @NotNull NotificationType type2, @Nullable NotificationListener listener2) {
        if (StringUtil.isEmptyOrSpaces((String)message2)) {
            message2 = title;
            title = "";
        }
        return notificationGroup.createNotification(title, message2, type2, listener2);
    }

    @NotNull
    public Notification notify(@NotNull NotificationGroup notificationGroup, @NotNull String title, @NotNull String message2, @NotNull NotificationType type2, @Nullable NotificationListener listener2) {
        Notification notification = VcsNotifier.createNotification(notificationGroup, title, message2, type2, listener2);
        return this.notify(notification);
    }

    @NotNull
    public Notification notify(@NotNull Notification notification) {
        notification.notify(this.myProject);
        return notification;
    }

    @NotNull
    public Notification notifyError(@NotNull String title, @NotNull String message2) {
        return this.notifyError(title, message2, null);
    }

    @NotNull
    public Notification notifyError(@NotNull String title, @NotNull String message2, @Nullable NotificationListener listener2) {
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title, message2, NotificationType.ERROR, listener2);
    }

    @NotNull
    public Notification notifyWeakError(@NotNull String message2) {
        return this.notify(NOTIFICATION_GROUP_ID, "", message2, NotificationType.ERROR, null);
    }

    @NotNull
    public Notification notifySuccess(@NotNull String message2) {
        return this.notifySuccess("", message2);
    }

    @NotNull
    public Notification notifySuccess(@NotNull String title, @NotNull String message2) {
        return this.notifySuccess(title, message2, null);
    }

    @NotNull
    public Notification notifySuccess(@NotNull String title, @NotNull String message2, @Nullable NotificationListener listener2) {
        return this.notify(NOTIFICATION_GROUP_ID, title, message2, NotificationType.INFORMATION, listener2);
    }

    @NotNull
    public Notification notifyImportantInfo(@NotNull String title, @NotNull String message2) {
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title, message2, NotificationType.INFORMATION, null);
    }

    @NotNull
    public Notification notifyImportantInfo(@NotNull String title, @NotNull String message2, @Nullable NotificationListener listener2) {
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title, message2, NotificationType.INFORMATION, listener2);
    }

    @NotNull
    public Notification notifyInfo(@NotNull String message2) {
        return this.notifyInfo("", message2);
    }

    @NotNull
    public Notification notifyInfo(@NotNull String title, @NotNull String message2) {
        return this.notifyInfo(title, message2, null);
    }

    @NotNull
    public Notification notifyInfo(@NotNull String title, @NotNull String message2, @Nullable NotificationListener listener2) {
        return this.notify(NOTIFICATION_GROUP_ID, title, message2, NotificationType.INFORMATION, listener2);
    }

    @NotNull
    public Notification notifyMinorWarning(@NotNull String title, @NotNull String message2) {
        return this.notifyMinorWarning(title, message2, null);
    }

    @NotNull
    public Notification notifyMinorWarning(@NotNull String title, @NotNull String message2, @Nullable NotificationListener listener2) {
        return this.notify(STANDARD_NOTIFICATION, title, message2, NotificationType.WARNING, listener2);
    }

    @NotNull
    public Notification notifyWarning(@NotNull String title, @NotNull String message2) {
        return this.notifyWarning(title, message2, null);
    }

    @NotNull
    public Notification notifyWarning(@NotNull String title, @NotNull String message2, @Nullable NotificationListener listener2) {
        return this.notify(NOTIFICATION_GROUP_ID, title, message2, NotificationType.WARNING, listener2);
    }

    @NotNull
    public Notification notifyImportantWarning(@NotNull String title, @NotNull String message2) {
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title, message2, NotificationType.WARNING, null);
    }

    @NotNull
    public Notification notifyImportantWarning(@NotNull String title, @NotNull String message2, @Nullable NotificationListener listener2) {
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title, message2, NotificationType.WARNING, listener2);
    }

    @NotNull
    public Notification notifyMinorInfo(@NotNull String title, @NotNull String message2) {
        return this.notifyMinorInfo(title, message2, null);
    }

    @NotNull
    public Notification notifyMinorInfo(@NotNull String title, @NotNull String message2, @Nullable NotificationListener listener2) {
        return this.notify(STANDARD_NOTIFICATION, title, message2, NotificationType.INFORMATION, listener2);
    }

    public Notification logInfo(@NotNull String title, @NotNull String message2) {
        return this.notify(SILENT_NOTIFICATION, title, message2, NotificationType.INFORMATION, null);
    }
}

