/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ZipperUpdater;
import org.jetbrains.annotations.NotNull;

public class ZipAndQueue {
    private final ZipperUpdater myZipperUpdater;
    private final BackgroundTaskQueue myQueue;
    private Runnable myInZipper;
    private Task.Backgroundable myInvokedOnQueue;

    public ZipAndQueue(@NotNull Project project2, int interval, String title, final Runnable runnable2) {
        int correctedInterval = interval <= 0 ? 300 : interval;
        this.myZipperUpdater = new ZipperUpdater(correctedInterval, (Disposable)project2);
        this.myQueue = new BackgroundTaskQueue(project2, title);
        this.myInZipper = new Runnable(){

            @Override
            public void run() {
                ZipAndQueue.this.myQueue.run(ZipAndQueue.this.myInvokedOnQueue);
            }
        };
        this.myInvokedOnQueue = new Task.Backgroundable(project2, title, false){

            public void run(@NotNull ProgressIndicator indicator) {
                runnable2.run();
            }
        };
        Disposer.register((Disposable)project2, (Disposable)new Disposable(){

            public void dispose() {
                ZipAndQueue.this.myZipperUpdater.stop();
            }
        });
    }

    public void request() {
        this.myZipperUpdater.queue(this.myInZipper);
    }

    public void stop() {
        this.myZipperUpdater.stop();
    }
}

