/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.DiffActionExecutor;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractShowDiffAction
extends AbstractVcsAction {
    @Override
    protected void update(@NotNull VcsContext vcsContext, @NotNull Presentation presentation) {
        AbstractShowDiffAction.updateDiffAction(presentation, vcsContext, this.getKey());
    }

    protected static void updateDiffAction(@NotNull Presentation presentation, @NotNull VcsContext vcsContext, @Nullable VcsBackgroundableActions actionKey) {
        presentation.setEnabled(AbstractShowDiffAction.isEnabled(vcsContext, actionKey));
        presentation.setVisible(AbstractShowDiffAction.isVisible(vcsContext));
    }

    protected abstract VcsBackgroundableActions getKey();

    protected static boolean isVisible(@NotNull VcsContext vcsContext) {
        Project project2 = vcsContext.getProject();
        return project2 != null && AbstractShowDiffAction.hasDiffProviders(project2);
    }

    private static boolean hasDiffProviders(@NotNull Project project2) {
        return Stream.of(ProjectLevelVcsManager.getInstance((Project)project2).getAllActiveVcss()).map(AbstractVcs::getDiffProvider).anyMatch(Objects::nonNull);
    }

    protected static boolean isEnabled(@NotNull VcsContext vcsContext, @Nullable VcsBackgroundableActions actionKey) {
        boolean result2 = false;
        Project project2 = vcsContext.getProject();
        if (project2 != null && AbstractShowDiffAction.isVisible(vcsContext)) {
            VirtualFile file2 = (VirtualFile)UtilKt.getIfSingle(vcsContext.getSelectedFilesStream());
            result2 = file2 != null && AbstractShowDiffAction.isEnabled(project2, file2, actionKey);
        }
        return result2;
    }

    private static boolean isEnabled(@NotNull Project project2, @NotNull VirtualFile file2, @Nullable VcsBackgroundableActions actionKey) {
        boolean result2 = false;
        if (!(file2.isDirectory() || actionKey != null && BackgroundableActionLock.isLocked(project2, new Object[]{actionKey, VcsBackgroundableActions.keyFrom(file2)}))) {
            AbstractVcs vcs = ChangesUtil.getVcsForFile((VirtualFile)file2, (Project)project2);
            result2 = vcs != null && vcs.getDiffProvider() != null && AbstractVcs.fileInVcsByFileStatus((Project)project2, (FilePath)VcsUtil.getFilePath((VirtualFile)file2));
        }
        return result2;
    }

    @Override
    protected void actionPerformed(@NotNull VcsContext vcsContext) {
        Project project2 = (Project)ObjectUtils.assertNotNull((Object)vcsContext.getProject());
        if (!ChangeListManager.getInstance((Project)project2).isFreezedWithNotification("Can not " + vcsContext.getActionName() + " now")) {
            VirtualFile file2 = vcsContext.getSelectedFiles()[0];
            AbstractVcs vcs = (AbstractVcs)ObjectUtils.assertNotNull((Object)ChangesUtil.getVcsForFile((VirtualFile)file2, (Project)project2));
            DiffProvider provider2 = (DiffProvider)ObjectUtils.assertNotNull((Object)vcs.getDiffProvider());
            this.getExecutor(provider2, file2, project2).showDiff();
        }
    }

    protected DiffActionExecutor getExecutor(DiffProvider diffProvider, VirtualFile selectedFile, Project project2) {
        return new DiffActionExecutor.CompareToCurrentExecutor(diffProvider, selectedFile, project2, this.getKey());
    }
}

