/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AnnotateActionGroup;
import com.intellij.openapi.vcs.actions.AnnotateCurrentRevisionAction;
import com.intellij.openapi.vcs.actions.AnnotatePreviousRevisionAction;
import com.intellij.openapi.vcs.actions.AnnotationFieldGutter;
import com.intellij.openapi.vcs.actions.AnnotationGutterLineConvertorProxy;
import com.intellij.openapi.vcs.actions.AnnotationPresentation;
import com.intellij.openapi.vcs.actions.AnnotationsSettings;
import com.intellij.openapi.vcs.actions.AspectAnnotationFieldGutter;
import com.intellij.openapi.vcs.actions.CopyRevisionNumberFromAnnotateAction;
import com.intellij.openapi.vcs.actions.CurrentRevisionAnnotationFieldGutter;
import com.intellij.openapi.vcs.actions.ExtraFieldGutter;
import com.intellij.openapi.vcs.actions.HighlightedAdditionalColumn;
import com.intellij.openapi.vcs.actions.HistoryIdColumn;
import com.intellij.openapi.vcs.actions.MergeSourceAvailableMarkerGutter;
import com.intellij.openapi.vcs.actions.ShowDiffFromAnnotation;
import com.intellij.openapi.vcs.actions.SwitchAnnotationSourceAction;
import com.intellij.openapi.vcs.annotate.AnnotationGutterActionProvider;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.changes.VcsAnnotationLocalChangesListener;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.UpToDateLineNumberProviderImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.LightColors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotateToggleAction
extends ToggleAction
implements DumbAware {
    public static final ExtensionPointName<Provider> EP_NAME = ExtensionPointName.create((String)"com.intellij.openapi.vcs.actions.AnnotateToggleAction.Provider");

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        Provider provider2 = AnnotateToggleAction.getProvider(e);
        e.getPresentation().setEnabled(provider2 != null && !provider2.isSuspended(e));
    }

    public boolean isSelected(AnActionEvent e) {
        Provider provider2 = AnnotateToggleAction.getProvider(e);
        return provider2 != null && provider2.isAnnotated(e);
    }

    public void setSelected(AnActionEvent e, boolean selected) {
        MyEditorNotificationPanel notificationPanel;
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null && (notificationPanel = (MyEditorNotificationPanel)((Object)ObjectUtils.tryCast((Object)editor.getHeaderComponent(), MyEditorNotificationPanel.class))) != null) {
            notificationPanel.showAnnotations();
            return;
        }
        Provider provider2 = AnnotateToggleAction.getProvider(e);
        if (provider2 != null) {
            provider2.perform(e, selected);
        }
    }

    public static void doAnnotate(@NotNull Editor editor, @NotNull Project project2, @Nullable VirtualFile currentFile, @NotNull FileAnnotation fileAnnotation, @NotNull AbstractVcs vcs) {
        UpToDateLineNumberProviderImpl upToDateLineNumberProvider = new UpToDateLineNumberProviderImpl(editor.getDocument(), project2);
        AnnotateToggleAction.doAnnotate(editor, project2, currentFile, fileAnnotation, vcs, upToDateLineNumberProvider);
    }

    public static void doAnnotate(@NotNull Editor editor, @NotNull Project project2, @Nullable VirtualFile currentFile, @NotNull FileAnnotation fileAnnotation, @NotNull AbstractVcs vcs, @NotNull UpToDateLineNumberProvider upToDateLineNumbers) {
        AnnotateToggleAction.doAnnotate(editor, project2, currentFile, fileAnnotation, vcs, upToDateLineNumbers, true);
    }

    private static void doAnnotate(@NotNull Editor editor, @NotNull Project project2, @Nullable VirtualFile currentFile, final @NotNull FileAnnotation fileAnnotation, @NotNull AbstractVcs vcs, @NotNull UpToDateLineNumberProvider upToDateLineNumbers, boolean warnAboutSuspiciousAnnotations) {
        int actualLines;
        int expectedLines;
        if (warnAboutSuspiciousAnnotations && Math.abs((expectedLines = Math.max(upToDateLineNumbers.getLineCount(), 1)) - (actualLines = Math.max(fileAnnotation.getLineCount(), 1))) > 1) {
            editor.setHeaderComponent((JComponent)((Object)new MyEditorNotificationPanel(editor, vcs, () -> AnnotateToggleAction.doAnnotate(editor, project2, currentFile, fileAnnotation, vcs, upToDateLineNumbers, false))));
            return;
        }
        Disposable disposable = new Disposable(){

            public void dispose() {
                fileAnnotation.dispose();
            }
        };
        if (fileAnnotation.getFile() != null && fileAnnotation.getFile().isInLocalFileSystem()) {
            final VcsAnnotationLocalChangesListener changesListener = ProjectLevelVcsManager.getInstance((Project)project2).getAnnotationLocalChangesListener();
            changesListener.registerAnnotation(fileAnnotation.getFile(), fileAnnotation);
            Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

                public void dispose() {
                    changesListener.unregisterAnnotation(fileAnnotation.getFile(), fileAnnotation);
                }
            });
        }
        editor.getGutter().closeAllAnnotations();
        fileAnnotation.setCloser(() -> UIUtil.invokeLaterIfNeeded(() -> {
            if (project2.isDisposed()) {
                return;
            }
            editor.getGutter().closeAllAnnotations();
        }));
        fileAnnotation.setReloader(newFileAnnotation -> {
            if (editor.getGutter().isAnnotationsShown()) {
                assert (Comparing.equal((Object)fileAnnotation.getFile(), (Object)newFileAnnotation.getFile()));
                AnnotateToggleAction.doAnnotate(editor, project2, currentFile, newFileAnnotation, vcs, upToDateLineNumbers, false);
            }
        });
        EditorGutterComponentEx editorGutter = (EditorGutterComponentEx)editor.getGutter();
        ArrayList<AnnotationFieldGutter> gutters = new ArrayList<AnnotationFieldGutter>();
        AnnotationSourceSwitcher switcher = fileAnnotation.getAnnotationSourceSwitcher();
        AnnotationPresentation presentation = new AnnotationPresentation(fileAnnotation, upToDateLineNumbers, switcher, disposable);
        if (currentFile != null && vcs.getCommittedChangesProvider() != null) {
            presentation.addAction((AnAction)new ShowDiffFromAnnotation(fileAnnotation, vcs, currentFile));
        }
        presentation.addAction((AnAction)new CopyRevisionNumberFromAnnotateAction(fileAnnotation));
        presentation.addAction((AnAction)Separator.getInstance());
        Couple<Map<VcsRevisionNumber, Color>> bgColorMap = AnnotateToggleAction.computeBgColors(fileAnnotation, editor);
        Map<VcsRevisionNumber, Integer> historyIds = AnnotateToggleAction.computeLineNumbers(fileAnnotation);
        if (switcher != null) {
            switcher.switchTo(switcher.getDefaultSource());
            LineAnnotationAspect revisionAspect = switcher.getRevisionAspect();
            CurrentRevisionAnnotationFieldGutter currentRevisionGutter = new CurrentRevisionAnnotationFieldGutter(fileAnnotation, revisionAspect, presentation, bgColorMap);
            MergeSourceAvailableMarkerGutter mergeSourceGutter = new MergeSourceAvailableMarkerGutter(fileAnnotation, presentation, bgColorMap);
            SwitchAnnotationSourceAction switchAction = new SwitchAnnotationSourceAction(switcher, editorGutter);
            presentation.addAction(switchAction);
            switchAction.addSourceSwitchListener(currentRevisionGutter);
            switchAction.addSourceSwitchListener(mergeSourceGutter);
            currentRevisionGutter.consume(switcher.getDefaultSource());
            mergeSourceGutter.consume(switcher.getDefaultSource());
            gutters.add(currentRevisionGutter);
            gutters.add(mergeSourceGutter);
        }
        LineAnnotationAspect[] aspects = fileAnnotation.getAspects();
        for (LineAnnotationAspect aspect : aspects) {
            gutters.add(new AspectAnnotationFieldGutter(fileAnnotation, aspect, presentation, bgColorMap));
        }
        if (historyIds != null) {
            gutters.add(new HistoryIdColumn(fileAnnotation, presentation, bgColorMap, historyIds));
        }
        gutters.add(new HighlightedAdditionalColumn(fileAnnotation, presentation, bgColorMap));
        AnnotateActionGroup actionGroup = new AnnotateActionGroup(gutters, editorGutter, bgColorMap);
        presentation.addAction((AnAction)actionGroup, 1);
        gutters.add(new ExtraFieldGutter(fileAnnotation, presentation, bgColorMap, actionGroup));
        presentation.addAction(new AnnotateCurrentRevisionAction(fileAnnotation, vcs));
        presentation.addAction(new AnnotatePreviousRevisionAction(fileAnnotation, vcs));
        AnnotateToggleAction.addActionsFromExtensions(presentation, fileAnnotation);
        for (AnnotationFieldGutter gutter : gutters) {
            AnnotationGutterLineConvertorProxy proxy = new AnnotationGutterLineConvertorProxy(upToDateLineNumbers, gutter);
            if (gutter.isGutterAction()) {
                editor.getGutter().registerTextAnnotation((TextAnnotationGutterProvider)proxy, (EditorGutterAction)proxy);
                continue;
            }
            editor.getGutter().registerTextAnnotation((TextAnnotationGutterProvider)proxy);
        }
    }

    private static void addActionsFromExtensions(@NotNull AnnotationPresentation presentation, @NotNull FileAnnotation fileAnnotation) {
        AnnotationGutterActionProvider[] extensions = (AnnotationGutterActionProvider[])AnnotationGutterActionProvider.EP_NAME.getExtensions();
        if (extensions.length > 0) {
            presentation.addAction((AnAction)new Separator());
        }
        for (AnnotationGutterActionProvider provider2 : extensions) {
            presentation.addAction(provider2.createAction(fileAnnotation));
        }
    }

    @Nullable
    private static Map<VcsRevisionNumber, Integer> computeLineNumbers(@NotNull FileAnnotation fileAnnotation) {
        HashMap<VcsRevisionNumber, Integer> numbers = new HashMap<VcsRevisionNumber, Integer>();
        List fileRevisionList = fileAnnotation.getRevisions();
        if (fileRevisionList != null) {
            int size = fileRevisionList.size();
            for (int i2 = 0; i2 < size; ++i2) {
                VcsFileRevision revision = (VcsFileRevision)fileRevisionList.get(i2);
                VcsRevisionNumber number = revision.getRevisionNumber();
                numbers.put(number, size - i2);
            }
        }
        return numbers.size() < 2 ? null : numbers;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static Couple<Map<VcsRevisionNumber, Color>> computeBgColors(@NotNull FileAnnotation fileAnnotation, @NotNull Editor editor) {
        FileAnnotation.RevisionsOrderProvider revisionsOrderProvider;
        HashMap<VcsRevisionNumber, Color> commitOrderColors = new HashMap<VcsRevisionNumber, Color>();
        HashMap<VcsRevisionNumber, Color> commitAuthorColors = new HashMap<VcsRevisionNumber, Color>();
        EditorColorsScheme colorScheme = editor.getColorsScheme();
        AnnotationsSettings settings = AnnotationsSettings.getInstance();
        List<Color> authorsColorPalette = settings.getAuthorsColors(colorScheme);
        List<Color> orderedColorPalette = settings.getOrderedColors(colorScheme);
        FileAnnotation.AuthorsMappingProvider authorsMappingProvider = fileAnnotation.getAuthorsMappingProvider();
        if (authorsMappingProvider != null) {
            Map authorsMap = authorsMappingProvider.getAuthors();
            HashMap<String, Color> authorColors = new HashMap<String, Color>();
            for (String string : ContainerUtil.sorted(authorsMap.values(), Comparing::compare)) {
                int index = authorColors.size();
                Color color = authorsColorPalette.get(index % authorsColorPalette.size());
                authorColors.put(string, color);
            }
            for (Map.Entry entry : authorsMap.entrySet()) {
                VcsRevisionNumber revision = (VcsRevisionNumber)entry.getKey();
                String author = (String)entry.getValue();
                Color color = (Color)authorColors.get(author);
                commitAuthorColors.put(revision, color);
            }
        }
        if ((revisionsOrderProvider = fileAnnotation.getRevisionsOrderProvider()) != null) {
            void var12_17;
            List orderedRevisions = revisionsOrderProvider.getOrderedRevisions();
            int revisionsCount = orderedRevisions.size();
            boolean bl = false;
            while (var12_17 < revisionsCount) {
                Color color = orderedColorPalette.get(orderedColorPalette.size() * var12_17 / revisionsCount);
                for (VcsRevisionNumber number : (List)orderedRevisions.get((int)var12_17)) {
                    commitOrderColors.put(number, color);
                }
                ++var12_17;
            }
        }
        return Couple.of(commitOrderColors.size() > 1 ? commitOrderColors : null, commitAuthorColors.size() > 1 ? commitAuthorColors : null);
    }

    @Nullable
    private static Provider getProvider(AnActionEvent e) {
        for (Provider provider2 : (Provider[])EP_NAME.getExtensions()) {
            if (!provider2.isEnabled(e)) continue;
            return provider2;
        }
        return null;
    }

    private static class MyEditorNotificationPanel
    extends EditorNotificationPanel {
        private final Editor myEditor;
        private final Runnable myShowAnnotations;

        public MyEditorNotificationPanel(@NotNull Editor editor, @NotNull AbstractVcs vcs, @NotNull Runnable doShowAnnotations) {
            super(LightColors.RED);
            this.myEditor = editor;
            this.myShowAnnotations = doShowAnnotations;
            this.setText(VcsBundle.message((String)"annotation.wrong.line.number.notification.text", (Object[])new Object[]{vcs.getDisplayName()}));
            this.createActionLabel("Display anyway", () -> this.showAnnotations());
            this.createActionLabel("Hide", () -> this.hideNotification()).setToolTipText("Hide this notification");
        }

        public void showAnnotations() {
            this.hideNotification();
            this.myShowAnnotations.run();
        }

        private void hideNotification() {
            this.setVisible(false);
            if (this.myEditor.getHeaderComponent() == this) {
                this.myEditor.setHeaderComponent(null);
            }
        }
    }

    public static interface Provider {
        public boolean isEnabled(AnActionEvent var1);

        public boolean isSuspended(AnActionEvent var1);

        public boolean isAnnotated(AnActionEvent var1);

        public void perform(AnActionEvent var1, boolean var2);
    }
}

