/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineNumberListener;
import com.intellij.openapi.vcs.annotate.TextAnnotationPresentation;
import com.intellij.openapi.vcs.annotate.UpToDateLineNumberListener;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AnnotationPresentation
implements TextAnnotationPresentation {
    @NotNull
    private final FileAnnotation myFileAnnotation;
    @NotNull
    private final UpToDateLineNumberProvider myUpToDateLineNumberProvider;
    @Nullable
    private final AnnotationSourceSwitcher mySwitcher;
    private final ArrayList<AnAction> myActions = new ArrayList();
    @NotNull
    private final Disposable myDisposable;
    private boolean myDisposed = false;

    AnnotationPresentation(@NotNull FileAnnotation fileAnnotation, @NotNull UpToDateLineNumberProvider upToDateLineNumberProvider, @Nullable AnnotationSourceSwitcher switcher, @NotNull Disposable disposable) {
        this.myUpToDateLineNumberProvider = upToDateLineNumberProvider;
        this.myFileAnnotation = fileAnnotation;
        this.mySwitcher = switcher;
        this.myDisposable = disposable;
    }

    @Override
    public EditorFontType getFontType(int line) {
        VcsRevisionNumber revision = this.myFileAnnotation.originalRevision(line);
        VcsRevisionNumber currentRevision = this.myFileAnnotation.getCurrentRevision();
        return currentRevision != null && currentRevision.equals(revision) ? EditorFontType.BOLD : EditorFontType.PLAIN;
    }

    @Override
    public ColorKey getColor(int line) {
        if (this.mySwitcher == null) {
            return AnnotationSource.LOCAL.getColor();
        }
        return this.mySwitcher.getAnnotationSource(line).getColor();
    }

    @Override
    public List<AnAction> getActions(int line) {
        int correctedNumber = this.myUpToDateLineNumberProvider.getLineNumber(line);
        for (AnAction action : this.myActions) {
            LineNumberListener listener2;
            UpToDateLineNumberListener upToDateListener = (UpToDateLineNumberListener)ObjectUtils.tryCast((Object)action, UpToDateLineNumberListener.class);
            if (upToDateListener != null) {
                upToDateListener.consume((Object)correctedNumber);
            }
            if ((listener2 = (LineNumberListener)ObjectUtils.tryCast((Object)action, LineNumberListener.class)) == null) continue;
            listener2.consume((Object)line);
        }
        return this.myActions;
    }

    @NotNull
    public List<AnAction> getActions() {
        return this.myActions;
    }

    public void addAction(AnAction action) {
        this.myActions.add(action);
    }

    public void addAction(AnAction action, int index) {
        this.myActions.add(index, action);
    }

    @Override
    public void gutterClosed() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        Disposer.dispose((Disposable)this.myDisposable);
    }
}

