/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.actions.AnnotationFieldGutter;
import com.intellij.openapi.vcs.actions.ShortNameType;
import com.intellij.openapi.vcs.actions.ShowShortenNames;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.TextAnnotationPresentation;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AspectAnnotationFieldGutter
extends AnnotationFieldGutter {
    @NotNull
    protected final LineAnnotationAspect myAspect;
    private final boolean myIsGutterAction;

    public AspectAnnotationFieldGutter(@NotNull FileAnnotation annotation, @NotNull LineAnnotationAspect aspect, @NotNull TextAnnotationPresentation presentation, @Nullable Couple<Map<VcsRevisionNumber, Color>> colorScheme) {
        super(annotation, presentation, colorScheme);
        this.myAspect = aspect;
        this.myIsGutterAction = this.myAspect instanceof EditorGutterAction;
    }

    @Override
    public boolean isGutterAction() {
        return this.myIsGutterAction;
    }

    public String getLineText(int line, Editor editor) {
        String value2;
        String string = value2 = this.isAvailable() ? this.myAspect.getValue(line) : "";
        if (this.myAspect.getId() == LineAnnotationAspect.AUTHOR) {
            return ShortNameType.shorten(value2, ShowShortenNames.getType());
        }
        return value2;
    }

    @Override
    @Nullable
    public String getToolTip(int line, Editor editor) {
        return this.isAvailable() ? XmlStringUtil.escapeString((String)this.myAnnotation.getToolTip(line)) : null;
    }

    @Override
    public void doAction(int line) {
        if (this.myIsGutterAction) {
            ((EditorGutterAction)this.myAspect).doAction(line);
        }
    }

    @Override
    public Cursor getCursor(int line) {
        if (this.myIsGutterAction) {
            return ((EditorGutterAction)this.myAspect).getCursor(line);
        }
        return super.getCursor(line);
    }

    @Override
    public boolean isShowByDefault() {
        return this.myAspect.isShowByDefault();
    }

    @Override
    @Nullable
    public String getID() {
        return this.myAspect.getId();
    }
}

