/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractCommonCheckinAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonCheckinFilesAction
extends AbstractCommonCheckinAction {
    @Override
    protected String getActionName(@NotNull VcsContext dataContext) {
        String actionName = Optional.ofNullable(dataContext.getProject()).map(project2 -> CommonCheckinFilesAction.getCommonVcs(this.getRootsStream(dataContext), project2)).map(AbstractVcs::getCheckinEnvironment).map(CheckinEnvironment::getCheckinOperationName).orElse(VcsBundle.message((String)"vcs.command.name.checkin", (Object[])new Object[0]));
        return this.modifyCheckinActionName(dataContext, actionName);
    }

    private String modifyCheckinActionName(@NotNull VcsContext dataContext, String checkinActionName) {
        String result2 = checkinActionName;
        List roots = this.getRootsStream(dataContext).limit(2L).collect(Collectors.toList());
        if (!roots.isEmpty()) {
            String messageKey = ((FilePath)roots.get(0)).isDirectory() ? "action.name.checkin.directory" : "action.name.checkin.file";
            result2 = VcsBundle.message((String)StringUtil.pluralize((String)messageKey, (int)roots.size()), (Object[])new Object[]{checkinActionName});
        }
        return result2;
    }

    @Override
    protected String getMnemonicsFreeActionName(@NotNull VcsContext context) {
        return this.modifyCheckinActionName(context, VcsBundle.message((String)"vcs.command.name.checkin.no.mnemonics", (Object[])new Object[0]));
    }

    @Override
    @Nullable
    protected LocalChangeList getInitiallySelectedChangeList(@NotNull VcsContext context, @NotNull Project project2) {
        ChangeListManager manager = ChangeListManager.getInstance((Project)project2);
        LocalChangeList defaultChangeList = manager.getDefaultChangeList();
        LocalChangeList result2 = null;
        for (FilePath root : this.getRoots(context)) {
            if (root.getVirtualFile() == null) continue;
            Collection changes = manager.getChangesIn(root);
            if (defaultChangeList != null && CommonCheckinFilesAction.containsAnyChange(defaultChangeList, changes)) {
                return defaultChangeList;
            }
            result2 = changes.stream().findFirst().map(arg_0 -> ((ChangeListManager)manager).getChangeList(arg_0)).orElse(null);
        }
        return (LocalChangeList)ObjectUtils.chooseNotNull(result2, (Object)defaultChangeList);
    }

    @Override
    protected boolean approximatelyHasRoots(@NotNull VcsContext dataContext) {
        FileStatusManager manager = FileStatusManager.getInstance((Project)dataContext.getProject());
        return this.getRootsStream(dataContext).map(FilePath::getVirtualFile).filter(Objects::nonNull).anyMatch(file2 -> this.isApplicableRoot((VirtualFile)file2, manager.getStatus(file2), dataContext));
    }

    protected boolean isApplicableRoot(@NotNull VirtualFile file2, @NotNull FileStatus status, @NotNull VcsContext dataContext) {
        return status != FileStatus.UNKNOWN && status != FileStatus.IGNORED;
    }

    @Override
    @NotNull
    protected FilePath[] getRoots(@NotNull VcsContext context) {
        return context.getSelectedFilePaths();
    }

    @NotNull
    protected Stream<FilePath> getRootsStream(@NotNull VcsContext context) {
        return context.getSelectedFilePathsStream();
    }

    private static boolean containsAnyChange(@NotNull LocalChangeList changeList, @NotNull Collection<Change> changes) {
        return changes.stream().anyMatch(changeList.getChanges()::contains);
    }

    @Nullable
    private static AbstractVcs getCommonVcs(@NotNull Stream<FilePath> roots, @NotNull Project project2) {
        return UtilKt.getIfSingle(roots.map(root -> VcsUtil.getVcsFor((Project)project2, (FilePath)root)).filter(Objects::nonNull).distinct().limit(Math.min(2, ProjectLevelVcsManager.getInstance((Project)project2).getAllActiveVcss().length)));
    }
}

