/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontPanelFactory;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.NewColorAndFontPanel;
import com.intellij.application.options.colors.OptionsPanelImpl;
import com.intellij.application.options.colors.SchemesPanel;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorAndFontDescriptorsProvider;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.vcs.actions.AnnotationsSettings;
import com.intellij.openapi.vcs.actions.VcsPreviewPanel;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VcsColorsPageFactory
implements ColorAndFontPanelFactory,
ColorAndFontDescriptorsProvider,
DisplayPrioritySortable {
    public static final String VCS_GROUP = ApplicationBundle.message((String)"title.vcs", (Object[])new Object[0]);

    @Override
    @NotNull
    public NewColorAndFontPanel createPanel(final @NotNull ColorAndFontOptions options) {
        SchemesPanel schemesPanel = new SchemesPanel(options);
        final OptionsPanelImpl optionsPanel = new OptionsPanelImpl(options, schemesPanel, VCS_GROUP);
        final VcsPreviewPanel previewPanel = new VcsPreviewPanel();
        schemesPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void schemeChanged(Object source) {
                previewPanel.setColorScheme(options.getSelectedScheme());
                optionsPanel.updateOptionsList();
            }
        });
        return new NewColorAndFontPanel(schemesPanel, optionsPanel, previewPanel, VCS_GROUP, null, null);
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        return new AttributesDescriptor[0];
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        ArrayList<ColorDescriptor> descriptors = new ArrayList<ColorDescriptor>();
        descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.added.lines", (Object[])new Object[0]), EditorColors.ADDED_LINES_COLOR, ColorDescriptor.Kind.BACKGROUND));
        descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.modified.lines", (Object[])new Object[0]), EditorColors.MODIFIED_LINES_COLOR, ColorDescriptor.Kind.BACKGROUND));
        descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.deleted.lines", (Object[])new Object[0]), EditorColors.DELETED_LINES_COLOR, ColorDescriptor.Kind.BACKGROUND));
        descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.whitespaces.modified.lines", (Object[])new Object[0]), EditorColors.WHITESPACES_MODIFIED_LINES_COLOR, ColorDescriptor.Kind.BACKGROUND));
        descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.border.lines", (Object[])new Object[0]), EditorColors.BORDER_LINES_COLOR, ColorDescriptor.Kind.BACKGROUND));
        descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.vcs.annotations", (Object[])new Object[0]), EditorColors.ANNOTATIONS_COLOR, ColorDescriptor.Kind.FOREGROUND));
        List<ColorKey> colorKeys = AnnotationsSettings.ANCHOR_COLOR_KEYS;
        for (int i2 = 0; i2 < colorKeys.size(); ++i2) {
            descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.vcs.annotations.color.n", (Object[])new Object[]{i2 + 1}), colorKeys.get(i2), ColorDescriptor.Kind.BACKGROUND));
        }
        return (ColorDescriptor[])ArrayUtil.toObjectArray(descriptors, ColorDescriptor.class);
    }

    @Override
    @NotNull
    public String getPanelDisplayName() {
        return VCS_GROUP;
    }

    @NotNull
    public String getDisplayName() {
        return VCS_GROUP;
    }

    public DisplayPriority getPriority() {
        return DisplayPriority.COMMON_SETTINGS;
    }
}

