/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.annotate;

import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import org.jetbrains.annotations.NotNull;

public class AnnotationsPreloader {
    private static final Logger LOG = Logger.getInstance(AnnotationsPreloader.class);
    private final MergingUpdateQueue myUpdateQueue;
    private final Project myProject;

    public AnnotationsPreloader(Project project2) {
        this.myProject = project2;
        this.myUpdateQueue = new MergingUpdateQueue("Annotations preloader queue", 1000, true, null, (Disposable)project2, null, false);
        project2.getMessageBus().connect((Disposable)project2).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (!AnnotationsPreloader.isEnabled()) {
                    return;
                }
                VirtualFile file2 = event.getNewFile();
                if (file2 != null) {
                    AnnotationsPreloader.this.schedulePreloading(file2);
                }
            }
        });
    }

    private static boolean isEnabled() {
        return Registry.is((String)"vcs.annotations.preload") && !PowerSaveMode.isEnabled();
    }

    private void schedulePreloading(final @NotNull VirtualFile file2) {
        if (this.myProject.isDisposed() || file2.getFileType().isBinary()) {
            return;
        }
        this.myUpdateQueue.queue(new Update(file2){

            public void run() {
                try {
                    long start = 0L;
                    if (LOG.isDebugEnabled()) {
                        start = System.currentTimeMillis();
                    }
                    if (!FileEditorManager.getInstance((Project)AnnotationsPreloader.this.myProject).isFileOpen(file2)) {
                        return;
                    }
                    FileStatus fileStatus = FileStatusManager.getInstance((Project)AnnotationsPreloader.this.myProject).getStatus(file2);
                    if (fileStatus == FileStatus.UNKNOWN || fileStatus == FileStatus.ADDED || fileStatus == FileStatus.IGNORED) {
                        return;
                    }
                    AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)AnnotationsPreloader.this.myProject).getVcsFor(file2);
                    if (vcs == null) {
                        return;
                    }
                    AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
                    if (annotationProvider == null || !annotationProvider.isCaching()) {
                        return;
                    }
                    annotationProvider.annotate(file2);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Preloaded VCS annotations for ", new Object[]{file2.getName(), " in ", String.valueOf(System.currentTimeMillis() - start), "ms"});
                    }
                }
                catch (VcsException e) {
                    LOG.info((Throwable)e);
                }
            }
        });
    }
}

