/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.impl.CacheDiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CacheChangeProcessor
extends CacheDiffRequestProcessor<ChangeWrapper> {
    private static final Logger LOG = Logger.getInstance(CacheChangeProcessor.class);
    @Nullable
    private Change myCurrentChange;

    public CacheChangeProcessor(@NotNull Project project2) {
        super(project2);
    }

    public CacheChangeProcessor(@NotNull Project project2, @NotNull String place) {
        super(project2, place);
    }

    @NotNull
    protected abstract List<Change> getSelectedChanges();

    @NotNull
    protected abstract List<Change> getAllChanges();

    protected abstract void selectChange(@NotNull Change var1);

    @Override
    @NotNull
    protected String getRequestName(@NotNull ChangeWrapper wrapper) {
        return ChangeDiffRequestProducer.getRequestTitle(wrapper.change);
    }

    @Override
    protected ChangeWrapper getCurrentRequestProvider() {
        return this.myCurrentChange != null ? new ChangeWrapper(this.myCurrentChange) : null;
    }

    @Override
    @Nullable
    protected DiffRequest loadRequestFast(@NotNull ChangeWrapper wrapper) {
        DiffRequest request = super.loadRequestFast(wrapper);
        if (request != null) {
            return request;
        }
        if (wrapper.change.getBeforeRevision() instanceof FakeRevision || wrapper.change.getAfterRevision() instanceof FakeRevision) {
            return new LoadingDiffRequest(ChangeDiffRequestProducer.getRequestTitle(wrapper.change));
        }
        return null;
    }

    @Override
    @NotNull
    protected DiffRequest loadRequest(@NotNull ChangeWrapper provider2, @NotNull ProgressIndicator indicator) throws ProcessCanceledException, DiffRequestProducerException {
        ChangeDiffRequestProducer presentable = ChangeDiffRequestProducer.create(this.getProject(), provider2.change);
        if (presentable == null) {
            return new ErrorDiffRequest("Can't show diff");
        }
        return presentable.process((UserDataHolder)this.getContext(), indicator);
    }

    @Override
    @NotNull
    public Project getProject() {
        return super.getProject();
    }

    public void clear() {
        this.myCurrentChange = null;
        this.updateRequest();
    }

    public void refresh() {
        Change selectedChange;
        List<Change> selectedChanges = this.getSelectedChanges();
        if (selectedChanges.isEmpty()) {
            this.myCurrentChange = null;
            this.updateRequest();
            return;
        }
        Change change = selectedChange = this.myCurrentChange != null ? (Change)ContainerUtil.find(selectedChanges, (Object)this.myCurrentChange) : null;
        if (selectedChange == null) {
            this.myCurrentChange = selectedChanges.get(0);
            this.updateRequest();
            return;
        }
        if (!ChangeDiffRequestProducer.isEquals(this.myCurrentChange, selectedChange)) {
            this.myCurrentChange = selectedChange;
            this.updateRequest();
        }
    }

    @Override
    protected boolean hasNextChange() {
        if (this.myCurrentChange == null) {
            return false;
        }
        List<Change> selectedChanges = this.getSelectedChanges();
        if (selectedChanges.isEmpty()) {
            return false;
        }
        if (selectedChanges.size() > 1) {
            int index = selectedChanges.indexOf(this.myCurrentChange);
            return index != -1 && index < selectedChanges.size() - 1;
        }
        List<Change> allChanges = this.getAllChanges();
        int index = allChanges.indexOf(this.myCurrentChange);
        return index != -1 && index < allChanges.size() - 1;
    }

    @Override
    protected boolean hasPrevChange() {
        if (this.myCurrentChange == null) {
            return false;
        }
        List<Change> selectedChanges = this.getSelectedChanges();
        if (selectedChanges.isEmpty()) {
            return false;
        }
        if (selectedChanges.size() > 1) {
            int index = selectedChanges.indexOf(this.myCurrentChange);
            return index != -1 && index > 0;
        }
        List<Change> allChanges = this.getAllChanges();
        int index = allChanges.indexOf(this.myCurrentChange);
        return index != -1 && index > 0;
    }

    @Override
    protected void goToNextChange(boolean fromDifferences) {
        List<Change> selectedChanges = this.getSelectedChanges();
        List<Change> allChanges = this.getAllChanges();
        if (selectedChanges.size() > 1) {
            int index = selectedChanges.indexOf(this.myCurrentChange);
            this.myCurrentChange = selectedChanges.get(index + 1);
        } else {
            int index = allChanges.indexOf(this.myCurrentChange);
            this.myCurrentChange = allChanges.get(index + 1);
            this.selectChange(this.myCurrentChange);
        }
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE : null);
    }

    @Override
    protected void goToPrevChange(boolean fromDifferences) {
        List<Change> selectedChanges = this.getSelectedChanges();
        List<Change> allChanges = this.getAllChanges();
        if (selectedChanges.size() > 1) {
            int index = selectedChanges.indexOf(this.myCurrentChange);
            this.myCurrentChange = selectedChanges.get(index - 1);
        } else {
            int index = allChanges.indexOf(this.myCurrentChange);
            this.myCurrentChange = allChanges.get(index - 1);
            this.selectChange(this.myCurrentChange);
        }
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.LAST_CHANGE : null);
    }

    @Override
    protected boolean isNavigationEnabled() {
        return this.getSelectedChanges().size() > 1 || this.getAllChanges().size() > 1;
    }

    protected static class ChangeWrapper {
        @NotNull
        private final Change change;

        private ChangeWrapper(@NotNull Change change) {
            this.change = change;
        }

        public boolean equals(Object obj) {
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            return ChangeDiffRequestProducer.isEquals(((ChangeWrapper)obj).change, this.change);
        }

        public int hashCode() {
            return ChangeDiffRequestProducer.hashCode(this.change);
        }

        public String toString() {
            return String.format("CacheChangeProcessor.ChangeWrapper: %s (%s - %s)", this.change.getClass(), ChangeWrapper.toString(this.change.getBeforeRevision()), ChangeWrapper.toString(this.change.getAfterRevision()));
        }

        @NotNull
        private static String toString(@Nullable ContentRevision revision) {
            if (revision == null) {
                return "null";
            }
            return revision.getClass() + ":" + revision.toString();
        }
    }
}

