/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vcs.changes.FictiveBackgroundable;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.Waiter;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CallbackData {
    private static final Logger LOG = Logger.getInstance(CallbackData.class);
    @NotNull
    private final Runnable myCallback;
    @NotNull
    private final Runnable myWrapperStarter;

    CallbackData(@NotNull Runnable callback, @NotNull Runnable wrapperStarter) {
        this.myCallback = callback;
        this.myWrapperStarter = wrapperStarter;
    }

    @NotNull
    public Runnable getCallback() {
        return this.myCallback;
    }

    @NotNull
    public Runnable getWrapperStarter() {
        return this.myWrapperStarter;
    }

    @NotNull
    public static CallbackData create(@NotNull Project project2, @NotNull InvokeAfterUpdateMode mode, @NotNull Runnable afterUpdate, @Nullable String title, @Nullable ModalityState state) {
        return mode.isSilent() ? CallbackData.createSilent(project2, mode, afterUpdate) : CallbackData.createInteractive(project2, mode, afterUpdate, title, state);
    }

    @NotNull
    private static CallbackData createSilent(@NotNull Project project2, @NotNull InvokeAfterUpdateMode mode, @NotNull Runnable afterUpdate) {
        Consumer<Runnable> callbackCaller = mode.isCallbackOnAwt() ? arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0) : arg_0 -> ((Application)ApplicationManager.getApplication()).executeOnPooledThread(arg_0);
        Runnable callback = () -> {
            CallbackData.logUpdateFinished(project2, mode);
            if (!project2.isDisposed()) {
                afterUpdate.run();
            }
        };
        return new CallbackData(() -> callbackCaller.accept(callback), EmptyRunnable.INSTANCE);
    }

    @NotNull
    private static CallbackData createInteractive(@NotNull Project project2, @NotNull InvokeAfterUpdateMode mode, @NotNull Runnable afterUpdate, String title, @Nullable ModalityState state) {
        Object task = mode.isSynchronous() ? new Waiter(project2, afterUpdate, title, mode.isCancellable()) : new FictiveBackgroundable(project2, afterUpdate, title, mode.isCancellable(), state);
        Runnable callback = () -> CallbackData.lambda$createInteractive$2(project2, mode, (Task)task);
        return new CallbackData(callback, () -> CallbackData.lambda$createInteractive$3((Task)task));
    }

    private static void setDone(@NotNull Task task) {
        if (task instanceof Waiter) {
            ((Waiter)task).done();
        } else if (task instanceof FictiveBackgroundable) {
            ((FictiveBackgroundable)task).done();
        } else {
            throw new IllegalArgumentException("Unknown task type " + task.getClass());
        }
    }

    private static void logUpdateFinished(@NotNull Project project2, @NotNull InvokeAfterUpdateMode mode) {
        LOG.debug(mode + " changes update finished for project " + project2.getName());
    }

    private static /* synthetic */ void lambda$createInteractive$3(Task task) {
        ProgressManager.getInstance().run(task);
    }

    private static /* synthetic */ void lambda$createInteractive$2(@NotNull Project project2, @NotNull InvokeAfterUpdateMode mode, Task task) {
        CallbackData.logUpdateFinished(project2, mode);
        CallbackData.setDone(task);
    }
}

