/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.google.common.primitives.Ints;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListUtil {
    @Nullable
    public static LocalChangeList getPredefinedChangeList(@NotNull String defaultName, @NotNull ChangeListManager changeListManager) {
        LocalChangeList sameNamedList = changeListManager.findChangeList(defaultName);
        if (sameNamedList != null) {
            return sameNamedList;
        }
        return ChangeListUtil.tryToMatchWithExistingChangelist(changeListManager, defaultName);
    }

    @Nullable
    private static LocalChangeList tryToMatchWithExistingChangelist(@NotNull ChangeListManager changeListManager, @NotNull String defaultName) {
        List matched = ContainerUtil.findAll((Collection)changeListManager.getChangeListsCopy(), list -> defaultName.contains(list.getName().trim()));
        return matched.isEmpty() ? null : (LocalChangeList)Collections.max(matched, (o1, o2) -> Ints.compare((int)o1.getName().trim().length(), (int)o2.getName().trim().length()));
    }
}

