/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.util.Alarm;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class ControlledCycle {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ControlledCycle");
    private final Alarm mySimpleAlarm;
    private static final int ourRefreshInterval = 10000;
    private int myRefreshInterval;
    private final Runnable myRunnable;
    private final AtomicBoolean myActive;

    public ControlledCycle(final @NotNull Project project2, final Getter<Boolean> callback, @NotNull String name, int refreshInterval) {
        this.myRefreshInterval = refreshInterval <= 0 ? 10000 : refreshInterval;
        this.myActive = new AtomicBoolean(false);
        this.myRunnable = new Runnable(){
            boolean shouldBeContinued = true;

            @Override
            public void run() {
                if (!ControlledCycle.this.myActive.get() || project2.isDisposed()) {
                    return;
                }
                try {
                    this.shouldBeContinued = (Boolean)callback.get();
                }
                catch (ProcessCanceledException e) {
                    return;
                }
                catch (RuntimeException e) {
                    LOG.info((Throwable)e);
                }
                if (!this.shouldBeContinued) {
                    ControlledCycle.this.myActive.set(false);
                } else {
                    ControlledCycle.this.mySimpleAlarm.addRequest(ControlledCycle.this.myRunnable, ControlledCycle.this.myRefreshInterval);
                }
            }
        };
        this.mySimpleAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project2);
    }

    public boolean startIfNotStarted(int refreshInterval) {
        boolean wasSet;
        boolean refreshIntervalChanged;
        boolean bl = refreshIntervalChanged = refreshInterval > 0 && refreshInterval != this.myRefreshInterval;
        if (refreshIntervalChanged) {
            this.mySimpleAlarm.cancelAllRequests();
        }
        if (refreshInterval > 0) {
            this.myRefreshInterval = refreshInterval;
        }
        if ((wasSet = this.myActive.compareAndSet(false, true)) || refreshIntervalChanged) {
            this.mySimpleAlarm.addRequest(this.myRunnable, this.myRefreshInterval);
        }
        return wasSet;
    }

    public void stop() {
        this.myActive.set(false);
    }
}

